/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.SequentialBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

class SequentialReadBenchmark
extends SequentialBenchmark {
    private String[] filenames;

    SequentialReadBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
    }

    @Override
    void prepareBenchmark() throws Exception {
        this.filenames = this.volumeManager.getSequentialFilelistForVolume(this.volume, this.benchmarkSize);
    }

    @Override
    long performIO(byte[] data, long numberOfBlocks) throws IOException {
        FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), this.filenames[0], GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
        try {
            return this.tryPerformIO(data, numberOfBlocks, fileHandle);
        }
        catch (IOException e) {
            fileHandle.close();
            throw e;
        }
    }

    private long tryPerformIO(byte[] data, long numberOfBlocks, FileHandle fileHandle) throws IOException {
        long byteCounter = 0L;
        for (long j = 0L; !cancelled && j < numberOfBlocks; ++j) {
            long nextOffset = j * (long)this.requestSize;
            assert (nextOffset >= 0L) : "Offset < 0 not allowed";
            byteCounter += (long)fileHandle.read(this.config.getUserCredentials(), data, this.requestSize, nextOffset);
        }
        fileHandle.close();
        return byteCounter;
    }
}

