/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.SequentialBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

class SequentialWriteBenchmark
extends SequentialBenchmark {
    private LinkedList<String> filenames = new LinkedList();

    SequentialWriteBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
    }

    @Override
    long performIO(byte[] data, long numberOfBlocks) throws IOException {
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber();
        FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), "benchmarks/sequentialBenchmark/benchFile0", flags, 511);
        try {
            return this.tryPerformIO(data, numberOfBlocks, fileHandle);
        }
        catch (IOException e) {
            fileHandle.close();
            throw e;
        }
    }

    private long tryPerformIO(byte[] data, long numberOfBlocks, FileHandle fileHandle) throws IOException {
        Random random = new Random();
        this.filenames.add("benchmarks/sequentialBenchmark/benchFile0");
        long byteCounter = 0L;
        for (long j = 0L; !cancelled && j < numberOfBlocks; ++j) {
            long nextOffset = j * (long)this.requestSize;
            assert (nextOffset >= 0L) : "Offset < 0 not allowed";
            random.nextBytes(data);
            byteCounter += (long)fileHandle.write(this.config.getUserCredentials(), data, this.requestSize, nextOffset);
        }
        fileHandle.close();
        return byteCounter;
    }

    @Override
    void finalizeBenchmark() throws Exception {
        this.volumeManager.setSequentialFilelistForVolume(this.volume, this.filenames);
        this.volumeManager.addCreatedFiles(this.volume, this.filenames);
    }
}

