/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.FilebasedBenchmark;
import org.xtreemfs.common.benchmark.SequentialBenchmark;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.AdminVolume;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

class VolumeManager {
    private static final String VOLUME_BASE_NAME = "benchmark";
    private BenchmarkConfig config;
    private AdminClient client;
    private int currentPosition;
    private LinkedList<Volume> volumes;
    private LinkedList<Volume> createdVolumes;
    private HashMap<Volume, HashSet<String>> createdFiles;
    private HashMap<Volume, String[]> filelistsSequentialBenchmark;
    private HashMap<Volume, String[]> filelistsRandomBenchmark;

    VolumeManager(BenchmarkConfig config, AdminClient client) throws Exception {
        this.config = config;
        this.currentPosition = 0;
        this.client = client;
        this.volumes = new LinkedList();
        this.createdVolumes = new LinkedList();
        this.filelistsSequentialBenchmark = new HashMap(5);
        this.filelistsRandomBenchmark = new HashMap(5);
        this.createdFiles = new HashMap();
    }

    Volume getNextVolume() {
        return this.volumes.get(this.currentPosition++);
    }

    void reset() {
        this.currentPosition = 0;
    }

    void createDefaultVolumes(int numberOfVolumes) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        for (int i = 0; i < numberOfVolumes; ++i) {
            Volume volume = this.createAndOpenVolume(VOLUME_BASE_NAME + i);
            this.addToVolumes(volume);
        }
    }

    private void addToVolumes(Volume volume) {
        if (!this.volumes.contains(volume)) {
            this.volumes.add(volume);
        }
    }

    void openVolumes(String ... volumeName) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.volumes = new LinkedList();
        for (String each : volumeName) {
            this.volumes.add(this.createAndOpenVolume(each));
        }
        this.verifyVolumeSizes();
    }

    private Volume createAndOpenVolume(String volumeName) throws IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        AdminVolume volume = null;
        try {
            ArrayList<GlobalTypes.KeyValuePair> volumeAttributes = new ArrayList<GlobalTypes.KeyValuePair>();
            this.client.createVolume(this.config.getAuth(), this.config.getUserCredentials(), volumeName, 511, this.config.getUsername(), this.config.getGroup(), GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX, GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0, 128, 1, volumeAttributes);
            volume = this.client.openVolume(volumeName, this.config.getSslOptions(), this.config.getOptions());
            this.createdVolumes.add(volume);
            Logging.logMessage(6, Logging.Category.tool, this, "Created volume %s", volumeName);
        }
        catch (PosixErrorException e) {
            if (e.getPosixError() == RPC.POSIXErrno.POSIX_ERROR_EEXIST) {
                volume = this.client.openVolume(volumeName, this.config.getSslOptions(), this.config.getOptions());
            }
            throw e;
        }
        this.setStripeSizeAndWidth(volume);
        this.createDirStructure(volume);
        if (!this.config.getOsdSelectionPolicies().equals("")) {
            volume.setOSDSelectionPolicy(this.config.getUserCredentials(), this.config.getOsdSelectionPolicies());
        }
        Map<String, String> attributes = this.config.getPolicyAttributes();
        for (String attribute : attributes.keySet()) {
            volume.setPolicyAttribute(this.config.getUserCredentials(), attribute, attributes.get(attribute));
        }
        if (!this.config.getReplicationPolicy().equals("")) {
            volume.setDefaultReplicationPolicy(this.config.getUserCredentials(), "/", this.config.getReplicationPolicy(), this.config.getReplicationFactor(), 0);
        }
        return volume;
    }

    private void verifyVolumeSizes() throws IOException {
        int stripeSize = this.getVolStripeSize(this.volumes.getFirst());
        int stripeWidth = this.getVolStripeWidth(this.volumes.getFirst());
        boolean flag = false;
        for (Volume volume : this.volumes) {
            if (stripeSize != this.getVolStripeSize(volume)) {
                flag = true;
            }
            if (stripeWidth == this.getVolStripeWidth(volume)) continue;
            flag = true;
        }
        if (flag) {
            Logging.logMessage(4, Logging.Category.tool, this, "The stripe size and width of all volumes is not equal (it should to achieve meaningful benchmarks", new Object[0]);
        }
    }

    private void setStripeSizeAndWidth(Volume volume) throws IOException {
        int width;
        int size;
        int sizeConf = this.config.getStripeSizeInKiB();
        int widthConf = this.config.getStripeWidth();
        int sizeVol = this.getVolStripeSize(volume);
        int widthVol = this.getVolStripeWidth(volume);
        if (!this.config.isStripeSizeSet().booleanValue() && !this.config.isStripeWidthSet().booleanValue()) {
            this.config.setStripeSizeInBytes(sizeVol * 1024);
            this.config.setStripeWidth(widthVol);
            return;
        }
        if (!this.config.isStripeSizeSet().booleanValue() && this.config.isStripeWidthSet().booleanValue()) {
            size = sizeVol;
            width = widthConf;
        } else if (this.config.isStripeSizeSet().booleanValue() && !this.config.isStripeWidthSet().booleanValue()) {
            size = sizeConf;
            width = widthVol;
        } else if (this.config.isStripeSizeSet().booleanValue() && this.config.isStripeWidthSet().booleanValue()) {
            size = sizeConf;
            width = widthConf;
        } else {
            throw new UnknownError("Logical error. The above if-else statements should have been exhausting");
        }
        String val = "{\"pattern\":\"STRIPING_POLICY_RAID0\",\"width\":" + width + ",\"size\":" + size + "}";
        volume.setXAttr(this.config.getUserCredentials(), "", "xtreemfs.default_sp", val, MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
        this.config.setStripeSizeInBytes(size * 1024);
        this.config.setStripeWidth(width);
    }

    private int getVolStripeSize(Volume volume) throws IOException {
        String valueStr = volume.getXAttr(this.config.getUserCredentials(), "", "xtreemfs.default_sp");
        String sizeStr = valueStr.split(",")[2];
        return Integer.valueOf(sizeStr.substring(sizeStr.indexOf(":") + 1, sizeStr.length() - 1));
    }

    private int getVolStripeWidth(Volume volume) throws IOException {
        String valueStr = volume.getXAttr(this.config.getUserCredentials(), "", "xtreemfs.default_sp");
        String widthStr = valueStr.split(",")[1];
        return Integer.valueOf(widthStr.substring(widthStr.indexOf(":") + 1));
    }

    private void createDirStructure(Volume volume) throws IOException {
        this.createDir(volume, "/benchmarks/sequentialBenchmark");
        this.createDir(volume, "/benchmarks/randomBenchmark");
    }

    private void createDir(Volume volume, String directory) throws IOException {
        block2: {
            try {
                volume.createDirectory(this.config.getUserCredentials(), directory, 511, true);
                Logging.logMessage(6, Logging.Category.tool, this, "/benchmarks/randomBenchmark created on volume %s", volume.getVolumeName());
            }
            catch (PosixErrorException e) {
                if (e.getPosixError() == RPC.POSIXErrno.POSIX_ERROR_EEXIST) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSequentialFilelistForVolume(Volume volume, LinkedList<String> filelist) {
        String[] files = new String[filelist.size()];
        VolumeManager volumeManager = this;
        synchronized (volumeManager) {
            this.filelistsSequentialBenchmark.put(volume, filelist.toArray(files));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRandomFilelistForVolume(Volume volume, LinkedList<String> filelist) {
        String[] files = new String[filelist.size()];
        VolumeManager volumeManager = this;
        synchronized (volumeManager) {
            this.filelistsRandomBenchmark.put(volume, filelist.toArray(files));
        }
    }

    synchronized String[] getSequentialFilelistForVolume(Volume volume, long benchmarkSizeInBytes) throws IOException {
        if (null == this.filelistsSequentialBenchmark.get(volume)) {
            String[] filelist = this.inferFilelist(volume, SequentialBenchmark.getBenchmarkFilename());
            if (benchmarkSizeInBytes == this.calculateTotalSizeOfFilelist(volume, filelist)) {
                this.filelistsSequentialBenchmark.put(volume, filelist);
                Logging.logMessage(6, Logging.Category.tool, this, "Succesfully infered filelist on volume %s.", volume.getVolumeName());
            } else {
                Logging.logMessage(6, Logging.Category.tool, this, "Infering filelist failed", volume.getVolumeName());
                throw new IllegalArgumentException("No valid files for benchmark found");
            }
        }
        return this.filelistsSequentialBenchmark.get(volume);
    }

    synchronized String[] getRandomFilelistForVolume(Volume volume, long benchmarkSizeInBytes) throws IOException {
        if (null == this.filelistsRandomBenchmark.get(volume)) {
            String[] filelist = this.inferFilelist(volume, FilebasedBenchmark.getBenchmarkFilename());
            if (benchmarkSizeInBytes == this.calculateTotalSizeOfFilelist(volume, filelist)) {
                this.filelistsRandomBenchmark.put(volume, filelist);
                Logging.logMessage(6, Logging.Category.tool, this, "Succesfully infered filelist on volume %s.", volume.getVolumeName());
            } else {
                Logging.logMessage(6, Logging.Category.tool, this, "Infering filelist failed", volume.getVolumeName());
                throw new IllegalArgumentException("No valid files for benchmark found");
            }
        }
        return this.filelistsRandomBenchmark.get(volume);
    }

    private String[] inferFilelist(Volume volume, String pathToBasefile) throws IOException {
        Logging.logMessage(6, Logging.Category.tool, this, "Read benchmark without write benchmark. Trying to infer a filelist on volume %s", volume.getVolumeName());
        String path = pathToBasefile.substring(0, pathToBasefile.lastIndexOf(47));
        String filename = pathToBasefile.substring(pathToBasefile.lastIndexOf(47) + 1);
        List<MRC.DirectoryEntry> directoryEntries = volume.readDir(this.config.getUserCredentials(), path, 0, 0, true).getEntriesList();
        ArrayList<String> entries = new ArrayList<String>(directoryEntries.size());
        for (MRC.DirectoryEntry directoryEntry : directoryEntries) {
            String entry = directoryEntry.getName();
            if (!entry.matches(filename + "[0-9]+")) continue;
            entries.add(path + '/' + directoryEntry.getName());
        }
        entries.trimToSize();
        String[] filelist = new String[entries.size()];
        entries.toArray(filelist);
        return filelist;
    }

    private long calculateTotalSizeOfFilelist(Volume volume, String[] filelist) throws IOException {
        long aggregatedSizeInBytes = 0L;
        for (String file : filelist) {
            MRC.Stat stat = volume.getAttr(this.config.getUserCredentials(), file);
            aggregatedSizeInBytes += stat.getSize();
        }
        return aggregatedSizeInBytes;
    }

    synchronized void addCreatedFiles(Volume volume, LinkedList<String> newFiles) {
        HashSet<String> filelistForVolume = this.createdFiles.containsKey(volume) ? this.createdFiles.get(volume) : new HashSet<String>();
        filelistForVolume.addAll(newFiles);
        this.createdFiles.put(volume, filelistForVolume);
    }

    void deleteCreatedFiles() {
        for (Volume volume : this.volumes) {
            HashSet<String> fileListForVolume = this.createdFiles.get(volume);
            if (null == fileListForVolume) continue;
            Logging.logMessage(6, Logging.Category.tool, this, "Deleted %s file(s) on volume %s", fileListForVolume.size(), volume.getVolumeName());
            for (String filename : fileListForVolume) {
                this.tryToDeleteFile(volume, filename);
            }
        }
    }

    private void tryToDeleteFile(Volume volume, String filename) {
        try {
            volume.unlink(this.config.getUserCredentials(), filename);
        }
        catch (IOException e) {
            Logging.logMessage(3, Logging.Category.tool, this, "IO Error while trying to delete a file.", new Object[0]);
            Logging.logError(3, (Object)Logging.Category.tool, e);
        }
    }

    void deleteCreatedVolumes() {
        for (Volume volume : this.createdVolumes) {
            this.deleteVolumeIfExisting(volume);
        }
    }

    void deleteVolumes(String ... volumeName) {
        for (String each : volumeName) {
            this.deleteVolumeIfExisting(each);
        }
    }

    void deleteDefaultVolumes(int numberOfVolumes) {
        for (int i = 0; i < numberOfVolumes; ++i) {
            this.deleteVolumeIfExisting(VOLUME_BASE_NAME + i);
        }
    }

    void deleteVolumeIfExisting(Volume volume) {
        volume.close();
        this.deleteVolumeIfExisting(volume.getVolumeName());
    }

    void deleteVolumeIfExisting(String volumeName) {
        try {
            if (new ArrayList<String>(Arrays.asList(this.client.listVolumeNames())).contains(volumeName)) {
                this.client.deleteVolume(this.config.getAuth(), this.config.getUserCredentials(), volumeName);
                Logging.logMessage(6, Logging.Category.tool, this, "Deleted volume %s", volumeName);
            }
        }
        catch (IOException e) {
            Logging.logMessage(4, Logging.Category.tool, this, "Error while deleting volume %s", volumeName);
            Logging.logError(4, this, e);
        }
    }

    void cleanupOSD() throws Exception {
        String pwd = this.config.getAdminPassword();
        LinkedList<String> uuids = this.getOSDUUIDs();
        for (String osd : uuids) {
            Logging.logMessage(6, Logging.Category.tool, this, "Starting cleanup of OSD %s", osd);
            this.client.startCleanUp(osd, pwd, true, true, false, true, 0);
        }
        boolean cleanUpIsRunning = true;
        while (cleanUpIsRunning) {
            cleanUpIsRunning = false;
            for (String osd : uuids) {
                cleanUpIsRunning = cleanUpIsRunning || this.client.isRunningCleanUp(osd, pwd);
            }
            Thread.sleep(300L);
        }
        for (String osd : uuids) {
            Logging.logMessage(7, Logging.Category.tool, this, "Finished cleanup. Result: %s", this.client.getCleanUpResult(osd, pwd));
        }
    }

    LinkedList<String> getOSDUUIDs() throws IOException {
        LinkedList<String> uuids = new LinkedList<String>();
        for (DIR.Service service : this.client.getServiceByType(DIR.ServiceType.SERVICE_TYPE_OSD).getServicesList()) {
            uuids.add(service.getUuid());
        }
        return uuids;
    }

    LinkedList<Volume> getVolumes() {
        return this.volumes;
    }
}

