/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class Client {
    private final RPCNIOSocketClient mdClient;
    private final RPCNIOSocketClient osdClient;
    private final InetSocketAddress[] dirAddress;
    private DIRClient dirClient;
    private final UUIDResolver uuidRes;
    private final Map<String, Volume> volumeMap;

    public Client(InetSocketAddress[] dirAddresses, int requestTimeout, int connectionTimeout, SSLOptions ssl) throws IOException {
        this.dirAddress = dirAddresses;
        this.mdClient = new RPCNIOSocketClient(ssl, requestTimeout, connectionTimeout, "Client (dir)");
        this.osdClient = new RPCNIOSocketClient(ssl, requestTimeout, connectionTimeout, "Client (osd)");
        DIRServiceClient dirRpcClient = new DIRServiceClient(this.mdClient, this.dirAddress[0]);
        this.dirClient = new DIRClient(dirRpcClient, this.dirAddress, 100, 15000);
        TimeSync.initializeLocal(0);
        this.uuidRes = UUIDResolver.startNonSingelton(this.dirClient, 3600, 1000);
        this.volumeMap = new HashMap<String, Volume>();
    }

    public Volume getVolume(String volumeName, RPC.UserCredentials credentials) throws IOException {
        try {
            DIR.ServiceSet s;
            String lookupVolumeName = volumeName;
            int snapNameIndex = volumeName.indexOf(64);
            if (snapNameIndex != -1) {
                lookupVolumeName = volumeName.substring(0, snapNameIndex);
            }
            if ((s = this.dirClient.xtreemfs_service_get_by_name(null, RPCAuthentication.authNone, RPCAuthentication.userService, lookupVolumeName)).getServicesCount() == 0) {
                throw new IOException("volume '" + lookupVolumeName + "' does not exist");
            }
            DIR.Service vol = s.getServices(0);
            String mrcUUIDstr = KeyValuePairs.getValue(vol.getData().getDataList(), "mrc");
            ServiceUUID mrc = new ServiceUUID(mrcUUIDstr, this.uuidRes);
            RPC.UserCredentials uc = credentials;
            if (uc == null) {
                ArrayList<String> grps = new ArrayList<String>(1);
                grps.add("test");
                uc = RPC.UserCredentials.newBuilder().setUsername("test").addGroups("test").build();
            }
            Logging.logMessage(7, this, "volume %s on MRC %s/%s", volumeName, mrcUUIDstr, mrc.getAddress());
            Volume v = this.volumeMap.get(volumeName);
            if (v == null) {
                v = new Volume(new OSDServiceClient(this.osdClient, null), new MRCServiceClient(this.mdClient, mrc.getAddress()), volumeName, this.uuidRes, uc);
                this.volumeMap.put(volumeName, v);
            }
            return v;
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
    }

    public void createVolume(String volumeName, RPC.Auth authentication, RPC.UserCredentials credentials, GlobalTypes.StripingPolicy sp, GlobalTypes.AccessControlPolicyType accessCtrlPolicy, int permissions) throws IOException {
        RPCResponse r2 = null;
        try {
            DIR.ServiceSet mrcs = this.dirClient.xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, credentials, DIR.ServiceType.SERVICE_TYPE_MRC);
            if (mrcs.getServicesCount() == 0) {
                throw new IOException("no MRC available for volume creation");
            }
            String uuid = mrcs.getServices(0).getUuid();
            ServiceUUID mrcUUID = new ServiceUUID(uuid, this.uuidRes);
            MRCServiceClient m = new MRCServiceClient(this.mdClient, mrcUUID.getAddress());
            r2 = m.xtreemfs_mkvol(null, authentication, credentials, accessCtrlPolicy, sp, "", permissions, volumeName, credentials.getUsername(), credentials.getGroups(0), new LinkedList<GlobalTypes.KeyValuePair>(), 0L);
            r2.get();
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
        finally {
            if (r2 != null) {
                r2.freeBuffers();
            }
        }
    }

    public void createVolume(String volumeName, RPC.Auth authentication, RPC.UserCredentials credentials, GlobalTypes.StripingPolicy sp, GlobalTypes.AccessControlPolicyType accessCtrlPolicy, int permissions, String mrcUUID) throws IOException {
        RPCResponse r = null;
        try {
            ServiceUUID uuid = new ServiceUUID(mrcUUID, this.uuidRes);
            uuid.resolve();
            MRCServiceClient m = new MRCServiceClient(this.mdClient, uuid.getAddress());
            r = m.xtreemfs_mkvol(uuid.getAddress(), authentication, credentials, accessCtrlPolicy, sp, "", permissions, volumeName, credentials.getUsername(), credentials.getGroups(0), new LinkedList<GlobalTypes.KeyValuePair>(), 0L);
            r.get();
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
        catch (UnknownUUIDException ex) {
            throw new IOException("mrc UUID was unknown", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public void deleteVolume(String volumeName, RPC.Auth authentication, RPC.UserCredentials credentials) throws IOException {
        RPCResponse r2 = null;
        assert (credentials != null);
        try {
            DIR.ServiceSet s = this.dirClient.xtreemfs_service_get_by_name(null, RPCAuthentication.authNone, credentials, volumeName);
            if (s.getServicesCount() == 0) {
                throw new IOException("volume '" + volumeName + "' does not exist");
            }
            DIR.Service vol = s.getServices(0);
            String mrcUUIDstr = KeyValuePairs.getValue(vol.getData().getDataList(), "mrc");
            ServiceUUID mrc = new ServiceUUID(mrcUUIDstr, this.uuidRes);
            MRCServiceClient m = new MRCServiceClient(this.mdClient, mrc.getAddress());
            r2 = m.xtreemfs_rmvol(null, authentication, credentials, volumeName);
            r2.get();
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
        finally {
            if (r2 != null) {
                r2.freeBuffers();
            }
        }
    }

    public String[] listVolumeNames(RPC.UserCredentials credentials) throws IOException {
        assert (credentials != null);
        try {
            DIR.ServiceSet s = this.dirClient.xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, credentials, DIR.ServiceType.SERVICE_TYPE_VOLUME);
            String[] volNames = new String[s.getServicesCount()];
            for (int i = 0; i < volNames.length; ++i) {
                volNames[i] = s.getServices(i).getName();
            }
            return volNames;
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
    }

    public String[] listVolumeNames(String mrcUUID, RPC.UserCredentials credentials) throws IOException {
        RPCResponse<MRC.Volumes> r = null;
        assert (credentials != null);
        try {
            ServiceUUID mrc = new ServiceUUID(mrcUUID, this.uuidRes);
            MRCServiceClient m = new MRCServiceClient(this.mdClient, mrc.getAddress());
            r = m.xtreemfs_lsvol(null, RPCAuthentication.authNone, credentials);
            MRC.Volumes vols = r.get();
            String[] volNames = new String[vols.getVolumesCount()];
            for (int i = 0; i < volNames.length; ++i) {
                volNames[i] = vols.getVolumes(i).getName();
            }
            String[] stringArray = volNames;
            return stringArray;
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public DIR.ServiceSet getRegistry() throws IOException {
        try {
            return this.dirClient.xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_MIXED);
        }
        catch (InterruptedException ex) {
            throw new IOException("operation was interrupted", ex);
        }
    }

    public void start() throws Exception {
        this.mdClient.start();
        this.mdClient.waitForStartup();
        this.osdClient.start();
        this.osdClient.waitForStartup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.dirClient != null) {
            try {
                this.mdClient.shutdown();
                this.osdClient.shutdown();
                this.mdClient.waitForShutdown();
                this.osdClient.waitForShutdown();
                for (Volume v : this.volumeMap.values()) {
                    v.shutdown();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.dirClient = null;
            }
        }
    }

    public void finalize() {
        this.stop();
    }
}

