/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.clients.Replica;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.json.JSONString;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class File {
    public static final String XTREEMFSSET_REPL_UPDATE_POLICY_XATTR = "xtreemfs.set_repl_update_policy";
    public static final String XTREEMFS_DEFAULT_RP = "xtreemfs.default_rp";
    private final Volume volume;
    private final String path;
    private final RPC.UserCredentials userCreds;

    File(Volume volume, RPC.UserCredentials userCreds, String path) {
        this.volume = volume;
        this.path = path;
        this.userCreds = userCreds;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isFile(RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stat = this.volume.stat(this.path, userCreds);
        if (stat != null) {
            return (stat.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFREG.getNumber()) > 0;
        }
        return false;
    }

    public boolean isFile() throws IOException {
        return this.isFile(this.userCreds);
    }

    public boolean isDirectory(RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stat = this.volume.stat(this.path, userCreds);
        if (stat != null) {
            return (stat.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber()) > 0;
        }
        return false;
    }

    public boolean isDirectory() throws IOException {
        return this.isDirectory(this.userCreds);
    }

    public boolean exists(RPC.UserCredentials userCreds) throws IOException {
        try {
            MRC.Stat stat = this.volume.stat(this.path, userCreds);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        return true;
    }

    public boolean exists() throws IOException {
        return this.exists(this.userCreds);
    }

    public boolean canRead(RPC.UserCredentials userCreds) throws IOException {
        try {
            MRC.Stat stat = this.volume.stat(this.path, userCreds);
            return (stat.getMode() & 0x100) > 0;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public boolean canRead() throws IOException {
        return this.canRead(this.userCreds);
    }

    public boolean canWrite(RPC.UserCredentials userCreds) throws IOException {
        try {
            MRC.Stat stat = this.volume.stat(this.path, userCreds);
            return (stat.getMode() & 0x80) > 0;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public boolean canWrite() throws IOException {
        return this.canWrite(this.userCreds);
    }

    public long lastModified(RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stat = this.volume.stat(this.path, userCreds);
        return stat.getMtimeNs() / 1000000L;
    }

    public long lastModified() throws IOException {
        return this.lastModified(this.userCreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length(RPC.UserCredentials userCreds) throws IOException {
        if (this.volume.isSnapshot()) {
            RPCResponse<OSD.xtreemfs_internal_get_file_sizeResponse> fs = null;
            try {
                RandomAccessFile file = this.volume.openFile(this, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber(), 0, userCreds);
                fs = this.volume.osdClient.xtreemfs_internal_get_file_size(this.getReplica(0).getOSDAddress(0), RPCAuthentication.authNone, RPCAuthentication.userService, file.getCredentials(), file.getFileId());
                long l = fs.get().getFileSize();
                return l;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                long l = 0L;
                return l;
            }
            finally {
                if (fs != null) {
                    fs.freeBuffers();
                }
            }
        }
        MRC.Stat stat = this.volume.stat(this.path, userCreds);
        if (stat != null) {
            return stat.getSize();
        }
        return 0L;
    }

    public long length() throws IOException {
        return this.length(this.userCreds);
    }

    public void mkdir(int permissions, RPC.UserCredentials userCreds) throws IOException {
        this.volume.mkdir(this.path, permissions, userCreds);
    }

    public void mkdir(int permissions) throws IOException {
        this.mkdir(permissions, this.userCreds);
    }

    public void createFile(RPC.UserCredentials userCreds) throws IOException {
        this.volume.touch(this.path, userCreds);
    }

    public void createFile() throws IOException {
        this.createFile(this.userCreds);
    }

    public MRC.Stat stat(RPC.UserCredentials userCreds) throws IOException {
        return this.volume.stat(this.path, userCreds);
    }

    public MRC.Stat stat() throws IOException {
        return this.stat(this.userCreds);
    }

    public void renameTo(File dest, RPC.UserCredentials userCreds) throws IOException {
        this.volume.rename(this.path, dest.path, userCreds);
    }

    public void renameTo(File dest) throws IOException {
        this.renameTo(dest, this.userCreds);
    }

    public void delete(RPC.UserCredentials userCreds) throws IOException {
        this.volume.unlink(this.path, userCreds);
    }

    public void delete() throws IOException {
        this.delete(this.userCreds);
    }

    public String getxattr(String name, RPC.UserCredentials userCreds) throws IOException {
        return this.volume.getxattr(this.path, name, userCreds);
    }

    public String getxattr(String name) throws IOException {
        return this.getxattr(name, this.userCreds);
    }

    public String[] listXAttrs(RPC.UserCredentials userCreds) throws IOException {
        return this.volume.listxattr(this.path, userCreds);
    }

    public String[] listXAttrs() throws IOException {
        return this.listXAttrs(this.userCreds);
    }

    public void setxattr(String name, String value, RPC.UserCredentials userCreds) throws IOException {
        this.volume.setxattr(this.path, name, value, userCreds);
    }

    public void setxattr(String name, String value) throws IOException {
        this.setxattr(name, value, this.userCreds);
    }

    public void chmod(int mode, RPC.UserCredentials userCreds) throws IOException {
        this.volume.chmod(this.path, mode, userCreds);
    }

    public void chmod(int mode) throws IOException {
        this.chmod(mode, this.userCreds);
    }

    public void chown(String user, RPC.UserCredentials userCreds) throws IOException {
        this.volume.chown(this.path, user, userCreds);
    }

    public void chown(String user) throws IOException {
        this.chown(user, this.userCreds);
    }

    public void chgrp(String group, RPC.UserCredentials userCreds) throws IOException {
        this.volume.chgrp(this.path, group, userCreds);
    }

    public void chgrp(String group) throws IOException {
        this.chgrp(group, this.userCreds);
    }

    public void setACL(Map<String, Object> aclEntries, RPC.UserCredentials userCreds) throws IOException {
        this.volume.setACL(this.path, aclEntries, userCreds);
    }

    public void setACL(Map<String, Object> aclEntries) throws IOException {
        this.setACL(aclEntries, this.userCreds);
    }

    public Map<String, Object> getACL(RPC.UserCredentials userCreds) throws IOException {
        return this.volume.getACL(this.path, userCreds);
    }

    public Map<String, Object> getACL() throws IOException {
        return this.getACL(this.userCreds);
    }

    public RandomAccessFile open(String openMode, int permissions, RPC.UserCredentials userCreds) throws IOException {
        int flags = 0;
        if (openMode.contains("rw")) {
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber();
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber();
        } else if (openMode.contains("r")) {
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber();
        }
        if (openMode.contains("t")) {
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber();
        }
        if (openMode.contains("d") || openMode.contains("s")) {
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_SYNC.getNumber();
        }
        return this.volume.openFile(this, flags, permissions, userCreds);
    }

    public RandomAccessFile open(String openMode, int permissions) throws IOException {
        return this.open(openMode, permissions, this.userCreds);
    }

    public int getNumReplicas(RPC.UserCredentials userCreds) throws IOException {
        try {
            Map<String, Object> xloc = this.getLocations(userCreds);
            List replicas = (List)xloc.get("replicas");
            return replicas.size();
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list: " + ex, ex);
        }
    }

    public int getNumReplicas() throws IOException {
        return this.getNumReplicas(this.userCreds);
    }

    public Replica getReplica(int replicaNo, RPC.UserCredentials userCreds) throws IOException {
        try {
            Map<String, Object> xloc = this.getLocations(userCreds);
            List replicas = (List)xloc.get("replicas");
            if (replicas.size() <= replicaNo) {
                throw new IllegalArgumentException("replicaNo is out of bounds");
            }
            return new Replica(this, (Map)replicas.get(replicaNo), userCreds);
        }
        catch (JSONException ex) {
            throw new IOException("cannot parse file's location list: " + ex, ex);
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list: " + ex, ex);
        }
    }

    public Replica getReplica(int replicaNo) throws IOException {
        return this.getReplica(replicaNo, this.userCreds);
    }

    public Replica getReplica(String osdUUID, RPC.UserCredentials userCreds) throws IOException {
        Replica[] repls;
        for (Replica r : repls = this.getReplicas(userCreds)) {
            for (int i = 0; i < r.getStripeWidth(); ++i) {
                if (!r.getOSDUuid(i).equals(osdUUID)) continue;
                return r;
            }
        }
        return null;
    }

    public Replica getReplica(String osdUUID) throws IOException {
        return this.getReplica(osdUUID, this.userCreds);
    }

    public Replica[] getReplicas(RPC.UserCredentials userCreds) throws IOException {
        try {
            Map<String, Object> xloc = this.getLocations(userCreds);
            List replicas = (List)xloc.get("replicas");
            Replica[] repls = new Replica[replicas.size()];
            for (int i = 0; i < repls.length; ++i) {
                repls[i] = new Replica(this, (Map)replicas.get(i), userCreds);
            }
            return repls;
        }
        catch (JSONException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
    }

    public Replica[] getReplicas() throws IOException {
        return this.getReplicas(this.userCreds);
    }

    public void setDefaultReplication(String policy, int numReplicas, RPC.UserCredentials userCreds) throws IOException {
        String JSON = "{ \"update-policy\" : \"" + policy + "\", \"replication-factor\" : " + numReplicas + " }";
        if (!this.isDirectory()) {
            throw new IOException("only diretories (including root) have a default replication policy");
        }
        this.volume.setxattr(this.path, XTREEMFS_DEFAULT_RP, JSON, userCreds);
    }

    public void setDefaultReplication(String policy, int numReplicas) throws IOException {
        this.setDefaultReplication(policy, numReplicas, this.userCreds);
    }

    public boolean isReadOnlyReplicated(RPC.UserCredentials userCreds) throws IOException {
        try {
            Map<String, Object> xloc = this.getLocations(userCreds);
            String uPolicy = (String)xloc.get("update-policy");
            return uPolicy.equals("ronly");
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
    }

    public boolean isReadOnlyReplicated() throws IOException {
        return this.isReadOnlyReplicated(this.userCreds);
    }

    public void setReadOnly(boolean mode, RPC.UserCredentials userCreds) throws Exception {
        boolean currentMode = Boolean.valueOf(this.getxattr("xtreemfs.read_only"));
        if (currentMode == mode) {
            return;
        }
        if (mode) {
            long mrc_file_size;
            RandomAccessFile raf = this.open("r", 0, userCreds);
            long osd_file_size = raf.getFileSizeOnOSD();
            if (osd_file_size != (mrc_file_size = this.length(userCreds))) {
                raf.forceFileSize(osd_file_size);
            }
            this.setxattr("xtreemfs.read_only", "true");
        } else {
            if (this.getNumReplicas() > 1) {
                throw new IOException("File has still replicas.");
            }
            this.setxattr("xtreemfs.read_only", "false");
        }
    }

    public void setReadOnly(boolean mode) throws Exception {
        this.setReadOnly(mode, this.userCreds);
    }

    public boolean isReadOnly(RPC.UserCredentials userCreds) throws IOException {
        return Boolean.valueOf(this.getxattr("xtreemfs.read_only", userCreds));
    }

    public boolean isReadOnly() throws IOException {
        return this.isReadOnly(this.userCreds);
    }

    public boolean isReplicated(RPC.UserCredentials userCreds) throws IOException {
        Map<String, Object> l = this.getLocations(userCreds);
        String updatePolicy = (String)l.get("update-policy");
        return !updatePolicy.equals("");
    }

    public boolean isReplicated() throws IOException {
        return this.isReplicated(this.userCreds);
    }

    public String[] getSuitableOSDs(int numOSDs, RPC.UserCredentials userCreds) throws IOException {
        List<String> osds = this.volume.getSuitableOSDs(this, numOSDs, userCreds);
        return osds.toArray(new String[osds.size()]);
    }

    public String[] getSuitableOSDs(int numOSDs) throws IOException {
        return this.getSuitableOSDs(numOSDs, this.userCreds);
    }

    public void addReplica(int width, String[] osdUuids, int flags, RPC.UserCredentials userCreds) throws IOException {
        ArrayList<String> osdSet = new ArrayList<String>(20);
        for (String osd : osdUuids) {
            if (osdSet.size() == width) break;
            osdSet.add(osd);
        }
        if (osdSet.size() != width) {
            throw new IllegalArgumentException("number of OSDs must be equal to width!");
        }
        this.volume.addReplica(this, width, osdSet, flags, userCreds);
    }

    public void addReplica(int width, String[] osdUuids, int flags) throws IOException {
        this.addReplica(width, osdUuids, flags, this.userCreds);
    }

    public void setReplicaUpdatePolicy(String policy, RPC.UserCredentials userCreds) throws IOException {
        this.volume.setxattr(this.getPath(), XTREEMFSSET_REPL_UPDATE_POLICY_XATTR, policy, userCreds);
    }

    public void setReplicaUpdatePolicy(String policy) throws IOException {
        this.setReplicaUpdatePolicy(policy, this.userCreds);
    }

    public String getReplicaUpdatePolicy(RPC.UserCredentials userCreds) throws IOException {
        try {
            String loc = this.volume.getxattr(this.getPath(), "xtreemfs.locations", userCreds);
            if (loc != null && loc.length() > 0) {
                Map location = (Map)JSONParser.parseJSON(new JSONString(loc));
                return (String)location.get("update-policy");
            }
            throw new IOException("cannot retrieve file's location list (is empty)");
        }
        catch (JSONException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
    }

    public String getReplicaUpdatePolicy() throws IOException {
        return this.getReplicaUpdatePolicy(this.userCreds);
    }

    Map<String, Object> getLocations(RPC.UserCredentials userCreds) throws IOException {
        try {
            String loc = this.volume.getxattr(this.getPath(), "xtreemfs.locations", userCreds);
            if (loc != null && loc.length() > 0) {
                return (Map)JSONParser.parseJSON(new JSONString(loc));
            }
            throw new IOException("cannot retrieve file's location list (is empty)");
        }
        catch (JSONException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
        catch (ClassCastException ex) {
            throw new IOException("cannot parse file's location list", ex);
        }
    }

    void removeReplica(String headOSDuuid, RPC.UserCredentials userCreds) throws IOException {
        if (!this.isFile()) {
            throw new IOException("cannot remove replica from a non-file object");
        }
        this.volume.removeReplica(this, headOSDuuid, userCreds);
    }
}

