/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.InvalidChecksumException;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.common.clients.internal.ObjectMapper;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class RandomAccessFile {
    public static final int WAIT_MS_BETWEEN_WRITE_SWITCHOVER = 1000;
    private final File parent;
    private final OSDServiceClient osdClient;
    private final Volume parentVolume;
    private final boolean readOnly;
    private final boolean syncMetadata;
    private long position;
    private GlobalTypes.FileCredentials credentials;
    private Replica currentReplica;
    private int currentReplicaNo;
    private final int numReplicas;
    private final String fileId;
    private ObjectMapper oMapper;
    private boolean closed;
    private RPC.UserCredentials userCreds;
    private final AtomicReference<GlobalTypes.XCap> uptodateCap;

    RandomAccessFile(File parent, Volume parentVolume, OSDServiceClient client, GlobalTypes.FileCredentials fc, boolean readOnly, boolean syncMetadata, RPC.UserCredentials userCreds) {
        this.parent = parent;
        this.parentVolume = parentVolume;
        this.osdClient = client;
        this.credentials = fc;
        this.readOnly = readOnly;
        this.syncMetadata = syncMetadata;
        this.userCreds = userCreds;
        this.position = 0L;
        this.currentReplicaNo = 0;
        this.closed = false;
        this.numReplicas = this.credentials.getXlocs().getReplicasCount();
        this.fileId = fc.getXcap().getFileId();
        this.uptodateCap = new AtomicReference<GlobalTypes.XCap>(fc.getXcap());
        this.selectReplica(0);
    }

    public void updateCap(GlobalTypes.XCap newXCap) {
        this.uptodateCap.set(newXCap);
    }

    protected void setXCap() {
        this.credentials = this.credentials.toBuilder().setXcap(this.uptodateCap.get()).build();
    }

    protected void switchToNextReplica() {
        this.selectReplica((this.currentReplicaNo + 1) % this.numReplicas);
    }

    protected void selectReplica(int replicaNo) {
        this.currentReplicaNo = replicaNo;
        this.currentReplica = new Replica(this.credentials.getXlocs().getReplicas(this.currentReplicaNo), null);
        this.oMapper = ObjectMapper.getMapper(this.currentReplica.getStripingPolicy().getPolicy());
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "now using replica %d (%s)", replicaNo, this.credentials.getXlocs().getReplicasList());
        }
    }

    public GlobalTypes.XLocSet getLocationsList() {
        return this.credentials.getXlocs();
    }

    public int getCurrentReplicaStripeSize() {
        return this.currentReplica.getStripingPolicy().getStripeSizeForObject(0L);
    }

    public int getCurrentReplicaStripeingWidth() {
        return this.currentReplica.getStripingPolicy().getWidth();
    }

    public void forceReplica(int replicaNo) {
        if (replicaNo > this.numReplicas - 1 || replicaNo < 0) {
            throw new IllegalArgumentException("invalid replica number");
        }
        this.selectReplica(replicaNo);
    }

    public void forceReplica(String headOSDuuid) {
        int numRepl = this.credentials.getXlocs().getReplicasCount();
        for (int i = 0; i < numRepl; ++i) {
            GlobalTypes.Replica r = this.credentials.getXlocs().getReplicas(i);
            if (!r.getOsdUuids(0).equals(headOSDuuid)) continue;
            this.selectReplica(i);
            return;
        }
        throw new IllegalArgumentException("osd " + headOSDuuid + " not in any of the replicas: " + this.credentials.getXlocs().getReplicasList());
    }

    public int getCurrentReplica() {
        return this.currentReplicaNo;
    }

    public String getFileId() {
        return this.credentials.getXcap().getFileId();
    }

    public File getFile() {
        return this.parent;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        ReusableBuffer buf = ReusableBuffer.wrap(data, offset, length);
        return this.read(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ReusableBuffer data) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("file was closed");
        }
        int numTries = 0;
        IOException cause = null;
        do {
            List<ObjectMapper.ObjectRequest> ors = this.oMapper.readRequest(data.remaining(), this.position, this.currentReplica);
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "read from file %s: %d bytes from offset %d (= %d obj rqs)", this.fileId, data.remaining(), this.position, ors.size());
            }
            if (ors.isEmpty()) {
                return 0;
            }
            final AtomicInteger responseCnt = new AtomicInteger(ors.size());
            RPCResponse[] resps = new RPCResponse[ors.size()];
            try {
                RPCResponseAvailableListener<OSD.ObjectData> rl = new RPCResponseAvailableListener<OSD.ObjectData>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void responseAvailable(RPCResponse<OSD.ObjectData> r) {
                        if (responseCnt.decrementAndGet() == 0) {
                            AtomicInteger atomicInteger = responseCnt;
                            synchronized (atomicInteger) {
                                responseCnt.notify();
                            }
                        }
                    }
                };
                this.setXCap();
                for (int i = 0; i < ors.size(); ++i) {
                    RPCResponse<OSD.ObjectData> r;
                    ObjectMapper.ObjectRequest or = ors.get(i);
                    ServiceUUID osd = new ServiceUUID(or.getOsdUUID(), this.parentVolume.uuidResolver);
                    resps[i] = r = this.osdClient.read(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId, or.getObjNo(), -1L, or.getOffset(), or.getLength());
                    r.registerListener(rl);
                }
                AtomicInteger i = responseCnt;
                synchronized (i) {
                    if (responseCnt.get() > 0) {
                        responseCnt.wait();
                    }
                }
                InternalObjectData[] ods = new InternalObjectData[ors.size()];
                for (int i2 = 0; i2 < ors.size(); ++i2) {
                    ods[i2] = new InternalObjectData((OSD.ObjectData)resps[i2].get(), resps[i2].getData());
                }
                int numBytesRead = 0;
                for (InternalObjectData od : ods) {
                    if (od.getData() != null) {
                        numBytesRead += od.getData().remaining();
                        data.put(od.getData());
                        BufferPool.free(od.getData());
                    }
                    if (od.getZero_padding() <= 0) continue;
                    numBytesRead += od.getZero_padding();
                    for (int i3 = 0; i3 < od.getZero_padding(); ++i3) {
                        data.put((byte)0);
                    }
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "read returned %d bytes", numBytesRead);
                }
                this.position += (long)numBytesRead;
                int arr$ = numBytesRead;
                return arr$;
            }
            catch (InterruptedException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = new IOException("operation aborted", ex);
                return (int)cause;
            }
            catch (PBRPCException ex) {
                if (ex.getErrorType() == RPC.ErrorType.REDIRECT) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "redirected to: %s", ex.getRedirectToServerUUID());
                    }
                    this.forceReplica(ex.getRedirectToServerUUID());
                }
                if (ex.getErrorType() == RPC.ErrorType.ERRNO) {
                    cause = ex;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = new IOException("communication failure", ex);
                return (int)cause;
            }
            catch (IOException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = ex;
                return (int)cause;
            }
            catch (Throwable th) {
                th.printStackTrace();
                throw new IOException("nasty!");
            }
            finally {
                for (RPCResponse r : resps) {
                    r.freeBuffers();
                }
            }
            ++numTries;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                throw new IOException("operation aborted", ex);
            }
            this.switchToNextReplica();
        } while (numTries < this.numReplicas + this.parentVolume.getMaxRetries());
        throw cause;
    }

    public int checkObject(long objectNo) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("file was closed");
        }
        RPCResponse<OSD.ObjectData> r = null;
        try {
            ServiceUUID osd = new ServiceUUID(this.currentReplica.getOSDForObject(objectNo).toString(), this.parentVolume.uuidResolver);
            this.setXCap();
            r = this.osdClient.xtreemfs_check_object(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId, objectNo, 0L);
            OSD.ObjectData od = r.get();
            if (od.getInvalidChecksumOnOsd()) {
                throw new InvalidChecksumException("object " + objectNo + " has an invalid checksum");
            }
            int n = od.getZeroPadding();
            return n;
        }
        catch (InterruptedException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("operation aborted", ex);
        }
        catch (PBRPCException ex) {
            if (ex.getErrorType() == RPC.ErrorType.ERRNO) {
                throw ex;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public int write(byte[] data, int offset, int length) throws IOException {
        ReusableBuffer buf = ReusableBuffer.wrap(data, offset, length);
        return this.write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ReusableBuffer data) throws IOException {
        if (this.readOnly) {
            throw new IOException("File is marked as read-only.");
        }
        if (this.closed) {
            throw new IllegalStateException("file was closed");
        }
        if (data.remaining() == 0) {
            return 0;
        }
        List<ObjectMapper.ObjectRequest> ors = this.oMapper.writeRequest(data, this.position, this.currentReplica);
        if (ors.isEmpty()) {
            return 0;
        }
        int numTries = 0;
        IOException cause = null;
        do {
            final AtomicInteger responseCnt = new AtomicInteger(ors.size());
            RPCResponse[] resps = new RPCResponse[ors.size()];
            try {
                int i;
                RPCResponseAvailableListener<GlobalTypes.OSDWriteResponse> rl = new RPCResponseAvailableListener<GlobalTypes.OSDWriteResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void responseAvailable(RPCResponse<GlobalTypes.OSDWriteResponse> r) {
                        if (responseCnt.decrementAndGet() == 0) {
                            AtomicInteger atomicInteger = responseCnt;
                            synchronized (atomicInteger) {
                                responseCnt.notify();
                            }
                        }
                    }
                };
                int bytesWritten = 0;
                this.setXCap();
                OSD.ObjectData objData = OSD.ObjectData.newBuilder().setChecksum(0).setInvalidChecksumOnOsd(false).setZeroPadding(0).build();
                for (int i2 = 0; i2 < ors.size(); ++i2) {
                    RPCResponse<GlobalTypes.OSDWriteResponse> r;
                    ObjectMapper.ObjectRequest or = ors.get(i2);
                    or.getData().position(0);
                    bytesWritten += or.getData().capacity();
                    ServiceUUID osd = new ServiceUUID(or.getOsdUUID(), this.parentVolume.uuidResolver);
                    resps[i2] = r = this.osdClient.write(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId, or.getObjNo(), -1L, or.getOffset(), 0L, objData, or.getData());
                    r.registerListener(rl);
                }
                AtomicInteger i2 = responseCnt;
                synchronized (i2) {
                    if (responseCnt.get() > 0) {
                        responseCnt.wait();
                    }
                }
                GlobalTypes.OSDWriteResponse owr = null;
                for (i = 0; i < ors.size(); ++i) {
                    owr = (GlobalTypes.OSDWriteResponse)resps[i].get();
                }
                this.setXCap();
                this.parentVolume.storeFileSizeUpdate(this.fileId, owr, this.userCreds);
                if (this.syncMetadata) {
                    this.parentVolume.pushFileSizeUpdate(this.fileId, this.userCreds);
                }
                data.flip();
                this.position += (long)bytesWritten;
                i = bytesWritten;
                return i;
            }
            catch (InterruptedException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = new IOException("operation aborted", ex);
                return (int)cause;
            }
            catch (PBRPCException ex) {
                if (ex.getErrorType() == RPC.ErrorType.REDIRECT) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "redirected to: %s", ex.getRedirectToServerUUID());
                    }
                    this.forceReplica(ex.getRedirectToServerUUID());
                }
                if (ex.getErrorType() == RPC.ErrorType.ERRNO) {
                    cause = ex;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = new IOException("communication failure", ex);
                return (int)cause;
            }
            catch (IOException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                cause = ex;
                return (int)cause;
            }
            finally {
                for (RPCResponse r : resps) {
                    if (r == null) continue;
                    r.freeBuffers();
                }
            }
            ++numTries;
            this.switchToNextReplica();
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "write failed (%s), switched to replica: %s", cause, this.currentReplica);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "comm error: %s", ex.toString());
                }
                throw new IOException("operation aborted", ex);
            }
        } while (numTries < this.numReplicas + this.parentVolume.getMaxRetries());
        throw cause;
    }

    public void seek(long position) {
        this.position = position;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void close() throws IOException {
        this.closed = true;
        this.parentVolume.closeFile(this, this.fileId, this.readOnly, this.userCreds);
    }

    public void fsync() throws IOException {
        this.parentVolume.pushFileSizeUpdate(this.fileId, this.userCreds);
    }

    public long length() throws IOException {
        return this.parent.length();
    }

    public long getNumObjects() throws IOException {
        long flength = this.length();
        if (flength > 0L) {
            return this.currentReplica.getStripingPolicy().getObjectNoForOffset(flength - 1L) + 1L;
        }
        return 0L;
    }

    public void forceFileSize(long newFileSize) throws IOException {
        GlobalTypes.XCap truncCap = this.parentVolume.truncateFile(this.fileId, this.userCreds);
        try {
            this.parentVolume.storeFileSizeUpdate(this.fileId, GlobalTypes.OSDWriteResponse.newBuilder().setSizeInBytes(newFileSize).setTruncateEpoch(truncCap.getTruncateEpoch()).build(), this.userCreds);
            this.parentVolume.pushFileSizeUpdate(this.fileId, this.userCreds);
            if (this.position > newFileSize) {
                this.position = newFileSize;
            }
        }
        catch (PBRPCException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
    }

    long getFileSizeOnOSD() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("file was closed");
        }
        RPCResponse<OSD.xtreemfs_internal_get_file_sizeResponse> r = null;
        try {
            ServiceUUID osd = new ServiceUUID(this.currentReplica.getHeadOsd().toString(), this.parentVolume.uuidResolver);
            this.setXCap();
            r = this.osdClient.xtreemfs_internal_get_file_size(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId);
            long l = r.get().getFileSize();
            return l;
        }
        catch (InterruptedException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("operation aborted", ex);
        }
        catch (PBRPCException ex) {
            if (ex.getErrorType() == RPC.ErrorType.REDIRECT) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "redirected to: %s", ex.getRedirectToServerUUID());
                }
                this.forceReplica(ex.getRedirectToServerUUID());
                long l = this.getFileSizeOnOSD();
                return l;
            }
            if (ex.getErrorType() == RPC.ErrorType.ERRNO) {
                throw ex;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    boolean isCompleteReplica(int replicaNo) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("file was closed");
        }
        RPCResponse<OSD.ObjectList> r = null;
        try {
            GlobalTypes.Replica replica = this.credentials.getXlocs().getReplicas(replicaNo);
            if ((replica.getReplicationFlags() & GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber()) > 0) {
                boolean bl = true;
                return bl;
            }
            this.setXCap();
            StripingPolicyImpl sp = StripingPolicyImpl.getPolicy(replica, 0);
            long lastObjectNo = sp.getObjectNoForOffset(this.credentials.getXlocs().getReadOnlyFileSize() - 1L);
            int osdRelPos = 0;
            for (String osdUUID : replica.getOsdUuidsList()) {
                ServiceUUID osd = new ServiceUUID(osdUUID, this.parentVolume.uuidResolver);
                r = this.osdClient.xtreemfs_internal_get_object_set(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId);
                OSD.ObjectList ol = r.get();
                r.freeBuffers();
                r = null;
                byte[] serializedBitSet = ol.getSet().toByteArray();
                ObjectSet oset = null;
                try {
                    oset = new ObjectSet(replicaNo, replicaNo, serializedBitSet);
                }
                catch (Exception ex) {
                    throw new IOException("cannot deserialize object set: " + ex, ex);
                }
                for (long objNo = (long)osdRelPos; objNo <= lastObjectNo; objNo += (long)sp.getWidth()) {
                    if (oset.contains(objNo)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                this.parent.setxattr("xtreemfs.mark_replica_complete", replica.getOsdUuids(0));
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("operation aborted", ex);
        }
        catch (PBRPCException ex) {
            if (ex.getErrorType() == RPC.ErrorType.REDIRECT) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "redirected to: %s", ex.getRedirectToServerUUID());
                }
                this.forceReplica(ex.getRedirectToServerUUID());
                boolean bl = this.isCompleteReplica(replicaNo);
                return bl;
            }
            if (ex.getErrorType() == RPC.ErrorType.ERRNO) {
                throw ex;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public int getReplicaNumber(String headOSDuuid) {
        for (int i = 0; i < this.credentials.getXlocs().getReplicasCount(); ++i) {
            GlobalTypes.Replica replica = this.credentials.getXlocs().getReplicas(i);
            if (!replica.getOsdUuidsList().contains(headOSDuuid)) continue;
            return i;
        }
        throw new IllegalArgumentException("osd '" + headOSDuuid + "' is not in any replica of this file");
    }

    public void triggerInitialReplication() throws IOException {
        try {
            this.setXCap();
            List<ServiceUUID> osdList = this.currentReplica.getOSDs();
            ArrayList<ServiceUUID> osdListCopy = new ArrayList<ServiceUUID>(this.currentReplica.getOSDs());
            int objectNo = 0;
            while (osdListCopy.size() != 0) {
                ServiceUUID osd = this.currentReplica.getOSDForObject(objectNo);
                osdListCopy.remove(osd);
                RPCResponse<OSD.ObjectData> r = this.osdClient.read(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, this.credentials, this.fileId, objectNo, 0L, 0, 1);
                r.get();
                r.freeBuffers();
                ++objectNo;
            }
        }
        catch (UnknownUUIDException e) {
        }
        catch (PBRPCException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
        catch (IOException e) {
            throw new IOException("At least one OSD could not be contacted to replicate the file.", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setLength(long newLength) throws IOException {
        GlobalTypes.XCap truncCap = this.parentVolume.truncateFile(this.fileId, this.userCreds);
        GlobalTypes.FileCredentials tCred = GlobalTypes.FileCredentials.newBuilder().setXcap(truncCap).setXlocs(this.credentials.getXlocs()).build();
        RPCResponse<GlobalTypes.OSDWriteResponse> r = null;
        try {
            this.setXCap();
            ServiceUUID osd = new ServiceUUID(this.currentReplica.getHeadOsd().toString(), this.parentVolume.uuidResolver);
            r = this.osdClient.truncate(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, tCred, this.fileId, newLength);
            GlobalTypes.OSDWriteResponse resp = r.get();
            this.parentVolume.storeFileSizeUpdate(this.fileId, resp, this.userCreds);
            this.parentVolume.pushFileSizeUpdate(this.fileId, this.userCreds);
            if (this.position > newLength) {
                this.position = newLength;
            }
        }
        catch (InterruptedException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("operation aborted", ex);
        }
        catch (PBRPCException ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "comm error: %s", ex.toString());
            }
            throw new IOException("communication failure", ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    protected GlobalTypes.FileCredentials getCredentials() {
        return this.credentials;
    }

    public void flush() throws IOException {
        this.fsync();
    }
}

