/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class Replica {
    private final File parentFile;
    private final String[] osdAddresses;
    private final String[] osdUUIDs;
    private final GlobalTypes.StripingPolicyType stripingPolicy;
    private final int stripeSize;
    private final int stripingWidth;
    private final int replicationFlags;
    private RPC.UserCredentials userCreds;

    Replica(File parentFile, Map<String, Object> json, RPC.UserCredentials userCreds) throws JSONException {
        this.parentFile = parentFile;
        this.userCreds = userCreds;
        try {
            Map sp = (Map)json.get("striping-policy");
            String spName = (String)sp.get("pattern");
            if (!spName.equals("STRIPING_POLICY_RAID0")) {
                throw new JSONException("Unknown striping policy type: " + spName);
            }
            this.stripingPolicy = GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0;
            Long tmp = (Long)sp.get("size");
            this.stripeSize = tmp.intValue();
            tmp = (Long)sp.get("width");
            this.stripingWidth = tmp.intValue();
            tmp = (Long)json.get("replication-flags");
            this.replicationFlags = tmp.intValue();
            List osds = (List)json.get("osds");
            this.osdAddresses = new String[this.stripingWidth];
            this.osdUUIDs = new String[this.stripingWidth];
            if (osds.size() != this.stripingWidth) {
                throw new JSONException("replica information incorrect, OSD count < stripingWidth: " + this.stripingWidth);
            }
            for (int i = 0; i < this.stripingWidth; ++i) {
                Map osd = (Map)osds.get(i);
                this.osdAddresses[i] = (String)osd.get("address");
                this.osdUUIDs[i] = (String)osd.get("uuid");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JSONException("malformed JSON replica representation: " + ex);
        }
    }

    public InetSocketAddress getLocation() {
        return this.getOSDAddress(0);
    }

    public InetSocketAddress getOSDAddress(int osdNum) {
        int colon = this.osdAddresses[osdNum].indexOf(":");
        String hostname = this.osdAddresses[osdNum].substring(0, colon);
        String portStr = this.osdAddresses[osdNum].substring(colon + 1);
        int port = Integer.valueOf(portStr);
        return new InetSocketAddress(hostname, port);
    }

    public String getOSDUuid(int osdNum) {
        return this.osdUUIDs[osdNum];
    }

    public int getStripeWidth() {
        return this.stripingWidth;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    public GlobalTypes.StripingPolicyType getStripingPolicy() {
        return this.stripingPolicy;
    }

    public boolean isFullReplica() {
        return (this.replicationFlags & GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber()) != 0;
    }

    public boolean isRandomStrategy() {
        return ReplicationFlags.isRandomStrategy(this.replicationFlags);
    }

    public boolean isSequentialStrategy() {
        return ReplicationFlags.isSequentialStrategy(this.replicationFlags);
    }

    public boolean isSequentialPrefetchingStrategy() {
        return ReplicationFlags.isSequentialPrefetchingStrategy(this.replicationFlags);
    }

    public boolean isRarestFirstStrategy() {
        return ReplicationFlags.isRarestFirstStrategy(this.replicationFlags);
    }

    public boolean isCompleteReplica() throws IOException {
        if ((this.replicationFlags & GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber()) != 0) {
            return true;
        }
        RandomAccessFile raf = this.parentFile.open("r", 0);
        int myNum = raf.getReplicaNumber(this.osdUUIDs[0]);
        boolean isComplete = raf.isCompleteReplica(myNum);
        raf.close();
        return isComplete;
    }

    public void removeReplica(boolean checkForCompleteReplica) throws IOException {
        Replica[] replicas = this.parentFile.getReplicas(this.userCreds);
        if (replicas.length == 1) {
            throw new IOException("cannot remove last replica (delete file instead!)");
        }
        if (checkForCompleteReplica) {
            boolean completeReplica = false;
            for (Replica r : replicas) {
                if (r.getOSDUuid(0).equals(this.osdUUIDs[0]) || !r.isCompleteReplica()) continue;
                completeReplica = true;
                break;
            }
            if (!completeReplica) {
                throw new IOException("cannot remove last complete replica!");
            }
        }
        this.parentFile.removeReplica(this.osdUUIDs[0], this.userCreds);
    }
}

