/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients;

import com.google.protobuf.ByteString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.clients.Replica;
import org.xtreemfs.common.clients.internal.OpenFileList;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.json.JSONString;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class Volume {
    private final MRCServiceClient mrcClient;
    final UUIDResolver uuidResolver;
    private final String volumeName;
    private final RPC.UserCredentials userCreds;
    protected final OSDServiceClient osdClient;
    private final OpenFileList ofl;
    private final int maxRetries;
    private static final GlobalTypes.VivaldiCoordinates emptyCoordinates = GlobalTypes.VivaldiCoordinates.newBuilder().setLocalError(0.0).setXCoordinate(0.0).setYCoordinate(0.0).build();

    Volume(OSDServiceClient osdClient, MRCServiceClient client, String volumeName, UUIDResolver uuidResolver, RPC.UserCredentials userCreds) {
        this(osdClient, client, volumeName, uuidResolver, userCreds, 0, 5);
    }

    Volume(OSDServiceClient osdClient, MRCServiceClient client, String volumeName, UUIDResolver uuidResolver, RPC.UserCredentials userCreds, int mdCacheTimeout_ms, int maxRetries) {
        this.mrcClient = client;
        this.volumeName = volumeName.endsWith("/") ? volumeName : volumeName + "/";
        this.uuidResolver = uuidResolver;
        this.userCreds = userCreds;
        this.osdClient = osdClient;
        this.maxRetries = maxRetries;
        this.ofl = new OpenFileList(client);
        this.ofl.start();
    }

    public String[] list(String path) throws IOException {
        return this.list(path, this.userCreds);
    }

    public String[] list(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.DirectoryEntries> response = null;
        String fixedVol = this.fixPath(this.volumeName);
        String fixedPath = this.fixPath(path);
        try {
            response = this.mrcClient.readdir(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0L, 0, true, 0L);
            MRC.DirectoryEntries entries = response.get();
            String[] list = new String[entries.getEntriesCount()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = entries.getEntries(i).getName();
            }
            String[] stringArray = list;
            return stringArray;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                String[] stringArray = null;
                return stringArray;
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public MRC.DirectoryEntry[] listEntries(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.DirectoryEntries> response = null;
        path = path.replace("//", "/");
        String fixedVol = this.fixPath(this.volumeName);
        String fixedPath = this.fixPath(path);
        try {
            response = this.mrcClient.readdir(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0L, 0, false, 0L);
            MRC.DirectoryEntries entries = response.get();
            MRC.DirectoryEntry[] list = new MRC.DirectoryEntry[entries.getEntriesCount()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = entries.getEntries(i);
                MRC.Stat s = list[i].getStbuf();
                GlobalTypes.OSDWriteResponse r = this.ofl.getLocalFS(this.volumeName + s.getIno());
                if (r == null || !r.hasTruncateEpoch() || r.getTruncateEpoch() <= s.getTruncateEpoch() && (r.getTruncateEpoch() != s.getTruncateEpoch() || r.getSizeInBytes() <= s.getSize())) continue;
                s = s.toBuilder().setSize(r.getSizeInBytes()).setTruncateEpoch(r.getTruncateEpoch()).build();
                list[i] = list[i].toBuilder().setStbuf(s).build();
            }
            MRC.DirectoryEntry[] directoryEntryArray = list;
            return directoryEntryArray;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                MRC.DirectoryEntry[] directoryEntryArray = null;
                return directoryEntryArray;
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public MRC.DirectoryEntry[] listEntries(String path) throws IOException {
        return this.listEntries(path, this.userCreds);
    }

    public File getFile(String path, RPC.UserCredentials userCreds) {
        return new File(this, userCreds, path);
    }

    public File getFile(String path) {
        return new File(this, this.userCreds, path);
    }

    public String getName() {
        return this.volumeName;
    }

    String fixPath(String path) {
        if ((path = path.replace("//", "/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public long getFreeSpace(RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.StatVFS> response = null;
        try {
            response = this.mrcClient.statvfs(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), 0L);
            MRC.StatVFS fsinfo = response.get();
            long l = fsinfo.getBavail() * (long)fsinfo.getBsize();
            return l;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public long getFreeSpace() throws IOException {
        return this.getFreeSpace(this.userCreds);
    }

    public MRC.StatVFS statfs(RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.StatVFS> response = null;
        try {
            MRC.StatVFS fsinfo;
            response = this.mrcClient.statvfs(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), 0L);
            MRC.StatVFS statVFS = fsinfo = response.get();
            return statVFS;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public MRC.StatVFS statfs() throws IOException {
        return this.statfs(this.userCreds);
    }

    public boolean isReplicateOnClose(RPC.UserCredentials userCreds) throws IOException {
        String numRepl = this.getxattr(this.fixPath(this.volumeName), "xtreemfs.repl_factor", userCreds);
        if (numRepl == null) {
            return false;
        }
        return numRepl.equals("1");
    }

    public boolean isReplicateOnClose() throws IOException {
        return this.isReplicateOnClose(this.userCreds);
    }

    public boolean isSnapshot() {
        return this.volumeName.indexOf(64) != -1;
    }

    public int getDefaultReplicationFactor(RPC.UserCredentials userCreds) throws IOException {
        String numRepl = this.getxattr(this.fixPath(this.volumeName), "xtreemfs.repl_factor", userCreds);
        try {
            return Integer.valueOf(numRepl);
        }
        catch (Exception ex) {
            throw new IOException("cannot fetch replication factor", ex);
        }
    }

    public int getDefaultReplicationFactor() throws IOException {
        return this.getDefaultReplicationFactor(this.userCreds);
    }

    public long getUsedSpace(RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.StatVFS> response = null;
        try {
            response = this.mrcClient.statvfs(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), 0L);
            MRC.StatVFS fsinfo = response.get();
            long l = (fsinfo.getBlocks() - fsinfo.getBavail()) * (long)fsinfo.getBsize();
            return l;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public long getUsedSpace() throws IOException {
        return this.getUsedSpace(this.userCreds);
    }

    public long getDefaultObjectSize(RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.StatVFS> response = null;
        try {
            response = this.mrcClient.statvfs(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), 0L);
            MRC.StatVFS fsinfo = response.get();
            long l = fsinfo.getBsize();
            return l;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public long getDefaultObjectSize() throws IOException {
        return this.getDefaultObjectSize(this.userCreds);
    }

    public void enableSnapshots(boolean enable, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.timestampResponse> r = null;
        try {
            String value = enable + "";
            r = this.mrcClient.setxattr(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), "", "xtreemfs.snapshots_enabled", value, ByteString.copyFrom(value.getBytes()), 0);
            r.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public void enableSnapshots(boolean enable) throws IOException {
        this.enableSnapshots(enable, this.userCreds);
    }

    public void snapshot(String name, boolean recursive, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.timestampResponse> r = null;
        try {
            String cmd = "c" + (recursive ? "r" : "") + " " + name;
            r = this.mrcClient.setxattr(null, RPCAuthentication.authNone, userCreds, this.volumeName.replace("/", ""), "", "xtreemfs.snapshots", cmd, ByteString.copyFrom(cmd.getBytes()), 0);
            r.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public void snapshot(String name, boolean recursive) throws IOException {
        this.snapshot(name, recursive, this.userCreds);
    }

    MRC.Stat stat(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.getattrResponse> response = null;
        try {
            response = this.mrcClient.getattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), 0L);
            MRC.Stat s = response.get().getStbuf();
            GlobalTypes.OSDWriteResponse r = this.ofl.getLocalFS(this.volumeName + s.getIno());
            if (r != null && r.hasTruncateEpoch() && (r.getTruncateEpoch() > s.getTruncateEpoch() || r.getTruncateEpoch() == s.getTruncateEpoch() && r.getSizeInBytes() > s.getSize())) {
                s = s.toBuilder().setSize(r.getSizeInBytes()).setTruncateEpoch(r.getTruncateEpoch()).build();
            }
            MRC.Stat stat = s;
            return stat;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    String getxattr(String path, String name, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.getxattrResponse> response = null;
        try {
            response = this.mrcClient.getxattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), name);
            String string = response.get().getValue();
            return string;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENODATA) {
                String string = null;
                return string;
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    String[] listxattr(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.listxattrResponse> response = null;
        try {
            response = this.mrcClient.listxattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), true);
            MRC.listxattrResponse result = response.get();
            List<MRC.XAttr> attrs = result.getXattrsList();
            String[] names = new String[attrs.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = attrs.get(i).getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENODATA) {
                String[] stringArray = null;
                return stringArray;
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void setxattr(String path, String name, String value, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.timestampResponse> response = null;
        try {
            response = this.mrcClient.setxattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), name, value, ByteString.copyFrom(value.getBytes()), 0);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void mkdir(String path, int permissions, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.timestampResponse> response = null;
        try {
            response = this.mrcClient.mkdir(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), permissions);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void touch(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.openResponse> response = null;
        try {
            response = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber(), 448, 0, emptyCoordinates);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void rename(String src, String dest, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.renameResponse> response = null;
        try {
            response = this.mrcClient.rename(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(src), this.fixPath(dest));
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void unlink(String path, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.unlinkResponse> response = null;
        RPCResponse ulnkResp = null;
        try {
            GlobalTypes.FileCredentials fcs;
            response = this.mrcClient.unlink(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path));
            MRC.unlinkResponse resp = response.get();
            GlobalTypes.FileCredentials fileCredentials = fcs = resp.hasCreds() ? resp.getCreds() : null;
            if (fcs != null) {
                for (GlobalTypes.Replica r : fcs.getXlocs().getReplicasList()) {
                    String headOSDuuid = r.getOsdUuids(0);
                    ServiceUUID osdAddr = new ServiceUUID(headOSDuuid, this.uuidResolver);
                    osdAddr.resolve();
                    ulnkResp = this.osdClient.unlink(osdAddr.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, fcs, fcs.getXcap().getFileId());
                    ulnkResp.get();
                    ulnkResp.freeBuffers();
                    ulnkResp = null;
                }
            }
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
            if (ulnkResp != null) {
                ulnkResp.freeBuffers();
            }
        }
    }

    void storeFileSizeUpdate(String fileId, GlobalTypes.OSDWriteResponse resp, RPC.UserCredentials userCreds) {
        this.ofl.fsUpdate(fileId, resp);
    }

    void pushFileSizeUpdate(String fileId, RPC.UserCredentials userCreds) throws IOException {
        GlobalTypes.OSDWriteResponse owr = this.ofl.sendFsUpdate(fileId);
        if (owr != null) {
            GlobalTypes.XCap cap = this.ofl.getCapability(fileId);
            RPCResponse<MRC.timestampResponse> response = null;
            try {
                if (!owr.hasSizeInBytes()) {
                    return;
                }
                long newSize = owr.getSizeInBytes();
                int newEpoch = owr.getTruncateEpoch();
                GlobalTypes.OSDWriteResponse.Builder osdResp = GlobalTypes.OSDWriteResponse.newBuilder().setSizeInBytes(newSize).setTruncateEpoch(newEpoch);
                MRC.xtreemfs_update_file_sizeRequest fsBuf = MRC.xtreemfs_update_file_sizeRequest.newBuilder().setXcap(cap).setOsdWriteResponse(osdResp).build();
                response = this.mrcClient.xtreemfs_update_file_size(null, RPCAuthentication.authNone, userCreds, fsBuf);
                response.get();
            }
            catch (PBRPCException ex) {
                throw Volume.wrapException(ex);
            }
            catch (InterruptedException ex) {
                throw Volume.wrapException(ex);
            }
            finally {
                if (response != null) {
                    response.freeBuffers();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(RandomAccessFile file, String fileId, boolean readOnly, RPC.UserCredentials userCreds) throws IOException {
        this.pushFileSizeUpdate(fileId, userCreds);
        try {
            GlobalTypes.XCap cap = this.ofl.getCapability(fileId);
            RPCResponse<MRC.timestampResponse> response = null;
            try {
                response = this.mrcClient.xtreemfs_update_file_size(null, RPCAuthentication.authNone, userCreds, cap, GlobalTypes.OSDWriteResponse.newBuilder().build(), true, emptyCoordinates);
                response.get();
            }
            catch (Exception ex) {
                Logging.logError(3, this, ex);
                throw new IOException("file could not be closed due to exception");
            }
            finally {
                if (response != null) {
                    response.freeBuffers();
                }
            }
        }
        finally {
            this.ofl.closeFile(fileId, file);
        }
    }

    RandomAccessFile openFile(File parent, int flags, int mode, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.openResponse> response = null;
        String fullPath = this.fixPath(this.volumeName + parent.getPath());
        String fixedVol = this.fixPath(this.volumeName);
        String fixedPath = this.fixPath(parent.getPath());
        try {
            response = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, flags, mode, 0, emptyCoordinates);
            GlobalTypes.FileCredentials cred = response.get().getCreds();
            boolean syncMd = (flags & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_SYNC.getNumber()) > 0;
            boolean rdOnly = cred.getXlocs().getReplicaUpdatePolicy().equals("ronly");
            RandomAccessFile file = new RandomAccessFile(parent, this, this.osdClient, cred, rdOnly, syncMd, userCreds);
            this.ofl.openFile(cred.getXcap(), file);
            RandomAccessFile randomAccessFile = file;
            return randomAccessFile;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                throw new FileNotFoundException("file '" + fullPath + "' does not exist");
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    GlobalTypes.XCap truncateFile(String fileId, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<GlobalTypes.XCap> response = null;
        try {
            response = this.mrcClient.ftruncate(null, RPCAuthentication.authNone, userCreds, this.ofl.getCapability(fileId));
            GlobalTypes.XCap xCap = response.get();
            return xCap;
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                throw new FileNotFoundException("file '" + fileId + "' does not exist");
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    List<String> getSuitableOSDs(File file, int numOSDs, RPC.UserCredentials userCreds) throws IOException {
        String fileId = this.getxattr(file.getPath(), "xtreemfs.file_id", userCreds);
        RPCResponse<MRC.xtreemfs_get_suitable_osdsResponse> response = null;
        try {
            MRC.xtreemfs_get_suitable_osdsRequest request = MRC.xtreemfs_get_suitable_osdsRequest.newBuilder().setFileId(fileId).setNumOsds(numOSDs).build();
            response = this.mrcClient.xtreemfs_get_suitable_osds(null, RPCAuthentication.authNone, userCreds, request);
            List<String> list = response.get().getOsdUuidsList();
            return list;
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void chmod(String path, int mode, RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stbuf = MRC.Stat.newBuilder().setAtimeNs(0L).setAttributes(0).setBlksize(0).setCtimeNs(0L).setDev(0L).setEtag(0L).setGroupId("").setIno(0L).setMode(mode).setMtimeNs(0L).setNlink(0).setSize(0L).setTruncateEpoch(0).setUserId("").build();
        int toSet = MRC.Setattrs.SETATTR_MODE.getNumber();
        RPCResponse<MRC.timestampResponse> response = null;
        try {
            response = this.mrcClient.setattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), stbuf, toSet);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void chown(String path, String user, RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stbuf = MRC.Stat.newBuilder().setAtimeNs(0L).setAttributes(0).setBlksize(0).setCtimeNs(0L).setDev(0L).setEtag(0L).setGroupId("").setIno(0L).setMode(0).setMtimeNs(0L).setNlink(0).setSize(0L).setTruncateEpoch(0).setUserId(user).build();
        int toSet = MRC.Setattrs.SETATTR_UID.getNumber();
        RPCResponse<MRC.timestampResponse> response = null;
        try {
            response = this.mrcClient.setattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), stbuf, toSet);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void chgrp(String path, String group, RPC.UserCredentials userCreds) throws IOException {
        MRC.Stat stbuf = MRC.Stat.newBuilder().setAtimeNs(0L).setAttributes(0).setBlksize(0).setCtimeNs(0L).setDev(0L).setEtag(0L).setGroupId(group).setIno(0L).setMode(0).setMtimeNs(0L).setNlink(0).setSize(0L).setTruncateEpoch(0).setUserId("").build();
        int toSet = MRC.Setattrs.SETATTR_GID.getNumber();
        RPCResponse<MRC.timestampResponse> response = null;
        try {
            response = this.mrcClient.setattr(null, RPCAuthentication.authNone, userCreds, this.fixPath(this.volumeName), this.fixPath(path), stbuf, toSet);
            response.get();
        }
        catch (PBRPCException ex) {
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void setACL(String path, Map<String, Object> aclEntries, RPC.UserCredentials userCreds) throws IOException {
        Map<String, Object> existingACL = this.getACL(path, userCreds);
        for (Map.Entry<String, Object> entry : existingACL.entrySet()) {
            String entity = entry.getKey();
            if (entity.equals("u:") || entity.equals("g:") || entity.equals("o:") || entity.equals("m:")) continue;
            this.setxattr(path, "xtreemfs.acl", "x " + entity, userCreds);
        }
        for (Map.Entry<String, Object> entry : aclEntries.entrySet()) {
            this.setxattr(path, "xtreemfs.acl", "m " + entry.getKey() + ":" + entry.getValue(), userCreds);
        }
    }

    Map<String, Object> getACL(String path, RPC.UserCredentials userCreds) throws IOException {
        try {
            String aclAsJSON = this.getxattr(path, "xtreemfs.acl", userCreds);
            return (Map)JSONParser.parseJSON(new JSONString(aclAsJSON));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    static IOException wrapException(PBRPCException ex) {
        if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
            return new FileNotFoundException(ex.getErrorMessage());
        }
        return new IOException(ex.getPOSIXErrno() + ": " + ex.getErrorMessage(), ex);
    }

    static IOException wrapException(InterruptedException ex) {
        return new IOException("operation was interruped: " + ex, ex);
    }

    public void finalize() {
        this.ofl.shutdown();
    }

    void addReplica(File file, int width, List<String> osdSet, int flags, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.openResponse> response1 = null;
        RPCResponse<OSD.ObjectData> response3 = null;
        String fullPath = this.fixPath(this.volumeName + file.getPath());
        String fixedVol = this.fixPath(this.volumeName);
        String fixedPath = this.fixPath(file.getPath());
        try {
            Replica r = file.getReplica(0);
            GlobalTypes.StripingPolicy sp = GlobalTypes.StripingPolicy.newBuilder().setStripeSize(r.getStripeSize()).setWidth(width).setType(r.getStripingPolicy()).build();
            GlobalTypes.Replica newReplica = GlobalTypes.Replica.newBuilder().addAllOsdUuids(osdSet).setReplicationFlags(flags).setStripingPolicy(sp).build();
            response1 = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber(), 0, emptyCoordinates);
            GlobalTypes.FileCredentials oldCreds = response1.get().getCreds();
            response1.freeBuffers();
            response1 = null;
            boolean readOnlyRepl = oldCreds.getXlocs().getReplicaUpdatePolicy().equals("ronly");
            MRC.xtreemfs_replica_addRequest request = MRC.xtreemfs_replica_addRequest.newBuilder().setNewReplica(newReplica).setFileId(oldCreds.getXcap().getFileId()).build();
            response3 = this.mrcClient.xtreemfs_replica_add(null, RPCAuthentication.authNone, userCreds, request);
            response3.get();
            response3.freeBuffers();
            response3 = null;
            if (readOnlyRepl) {
                if ((flags & GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber()) > 0) {
                    response1 = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber(), 0, emptyCoordinates);
                    GlobalTypes.FileCredentials newCreds = response1.get().getCreds();
                    for (int objNo = 0; objNo < width; ++objNo) {
                        ServiceUUID osd = new ServiceUUID(osdSet.get(objNo), this.uuidResolver);
                        response3 = this.osdClient.read(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, newCreds, newCreds.getXcap().getFileId(), objNo, 0L, 0, 1);
                        response3.get();
                        response3.freeBuffers();
                        response3 = null;
                    }
                }
            } else {
                response1 = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber(), 0, emptyCoordinates);
                GlobalTypes.FileCredentials newCreds = response1.get().getCreds();
                ServiceUUID osd = new ServiceUUID(osdSet.get(0), this.uuidResolver);
                response3 = this.osdClient.xtreemfs_rwr_notify(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, newCreds);
                response3.get();
                response3.freeBuffers();
                response3 = null;
            }
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                throw new FileNotFoundException("file '" + fullPath + "' does not exist");
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response1 != null) {
                response1.freeBuffers();
            }
            if (response3 != null) {
                response3.freeBuffers();
            }
        }
    }

    void removeReplica(File file, String headOSDuuid, RPC.UserCredentials userCreds) throws IOException {
        RPCResponse<MRC.openResponse> response1 = null;
        RPCResponse<GlobalTypes.FileCredentials> response2 = null;
        RPCResponse response3 = null;
        String fullPath = this.fixPath(this.volumeName + file.getPath());
        String fixedVol = this.fixPath(this.volumeName);
        String fixedPath = this.fixPath(file.getPath());
        try {
            response1 = this.mrcClient.open(null, RPCAuthentication.authNone, userCreds, fixedVol, fixedPath, 0, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber(), 0, emptyCoordinates);
            GlobalTypes.FileCredentials oldCreds = response1.get().getCreds();
            MRC.xtreemfs_replica_removeRequest request = MRC.xtreemfs_replica_removeRequest.newBuilder().setOsdUuid(headOSDuuid).setFileId(oldCreds.getXcap().getFileId()).build();
            response2 = this.mrcClient.xtreemfs_replica_remove(null, RPCAuthentication.authNone, userCreds, request);
            GlobalTypes.FileCredentials delCap = response2.get();
            ServiceUUID osd = new ServiceUUID(headOSDuuid, this.uuidResolver);
            boolean readOnlyRepl = oldCreds.getXlocs().getReplicaUpdatePolicy().equals("ronly");
            GlobalTypes.FileCredentials newCreds = GlobalTypes.FileCredentials.newBuilder().setXcap(delCap.getXcap()).setXlocs(oldCreds.getXlocs()).build();
            response3 = this.osdClient.unlink(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, newCreds, oldCreds.getXcap().getFileId());
            response3.get();
        }
        catch (PBRPCException ex) {
            if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT) {
                throw new FileNotFoundException("file '" + fullPath + "' does not exist");
            }
            throw Volume.wrapException(ex);
        }
        catch (InterruptedException ex) {
            throw Volume.wrapException(ex);
        }
        finally {
            if (response1 != null) {
                response1.freeBuffers();
            }
            if (response2 != null) {
                response2.freeBuffers();
            }
            if (response3 != null) {
                response3.freeBuffers();
            }
        }
    }

    void shutdown() {
        this.ofl.shutdown();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

