/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class XtreemFSFileOutputStream
extends OutputStream {
    private long position = 0L;
    private RPC.UserCredentials userCredentials;
    private FileHandle fileHandle;
    private String fileName;
    private boolean useBuffer;
    private ByteBuffer buffer;

    public XtreemFSFileOutputStream(RPC.UserCredentials userCredentials, FileHandle fileHandle, String fileName, boolean useBuffer, int bufferSize) throws IOException {
        this(userCredentials, fileHandle, fileName, useBuffer, bufferSize, false);
    }

    public XtreemFSFileOutputStream(RPC.UserCredentials userCredentials, FileHandle fileHandle, String fileName, boolean useBuffer, int bufferSize, boolean append) throws IOException {
        this.userCredentials = userCredentials;
        this.fileHandle = fileHandle;
        this.fileName = fileName;
        this.useBuffer = useBuffer;
        if (useBuffer) {
            this.buffer = ByteBuffer.allocateDirect(bufferSize);
        }
        if (append) {
            this.position = fileHandle.getAttr(userCredentials).getSize();
        }
    }

    public synchronized void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        if (this.useBuffer) {
            this.writeToBuffer(data, 0, 1);
        } else {
            int writtenBytes = this.fileHandle.write(this.userCredentials, data, 1, this.position);
            this.position += (long)writtenBytes;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.useBuffer) {
            this.writeToBuffer(b, off, len);
        } else {
            int writtenBytes = this.fileHandle.write(this.userCredentials, b, off, len, this.position);
            this.position += (long)writtenBytes;
        }
    }

    public synchronized void close() throws IOException {
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "Closing file %s", this.fileName);
        }
        if (this.useBuffer && this.buffer.position() > 0) {
            byte[] bytesWriteToFile = this.flushBuffer();
            this.fileHandle.write(this.userCredentials, bytesWriteToFile, bytesWriteToFile.length, this.position);
            this.buffer = null;
        }
        super.close();
        this.fileHandle.close();
    }

    private synchronized void writeToBuffer(byte[] b, int off, int len) throws IOException {
        if (this.buffer.remaining() > len) {
            this.buffer.put(b, off, len);
        } else {
            byte[] buffercontent = this.flushBuffer();
            byte[] bytesWriteToFile = new byte[buffercontent.length + len];
            System.arraycopy(buffercontent, 0, bytesWriteToFile, 0, buffercontent.length);
            System.arraycopy(b, off, bytesWriteToFile, buffercontent.length, len);
            int writtenBytes = this.fileHandle.write(this.userCredentials, bytesWriteToFile, bytesWriteToFile.length, this.position);
            this.position += (long)writtenBytes;
        }
    }

    private byte[] flushBuffer() {
        int bytesInBuffer = this.buffer.position();
        this.buffer.clear();
        byte[] buffercontent = new byte[bytesInBuffer];
        this.buffer.get(buffercontent, 0, bytesInBuffer);
        this.buffer.clear();
        return buffercontent;
    }
}

