/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.hadoop;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.xtreemfs.common.clients.hadoop.XtreemFSFileOutputStream;
import org.xtreemfs.common.clients.hadoop.XtreemFSInputStream;
import org.xtreemfs.common.libxtreemfs.Client;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.VolumeNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class XtreemFSFileSystem
extends FileSystem {
    private URI fileSystemURI;
    private Client xtreemfsClient;
    private Map<String, Volume> xtreemfsVolumes;
    Set<String> defaultVolumeDirectories;
    private Path workingDirectory;
    private RPC.UserCredentials userCredentials;
    private boolean useReadBuffer;
    private boolean useWriteBuffer;
    private int readBufferSize;
    private int writeBufferSize;
    private Volume defaultVolume;
    private Configuration conf;

    public void initialize(URI uri, Configuration conf) throws IOException {
        String defaultVolumeName;
        super.initialize(uri, conf);
        this.conf = conf;
        int logLevel = 4;
        if (conf.getBoolean("xtreemfs.client.debug", false)) {
            logLevel = 7;
        }
        Logging.start(logLevel, Logging.Category.all);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "init : " + uri, new Object[0]);
        }
        if ((defaultVolumeName = conf.get("xtreemfs.defaultVolumeName")) == null) {
            throw new IOException("You have to specify a default volume name in core-site.xml! (xtreemfs.defaultVolumeName)");
        }
        this.useReadBuffer = conf.getBoolean("xtreemfs.io.buffer.read", false);
        this.readBufferSize = conf.getInt("xtreemfs.io.buffer.size.read", 0);
        if (this.useReadBuffer && this.readBufferSize == 0) {
            this.useReadBuffer = false;
        }
        this.useWriteBuffer = conf.getBoolean("xtreemfs.io.buffer.write", false);
        this.writeBufferSize = conf.getInt("xtreemfs.io.buffer.size.write", 0);
        if (this.useWriteBuffer && this.writeBufferSize == 0) {
            this.useWriteBuffer = false;
        }
        if (conf.get("xtreemfs.client.userid") != null && conf.get("xtreemfs.client.groupid") != null) {
            this.userCredentials = RPC.UserCredentials.newBuilder().setUsername(conf.get("xtreemfs.client.userid")).addGroups(conf.get("xtreemfs.client.groupid")).build();
        }
        if (this.userCredentials == null) {
            this.userCredentials = System.getProperty("user.name") != null ? RPC.UserCredentials.newBuilder().setUsername(System.getProperty("user.name")).addGroups("users").build() : RPC.UserCredentials.newBuilder().setUsername("xtreemfs").addGroups("xtreemfs").build();
        }
        SSLOptions sslOptions = null;
        if (conf.getBoolean("xtreemfs.ssl.enabled", false)) {
            String credentialFilePath = conf.get("xtreemfs.ssl.credentialFile");
            if (credentialFilePath == null) {
                throw new IOException("You have to specify a server credential file in core-site.xml! (xtreemfs.ssl.serverCredentialFile)");
            }
            FileInputStream credentialFile = new FileInputStream(credentialFilePath);
            String credentialFilePassphrase = conf.get("xtreemfs.ssl.credentialFile.passphrase");
            String trustedCertificatesFilePath = conf.get("xtreemfs.ssl.trustedCertificatesFile");
            String trustedCertificatesFilePassphrase = conf.get("xtreemfs.ssl.trustedCertificatesFile.passphrase");
            String trustedCertificatesFileContainer = null;
            FileInputStream trustedCertificatesFile = null;
            String sslProtocolString = conf.get("xtreemfs.ssl.protocol");
            if (trustedCertificatesFilePath == null) {
                trustedCertificatesFileContainer = "none";
            } else {
                trustedCertificatesFile = new FileInputStream(trustedCertificatesFilePath);
                trustedCertificatesFileContainer = "JKS";
            }
            sslOptions = new SSLOptions(credentialFile, credentialFilePassphrase, "PKCS12", trustedCertificatesFile, trustedCertificatesFilePassphrase, trustedCertificatesFileContainer, conf.getBoolean("xtreemfs.ssl.authenticationWithoutEncryption", false), false, sslProtocolString, null);
        }
        Options xtreemfsOptions = new Options();
        xtreemfsOptions.setMetadataCacheSize(0);
        this.xtreemfsClient = ClientFactory.createClient(uri.getHost() + ":" + uri.getPort(), this.userCredentials, sslOptions, xtreemfsOptions);
        try {
            this.xtreemfsClient.start(true);
        }
        catch (Exception ex) {
            Logger.getLogger(XtreemFSFileSystem.class.getName()).log(Level.SEVERE, null, ex);
        }
        String[] volumeNames = this.xtreemfsClient.listVolumeNames();
        this.xtreemfsVolumes = new HashMap<String, Volume>(volumeNames.length);
        for (String volumeName : volumeNames) {
            try {
                this.xtreemfsVolumes.put(volumeName, this.xtreemfsClient.openVolume(volumeName, sslOptions, xtreemfsOptions));
            }
            catch (VolumeNotFoundException ve) {
                Logging.logMessage(3, Logging.Category.misc, (Object)this, "Unable to open volume %s. Make sure this volume exists!", volumeName);
                throw new IOException("Unable to open volume " + volumeName);
            }
            catch (AddressToUUIDNotFoundException aue) {
                Logging.logMessage(3, Logging.Category.misc, (Object)this, "Unable to resolve UUID for volumeName %s", volumeName);
                throw new IOException(aue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.defaultVolumeDirectories = new HashSet<String>();
        this.defaultVolume = this.xtreemfsVolumes.get(defaultVolumeName);
        for (MRC.DirectoryEntry dirEntry : this.defaultVolume.readDir(this.userCredentials, "/", 0, 0, true).getEntriesList()) {
            if (!this.isXtreemFSDirectory("/" + dirEntry.getName(), this.defaultVolume)) continue;
            this.defaultVolumeDirectories.add(dirEntry.getName());
        }
        this.fileSystemURI = uri;
        this.workingDirectory = this.getHomeDirectory();
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "file system init complete: " + uri.getUserInfo(), new Object[0]);
        }
    }

    public URI getUri() {
        return this.fileSystemURI;
    }

    public String getScheme() {
        return "xtreemfs://";
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        FileHandle fileHandle = xtreemfsVolume.openFile(this.userCredentials, pathString, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber(), 0);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Opening file %s", pathString);
        }
        this.statistics.incrementReadOps(1);
        return new FSDataInputStream((InputStream)((Object)new XtreemFSInputStream(this.userCredentials, fileHandle, pathString, this.useReadBuffer, this.readBufferSize, this.statistics)));
    }

    public FSDataOutputStream create(Path path, FsPermission fp, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable p) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber();
        if (overwrite) {
            flags |= GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber();
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Creating file %s. Overwrite = %s", pathString, overwrite);
        }
        if (pathString.lastIndexOf("/") != 0) {
            this.mkdirs(path.getParent());
        }
        FileHandle fileHandle = xtreemfsVolume.openFile(this.userCredentials, pathString, flags, fp.toShort());
        return new FSDataOutputStream((OutputStream)new XtreemFSFileOutputStream(this.userCredentials, fileHandle, pathString, this.useWriteBuffer, this.writeBufferSize), this.statistics);
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable p) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Append new content to file %s.", pathString);
        }
        FileHandle fileHandle = xtreemfsVolume.openFile(this.userCredentials, pathString, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber());
        return new FSDataOutputStream((OutputStream)new XtreemFSFileOutputStream(this.userCredentials, fileHandle, pathString, this.useWriteBuffer, this.writeBufferSize, true), this.statistics);
    }

    public boolean rename(Path src, Path dest) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(src);
        String srcPath = this.preparePath(src, xtreemfsVolume);
        String destPath = this.preparePath(dest, xtreemfsVolume);
        xtreemfsVolume.rename(this.userCredentials, srcPath, destPath);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Renamed file/dir. src: %s, dst: %s", srcPath, destPath);
        }
        this.statistics.incrementWriteOps(1);
        return true;
    }

    public boolean delete(Path path) throws IOException {
        return this.delete(path, false);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        if (this.isXtreemFSFile(pathString, xtreemfsVolume)) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, (Object)this, "Deleting file %s", pathString);
            }
            return this.deleteXtreemFSFile(pathString, xtreemfsVolume);
        }
        if (this.isXtreemFSDirectory(pathString, xtreemfsVolume)) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, (Object)this, "Deleting directory %s", pathString);
            }
            return this.deleteXtreemFSDirectory(pathString, xtreemfsVolume, recursive);
        }
        return false;
    }

    private boolean deleteXtreemFSDirectory(String path, Volume xtreemfsVolume, boolean recursive) throws IOException {
        boolean isEmpty;
        MRC.DirectoryEntries dirEntries = xtreemfsVolume.readDir(this.userCredentials, path, 0, 0, true);
        boolean bl = isEmpty = dirEntries.getEntriesCount() <= 2;
        if (recursive) {
            return this.deleteXtreemFSDirRecursive(path, xtreemfsVolume);
        }
        if (isEmpty) {
            xtreemfsVolume.removeDirectory(this.userCredentials, path);
            return true;
        }
        return false;
    }

    private boolean deleteXtreemFSDirRecursive(String path, Volume xtreemfsVolume) throws IOException {
        boolean success = true;
        try {
            MRC.DirectoryEntries dirEntries = xtreemfsVolume.readDir(this.userCredentials, path, 0, 0, false);
            for (MRC.DirectoryEntry dirEntry : dirEntries.getEntriesList()) {
                if (dirEntry.getName().equals(".") || dirEntry.getName().equals("..")) continue;
                if (this.isXtreemFSFile(dirEntry.getStbuf())) {
                    xtreemfsVolume.unlink(this.userCredentials, path + "/" + dirEntry.getName());
                }
                if (!this.isXtreemFSDirectory(dirEntry.getStbuf())) continue;
                success = this.deleteXtreemFSDirRecursive(path + "/" + dirEntry.getName(), xtreemfsVolume);
            }
            xtreemfsVolume.removeDirectory(this.userCredentials, path);
        }
        catch (XtreemFSException xe) {
            success = false;
        }
        return success;
    }

    private boolean deleteXtreemFSFile(String path, Volume xtreemfsVolume) throws IOException {
        try {
            xtreemfsVolume.unlink(this.userCredentials, path);
            return true;
        }
        catch (XtreemFSException xe) {
            Logging.logMessage(7, Logging.Category.misc, (Object)this, "failed to delete file %s, reason: %s", path, xe.getMessage());
            return false;
        }
    }

    private boolean isXtreemFSFile(String path, Volume xtreemfsVolume) throws IOException {
        MRC.Stat stat = null;
        try {
            stat = xtreemfsVolume.getAttr(this.userCredentials, path);
        }
        catch (PosixErrorException pee) {
            if (pee.getPosixError().equals(RPC.POSIXErrno.POSIX_ERROR_ENOENT)) {
                return false;
            }
            throw pee;
        }
        if (stat != null) {
            return this.isXtreemFSFile(stat);
        }
        return false;
    }

    private boolean isXtreemFSFile(MRC.Stat stat) {
        return (stat.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFREG.getNumber()) > 0;
    }

    private boolean isXtreemFSDirectory(String path, Volume xtreemfsVolume) throws IOException {
        MRC.Stat stat = null;
        try {
            stat = xtreemfsVolume.getAttr(this.userCredentials, path);
        }
        catch (PosixErrorException pee) {
            if (pee.getPosixError().equals(RPC.POSIXErrno.POSIX_ERROR_ENOENT)) {
                return false;
            }
            throw pee;
        }
        if (stat != null) {
            return this.isXtreemFSDirectory(stat);
        }
        return false;
    }

    private boolean isXtreemFSDirectory(MRC.Stat stat) {
        return (stat.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber()) > 0;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        if (path == null) {
            return null;
        }
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "ls: " + pathString, new Object[0]);
        }
        if (!this.isXtreemFSDirectory(pathString, xtreemfsVolume)) {
            return null;
        }
        MRC.DirectoryEntries dirEntries = xtreemfsVolume.readDir(this.userCredentials, pathString, 0, 0, false);
        this.statistics.incrementLargeReadOps(1);
        ArrayList<FileStatus> fileStatus = new ArrayList<FileStatus>(dirEntries.getEntriesCount() - 2);
        for (MRC.DirectoryEntry entry : dirEntries.getEntriesList()) {
            if (entry.getName().equals("..") || entry.getName().equals(".")) continue;
            MRC.Stat stat = entry.getStbuf();
            boolean isDir = this.isXtreemFSDirectory(stat);
            if (isDir) {
                fileStatus.add(new FileStatus(0L, isDir, 1, 0L, (long)((double)stat.getMtimeNs() / 1000000.0), (long)((double)stat.getAtimeNs() / 1000000.0), new FsPermission((short)stat.getMode()), stat.getUserId(), stat.getGroupId(), new Path(this.makeAbsolute(path), entry.getName())));
                continue;
            }
            fileStatus.add(new FileStatus(stat.getSize(), isDir, 1, (long)(xtreemfsVolume.statFS(this.userCredentials).getDefaultStripingPolicy().getStripeSize() * 1024), (long)((double)stat.getMtimeNs() / 1000000.0), (long)((double)stat.getAtimeNs() / 1000000.0), new FsPermission((short)stat.getMode()), stat.getUserId(), stat.getGroupId(), new Path(this.makeAbsolute(path), entry.getName())));
        }
        return fileStatus.toArray(new FileStatus[fileStatus.size()]);
    }

    public void setWorkingDirectory(Path path) {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        this.workingDirectory = new Path(this.preparePath(path, xtreemfsVolume));
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    private Path makeAbsolute(Path p) {
        if (p.isAbsolute()) {
            return p;
        }
        return new Path(this.workingDirectory, p);
    }

    public boolean mkdirs(Path path, FsPermission fp) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        String[] dirs = pathString.split("/");
        this.statistics.incrementWriteOps(1);
        short mode = fp.toShort();
        String dirString = "";
        if (xtreemfsVolume == this.defaultVolume) {
            this.defaultVolumeDirectories.add(dirs[0]);
        }
        for (String dir : dirs) {
            if (this.isXtreemFSFile(dirString = dirString + dir + "/", xtreemfsVolume)) {
                return false;
            }
            if (this.isXtreemFSDirectory(dirString, xtreemfsVolume)) continue;
            xtreemfsVolume.createDirectory(this.userCredentials, dirString, mode);
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Created direcotry %s", pathString);
        }
        return true;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        Volume xtreemfsVolume = this.getVolumeFromPath(path);
        String pathString = this.preparePath(path, xtreemfsVolume);
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "getting file status for file %s", pathString);
        }
        MRC.Stat stat = null;
        try {
            stat = xtreemfsVolume.getAttr(this.userCredentials, pathString);
        }
        catch (PosixErrorException pee) {
            if (pee.getPosixError().equals(RPC.POSIXErrno.POSIX_ERROR_ENOENT)) {
                throw new FileNotFoundException();
            }
            throw pee;
        }
        boolean isDir = this.isXtreemFSDirectory(stat);
        if (isDir) {
            return new FileStatus(0L, isDir, 1, 0L, (long)((double)stat.getMtimeNs() / 1000000.0), (long)((double)stat.getAtimeNs() / 1000000.0), new FsPermission((short)stat.getMode()), stat.getUserId(), stat.getGroupId(), this.makeQualified(path));
        }
        return new FileStatus(stat.getSize(), isDir, 1, (long)(xtreemfsVolume.statFS(this.userCredentials).getDefaultStripingPolicy().getStripeSize() * 1024), (long)((double)stat.getMtimeNs() / 1000000.0), (long)((double)stat.getAtimeNs() / 1000000.0), new FsPermission((short)stat.getMode()), stat.getUserId(), stat.getGroupId(), this.makeQualified(path));
    }

    public void close() throws IOException {
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Closing %s", XtreemFSFileSystem.class.getName());
        }
        super.close();
        for (Volume xtreemfsVolume : this.xtreemfsVolumes.values()) {
            xtreemfsVolume.close();
        }
        this.xtreemfsClient.shutdown();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long length) throws IOException {
        if (file == null) {
            return null;
        }
        Volume xtreemfsVolume = this.getVolumeFromPath(file.getPath());
        String pathString = this.preparePath(file.getPath(), xtreemfsVolume);
        List<Volume.StripeLocation> stripeLocations = xtreemfsVolume.getStripeLocations(this.userCredentials, pathString, start, length);
        BlockLocation[] result = new BlockLocation[stripeLocations.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BlockLocation(stripeLocations.get(i).getUuids(), stripeLocations.get(i).getHostnames(), stripeLocations.get(i).getStartSize(), stripeLocations.get(i).getLength());
        }
        return result;
    }

    private String preparePath(Path path, Volume volume) {
        String pathString = this.makeAbsolute(path).toUri().getPath();
        if (volume == this.defaultVolume) {
            return pathString;
        }
        int pathBegin = pathString.indexOf("/", 1);
        String pathStringWithoutVolume = pathString.substring(pathBegin);
        return pathStringWithoutVolume;
    }

    private Volume getVolumeFromPath(Path path) {
        String pathString = this.makeAbsolute(path).toUri().getPath();
        String[] splittedPath = pathString.split("/");
        if (splittedPath.length > 1 && this.defaultVolumeDirectories.contains(splittedPath[1]) || pathString.lastIndexOf("/") == 0) {
            return this.defaultVolume;
        }
        String volumeName = pathString.substring(1, pathString.indexOf("/", 1));
        Volume volume = this.xtreemfsVolumes.get(volumeName);
        if (volume == null) {
            return this.defaultVolume;
        }
        return volume;
    }
}

