/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class XtreemFSInputStream
extends FSInputStream {
    private long position = 0L;
    private long bufferFilePosition = 0L;
    private RPC.UserCredentials userCredentials;
    private String fileName;
    private FileHandle fileHandle;
    private FileSystem.Statistics statistics;
    private boolean useBuffer;
    private ByteBuffer buffer;
    private boolean EOF = false;

    public XtreemFSInputStream(RPC.UserCredentials userCredentials, FileHandle fileHandle, String fileName, boolean useBuffer, int bufferSize, FileSystem.Statistics statistics) throws IOException {
        this.userCredentials = userCredentials;
        this.fileHandle = fileHandle;
        this.fileName = fileName;
        this.statistics = statistics;
        this.useBuffer = useBuffer;
        if (useBuffer) {
            this.buffer = ByteBuffer.allocateDirect(bufferSize);
            this.buffer.position(this.buffer.capacity());
        }
    }

    public synchronized void seek(long l) throws IOException {
        this.position = l;
        if (this.useBuffer) {
            this.bufferFilePosition = l;
            this.buffer.position(this.buffer.limit());
        }
    }

    public synchronized long getPos() throws IOException {
        return this.position;
    }

    public synchronized boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        byte[] data = new byte[1];
        int bytesRead = 0;
        bytesRead = this.useBuffer ? this.readFromBuffer(data, 0, 1) : this.fileHandle.read(this.userCredentials, data, 1, this.position);
        if (bytesRead == 0) {
            return -1;
        }
        ++this.position;
        this.statistics.incrementBytesRead(1L);
        return data[0] & 0xFF;
    }

    public synchronized int read(byte[] bytes, int offset, int length) throws IOException {
        int bytesRead = 0;
        bytesRead = this.useBuffer ? this.readFromBuffer(bytes, offset, length) : this.fileHandle.read(this.userCredentials, bytes, offset, length, this.position);
        if (bytesRead == 0 && length > 0) {
            return -1;
        }
        this.position += (long)bytesRead;
        this.statistics.incrementBytesRead((long)bytesRead);
        return bytesRead;
    }

    public synchronized int read(long position, byte[] bytes, int offset, int length) throws IOException {
        int bytesRead = this.fileHandle.read(this.userCredentials, bytes, offset, length, position);
        if (bytesRead == 0 && length > 0) {
            return -1;
        }
        this.statistics.incrementBytesRead((long)bytesRead);
        return bytesRead;
    }

    public synchronized int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public synchronized void close() throws IOException {
        if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)this, "Closing file %s", this.fileName);
        }
        super.close();
        this.fileHandle.close();
    }

    private int readFromBuffer(byte[] bytes, int offset, int length) throws IOException {
        byte[] tmp;
        int bytesRead;
        if (this.EOF || length == 0) {
            return 0;
        }
        if (this.buffer.remaining() >= length) {
            this.buffer.get(bytes, offset, length);
            return length;
        }
        int bytesLeftToRead = length;
        int newBytesOffset = offset;
        int bytesReadFromBuffer = 0;
        if (this.buffer.hasRemaining()) {
            bytesReadFromBuffer = this.buffer.remaining();
            this.buffer.get(bytes, offset, this.buffer.remaining());
            bytesLeftToRead -= bytesReadFromBuffer;
            newBytesOffset += bytesReadFromBuffer;
        }
        if ((bytesRead = this.fileHandle.read(this.userCredentials, tmp = new byte[this.buffer.capacity()], 0, tmp.length, this.bufferFilePosition)) == 0) {
            this.EOF = true;
            return bytesReadFromBuffer;
        }
        this.bufferFilePosition += (long)bytesRead;
        this.buffer.clear();
        this.buffer.put(tmp, 0, bytesRead);
        this.buffer.position(0);
        this.buffer.limit(bytesRead);
        return bytesReadFromBuffer + this.readFromBuffer(bytes, newBytesOffset, bytesLeftToRead);
    }
}

