/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.internal;

import java.util.List;
import org.xtreemfs.common.clients.internal.RAID0ObjectMapper;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public abstract class ObjectMapper {
    private GlobalTypes.StripingPolicy fileSP;

    protected ObjectMapper(GlobalTypes.StripingPolicy fileSP) {
        this.fileSP = fileSP;
    }

    public static ObjectMapper getMapper(GlobalTypes.StripingPolicy fileSP) {
        if (fileSP.getType() == GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0) {
            return new RAID0ObjectMapper(fileSP);
        }
        throw new RuntimeException("unknown striping policy type: " + fileSP.getType());
    }

    public abstract List<ObjectRequest> readRequest(int var1, long var2, Replica var4);

    public abstract List<ObjectRequest> writeRequest(ReusableBuffer var1, long var2, Replica var4);

    public static class ObjectRequest {
        private final long objNo;
        private final int offset;
        private final int length;
        private ReusableBuffer data;
        private final String osdUUID;

        public ObjectRequest(long objNo, int offset, int length, String osdUUID, ReusableBuffer data) {
            this.objNo = objNo;
            this.offset = offset;
            this.data = data;
            this.length = length;
            this.osdUUID = osdUUID;
        }

        public long getObjNo() {
            return this.objNo;
        }

        public int getOffset() {
            return this.offset;
        }

        public ReusableBuffer getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }

        public String getOsdUUID() {
            return this.osdUUID;
        }

        public void setData(ReusableBuffer data) {
            this.data = data;
        }
    }
}

