/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;

public class OpenFileList
extends Thread {
    private final Map<String, CapEntry> capabilities = new HashMap<String, CapEntry>();
    private final Map<String, GlobalTypes.OSDWriteResponse> fsUpdateCache = new HashMap<String, GlobalTypes.OSDWriteResponse>();
    private final MRCServiceClient client;
    private volatile boolean quit;

    public OpenFileList(MRCServiceClient client) {
        super("XCapRNThr");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(GlobalTypes.XCap capability, RandomAccessFile f) {
        Map<String, CapEntry> map = this.capabilities;
        synchronized (map) {
            CapEntry e = this.capabilities.get(capability.getFileId());
            if (e == null) {
                e = new CapEntry(capability, TimeSync.getLocalSystemTime() + (long)(capability.getExpireTimeoutS() * 1000));
                this.capabilities.put(capability.getFileId(), e);
            } else {
                e.upgradeCap(capability, TimeSync.getLocalSystemTime() + (long)(capability.getExpireTimeoutS() * 1000));
            }
            e.addFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String fileId, RandomAccessFile f) {
        boolean lastFile = false;
        Map<String, Object> map = this.capabilities;
        synchronized (map) {
            CapEntry e = this.capabilities.get(fileId);
            if (e != null) {
                lastFile = e.removeFile(f);
                if (lastFile) {
                    this.capabilities.remove(fileId);
                }
            } else {
                throw new IllegalStateException("entry must nut be null");
            }
        }
        if (lastFile) {
            map = this.fsUpdateCache;
            synchronized (map) {
                this.fsUpdateCache.remove(fileId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTypes.OSDWriteResponse sendFsUpdate(String fileId) {
        Map<String, GlobalTypes.OSDWriteResponse> map = this.fsUpdateCache;
        synchronized (map) {
            return this.fsUpdateCache.remove(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTypes.OSDWriteResponse getLocalFS(String fileId) {
        Map<String, GlobalTypes.OSDWriteResponse> map = this.fsUpdateCache;
        synchronized (map) {
            return this.fsUpdateCache.get(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsUpdate(String fileId, GlobalTypes.OSDWriteResponse resp) {
        if (resp == null || !resp.hasSizeInBytes()) {
            return;
        }
        Map<String, GlobalTypes.OSDWriteResponse> map = this.fsUpdateCache;
        synchronized (map) {
            GlobalTypes.OSDWriteResponse last = this.fsUpdateCache.get(fileId);
            if (last == null) {
                this.fsUpdateCache.put(fileId, resp);
                return;
            }
            GlobalTypes.OSDWriteResponse newFS = resp;
            GlobalTypes.OSDWriteResponse oldFS = last;
            if (newFS.getTruncateEpoch() > oldFS.getTruncateEpoch() || newFS.getTruncateEpoch() == oldFS.getTruncateEpoch() && newFS.getSizeInBytes() > oldFS.getSizeInBytes()) {
                this.fsUpdateCache.put(fileId, resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTypes.XCap getCapability(String fileId) {
        Map<String, CapEntry> map = this.capabilities;
        synchronized (map) {
            CapEntry e = this.capabilities.get(fileId);
            if (e == null) {
                return null;
            }
            return e.getCap();
        }
    }

    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            LinkedList<CapEntry> renewList = new LinkedList<CapEntry>();
            Map<String, CapEntry> map = this.capabilities;
            synchronized (map) {
                long expTime = TimeSync.getLocalSystemTime() + (long)(GlobalTypes.CONSTANTS.XCAP_RENEW_INTERVAL_IN_MIN.getNumber() * 60 * 1000);
                for (CapEntry e : this.capabilities.values()) {
                    if (e.getLocalTimestamp() > expTime) continue;
                    renewList.add(e);
                }
            }
            for (CapEntry cap : renewList) {
                this.renewCap(cap);
            }
            try {
                OpenFileList.sleep(GlobalTypes.CONSTANTS.XCAP_RENEW_INTERVAL_IN_MIN.getNumber() * 60 * 1000 / 2);
            }
            catch (InterruptedException ex) {
                break;
            }
        } while (!this.quit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renewCap(CapEntry cap) {
        assert (cap != null);
        RPCResponse<GlobalTypes.XCap> r = null;
        try {
            r = this.client.xtreemfs_renew_capability(null, RPCAuthentication.authNone, RPCAuthentication.userService, cap.getCap());
            GlobalTypes.XCap newCap = r.get();
            Map<String, CapEntry> map = this.capabilities;
            synchronized (map) {
                cap.updateCap(newCap, TimeSync.getLocalSystemTime() + (long)(GlobalTypes.CONSTANTS.XCAP_RENEW_INTERVAL_IN_MIN.getNumber() * 60 * 1000) - 1000L);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "cannot renew cap due to exception", new Object[0]);
            Logging.logError(3, this, ex);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    public static class CapEntry {
        private GlobalTypes.XCap cap;
        private long localTimestamp;
        final List<RandomAccessFile> files;

        public CapEntry(GlobalTypes.XCap c, long ts) {
            this.cap = c;
            this.localTimestamp = ts;
            this.files = new LinkedList<RandomAccessFile>();
        }

        public void addFile(RandomAccessFile file) {
            this.files.add(file);
        }

        public boolean removeFile(RandomAccessFile file) {
            this.files.remove(file);
            return this.files.isEmpty();
        }

        public void updateCap(GlobalTypes.XCap c, long ts) {
            this.cap = c;
            this.localTimestamp = ts;
            for (RandomAccessFile file : this.files) {
                file.updateCap(c);
            }
        }

        public void upgradeCap(GlobalTypes.XCap c, long ts) {
            if ((this.cap.getAccessMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber()) > 0 && (c.getAccessMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber()) > 0) {
                this.updateCap(c, ts);
            }
        }

        public GlobalTypes.XCap getCap() {
            return this.cap;
        }

        public long getLocalTimestamp() {
            return this.localTimestamp;
        }
    }
}

