/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.internal;

import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.common.clients.internal.ObjectMapper;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RAID0ObjectMapper
extends ObjectMapper {
    private final int stripeSize;

    protected RAID0ObjectMapper(GlobalTypes.StripingPolicy fileSP) {
        super(fileSP);
        this.stripeSize = fileSP.getStripeSize() * 1024;
    }

    @Override
    public List<ObjectMapper.ObjectRequest> readRequest(int length, long fileOffset, Replica replica) {
        int lastSize;
        LinkedList<ObjectMapper.ObjectRequest> reqs = new LinkedList<ObjectMapper.ObjectRequest>();
        long firstObj = fileOffset / (long)this.stripeSize;
        long lastObj = (fileOffset + (long)length - 1L) / (long)this.stripeSize;
        int firstOffset = (int)fileOffset % this.stripeSize;
        if (firstObj == lastObj) {
            ObjectMapper.ObjectRequest rq = new ObjectMapper.ObjectRequest(firstObj, firstOffset, length, this.getOSDForObject(replica, firstObj), null);
            reqs.add(rq);
            return reqs;
        }
        ObjectMapper.ObjectRequest rq = new ObjectMapper.ObjectRequest(firstObj, firstOffset, this.stripeSize - firstOffset, this.getOSDForObject(replica, firstObj), null);
        reqs.add(rq);
        for (long o = firstObj + 1L; o < lastObj; ++o) {
            rq = new ObjectMapper.ObjectRequest(o, 0, this.stripeSize, this.getOSDForObject(replica, o), null);
            reqs.add(rq);
        }
        int n = lastSize = ((long)length + fileOffset) % (long)this.stripeSize == 0L ? this.stripeSize : (int)((long)length + fileOffset) % this.stripeSize;
        if (lastSize > 0) {
            rq = new ObjectMapper.ObjectRequest(lastObj, 0, lastSize, this.getOSDForObject(replica, lastObj), null);
            reqs.add(rq);
        }
        return reqs;
    }

    @Override
    public List<ObjectMapper.ObjectRequest> writeRequest(ReusableBuffer data, long fileOffset, Replica replica) {
        List<ObjectMapper.ObjectRequest> reqs = this.readRequest(data.remaining(), fileOffset, replica);
        int pCnt = 0;
        for (ObjectMapper.ObjectRequest rq : reqs) {
            ReusableBuffer viewBuf = data.createViewBuffer();
            viewBuf.range(pCnt, rq.getLength());
            pCnt += rq.getLength();
            rq.setData(viewBuf);
        }
        return reqs;
    }

    protected String getOSDForObject(Replica replica, long objNo) {
        return replica.getOSDForObject(objNo).toString();
    }
}

