/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.clients.io;

import org.xtreemfs.common.clients.io.ByteMapper;
import org.xtreemfs.common.clients.io.ObjectStore;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

class ByteMapperRAID0
implements ByteMapper {
    final int stripeSize;
    ObjectStore objectStore;

    public ByteMapperRAID0(int stripeSize, ObjectStore objectStore) {
        this.stripeSize = stripeSize;
        this.objectStore = objectStore;
    }

    @Override
    public int read(byte[] data, int offset, int length, long filePosition) throws Exception {
        if (data.length < offset + length) {
            throw new RuntimeException("buffer is too small!");
        }
        int firstObject = (int)(filePosition / (long)this.stripeSize);
        assert (firstObject >= 0);
        int lastObject = (int)((filePosition + (long)length) / (long)this.stripeSize);
        if ((filePosition + (long)length) % (long)this.stripeSize == 0L) {
            --lastObject;
        }
        assert (lastObject >= firstObject);
        int offsetInFirstObject = (int)(filePosition % (long)this.stripeSize);
        assert (offsetInFirstObject < this.stripeSize);
        int bytesInLastObject = (int)((filePosition + (long)length) % (long)this.stripeSize == 0L ? (long)this.stripeSize : (filePosition + (long)length) % (long)this.stripeSize);
        assert (bytesInLastObject > 0);
        assert (bytesInLastObject <= this.stripeSize);
        int bytesRead = 0;
        for (int obj = firstObject; obj <= lastObject; ++obj) {
            int bytesToRead = this.stripeSize;
            int objOffset = 0;
            if (obj == firstObject) {
                objOffset = offsetInFirstObject;
                bytesToRead = this.stripeSize - objOffset;
            }
            if (obj == lastObject) {
                bytesToRead = firstObject == lastObject ? bytesInLastObject - objOffset : bytesInLastObject;
            }
            assert (bytesToRead > 0);
            assert (objOffset >= 0);
            assert (objOffset < this.stripeSize);
            assert (objOffset + bytesToRead <= this.stripeSize);
            ReusableBuffer rb = this.objectStore.readObject(obj, objOffset, bytesToRead);
            assert (offset + bytesRead <= data.length);
            if (rb == null) break;
            if (rb.capacity() < bytesToRead) {
                int dataToRead = Math.min(rb.capacity(), data.length - offset - bytesRead);
                rb.get(data, offset + bytesRead, dataToRead);
                bytesRead += rb.capacity();
                BufferPool.free(rb);
                break;
            }
            rb.get(data, offset + bytesRead, rb.remaining());
            bytesRead += rb.capacity();
            BufferPool.free(rb);
        }
        return bytesRead;
    }

    @Override
    public int write(byte[] data, int offset, int length, long filePosition) throws Exception {
        int firstObject = (int)(filePosition / (long)this.stripeSize);
        int lastObject = (int)((filePosition + (long)length) / (long)this.stripeSize);
        if ((filePosition + (long)length) % (long)this.stripeSize == 0L) {
            --lastObject;
        }
        int offsetInFirstObject = (int)(filePosition % (long)this.stripeSize);
        int bytesInLastObject = -1;
        if (firstObject == lastObject) {
            bytesInLastObject = length;
        } else if ((filePosition + (long)length) % (long)this.stripeSize == 0L) {
            bytesInLastObject = this.stripeSize;
            assert (bytesInLastObject >= 0);
        } else {
            bytesInLastObject = (int)((filePosition + (long)length) % (long)this.stripeSize);
            assert (bytesInLastObject >= 0);
        }
        int bytesWritten = 0;
        for (int obj = firstObject; obj <= lastObject; ++obj) {
            int bytesToWrite = this.stripeSize;
            int objOffset = 0;
            if (obj == firstObject) {
                bytesToWrite = this.stripeSize - offsetInFirstObject;
                objOffset = offsetInFirstObject;
            }
            if (obj == lastObject) {
                bytesToWrite = bytesInLastObject;
            }
            ReusableBuffer view = ReusableBuffer.wrap(data, offset + bytesWritten, bytesToWrite);
            this.objectStore.writeObject(objOffset, obj, view);
            bytesWritten += bytesToWrite;
        }
        return bytesWritten;
    }
}

