/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public abstract class Config {
    protected final Properties props;

    public Config() {
        this.props = new Properties();
    }

    public Config(Properties prop) {
        this.props = new Properties(prop);
    }

    public Config(String filename) throws IOException {
        this.props = new Properties();
        this.props.load(new FileInputStream(filename));
    }

    protected void write(String filename) throws FileNotFoundException, IOException {
        this.props.store(new FileOutputStream(filename), "");
    }

    protected int readRequiredInt(String paramName) {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            throw new RuntimeException("property '" + paramName + "' is required but was not found");
        }
        try {
            return Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("property '" + paramName + "' is an integer but '" + tmp + "' is not a valid number");
        }
    }

    protected String readRequiredString(String paramName) {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            throw new RuntimeException("property '" + paramName + "' is required but was not found");
        }
        return tmp.trim();
    }

    protected InetSocketAddress readRequiredInetAddr(String hostParam, String portParam) {
        String host = this.readRequiredString(hostParam);
        int port = this.readRequiredInt(portParam);
        InetSocketAddress isa = new InetSocketAddress(host, port);
        return isa;
    }

    protected boolean readRequiredBoolean(String paramName) {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            throw new RuntimeException("property '" + paramName + "' is required but was not found");
        }
        return Boolean.parseBoolean(tmp.trim());
    }

    protected boolean readOptionalBoolean(String paramName, boolean defaultValue) {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(tmp.trim());
    }

    protected int readOptionalInt(String paramName, int defaultValue) {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            return defaultValue;
        }
        return Integer.parseInt(tmp.trim());
    }

    protected InetAddress readOptionalInetAddr(String paramName, InetAddress defaultValue) throws UnknownHostException {
        String tmp = this.props.getProperty(paramName);
        if (tmp == null) {
            return defaultValue;
        }
        return InetAddress.getByName(tmp);
    }

    protected InetSocketAddress readOptionalInetSocketAddr(String hostName, String portParam, InetSocketAddress defaultValue) {
        String host = this.readOptionalString(hostName, null);
        int port = this.readOptionalInt(portParam, -1);
        if (host == null || port == -1) {
            return defaultValue;
        }
        return new InetSocketAddress(host, port);
    }

    protected String readOptionalString(String paramName, String defaultValue) {
        return this.props.getProperty(paramName, defaultValue);
    }

    protected int readOptionalDebugLevel() {
        String level = this.props.getProperty("debug.level");
        if (level == null) {
            return 4;
        }
        if ((level = level.trim().toUpperCase()).equals("EMERG")) {
            return 0;
        }
        if (level.equals("ALERT")) {
            return 1;
        }
        if (level.equals("CRIT")) {
            return 2;
        }
        if (level.equals("ERR")) {
            return 3;
        }
        if (level.equals("WARNING")) {
            return 4;
        }
        if (level.equals("NOTICE")) {
            return 5;
        }
        if (level.equals("INFO")) {
            return 6;
        }
        if (level.equals("DEBUG")) {
            return 7;
        }
        try {
            int levelInt = Integer.valueOf(level);
            return levelInt;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("'" + level + "' is not a valid level name nor an integer");
        }
    }

    public Properties getProps() {
        return this.props;
    }
}

