/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.config;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.FSUtils;
import org.xtreemfs.foundation.util.OutputUtils;

public class PolicyClassLoader
extends ClassLoader {
    private final Map<String, Class> cache = new HashMap<String, Class>();
    private final Map<Class, Map<Long, Class>> policyMap = new HashMap<Class, Map<Long, Class>>();
    private final Class[] policyInterfaces;
    private final Class[] builtInPolicies;
    private File policyDir;
    private File[] jarFiles;

    public PolicyClassLoader(String policyDirPath, String[] policyInterfaceNames, String[] builtInPolicyNames) throws IOException {
        try {
            int i;
            this.policyInterfaces = new Class[policyInterfaceNames.length];
            for (i = 0; i < policyInterfaceNames.length; ++i) {
                this.policyInterfaces[i] = Class.forName(policyInterfaceNames[i]);
            }
            this.builtInPolicies = new Class[builtInPolicyNames.length];
            for (i = 0; i < builtInPolicyNames.length; ++i) {
                this.builtInPolicies[i] = Class.forName(builtInPolicyNames[i]);
            }
        }
        catch (ClassNotFoundException exc) {
            throw new IOException("could not initialize policy class loader:", exc);
        }
        if (policyDirPath != null) {
            this.policyDir = new File(policyDirPath);
        }
    }

    public void init() throws IOException {
        if (this.policyDir != null && this.policyDir.exists()) {
            File[] classFiles;
            this.jarFiles = this.policyDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".jar");
                }
            });
            File[] javaFiles = FSUtils.listRecursively(this.policyDir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".java");
                }
            });
            if (javaFiles.length != 0) {
                String cp = System.getProperty("java.class.path") + ":";
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    cp = cp + this.jarFiles[i];
                    if (i == this.jarFiles.length - 1) continue;
                    cp = cp + ":";
                }
                ArrayList<String> options = new ArrayList<String>(1);
                options.add("-cp");
                options.add(cp);
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                if (compiler == null) {
                    Logging.logMessage(4, Logging.Category.misc, this, "No Java compiler was found to compile additional policies. Make sure that a Java development environment is installed on your system.", new Object[0]);
                } else {
                    Iterable<? extends JavaFileObject> compilationUnits;
                    StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                    if (!compiler.getTask(null, fileManager, null, options, null, compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(javaFiles))).call().booleanValue()) {
                        Logging.logMessage(4, Logging.Category.misc, this, "some policies in '%s' could not be compiled", this.policyDir.getAbsolutePath());
                    }
                    fileManager.close();
                }
            }
            for (File cls : classFiles = FSUtils.listRecursively(this.policyDir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".class");
                }
            })) {
                try {
                    String className = cls.getAbsolutePath().substring(this.policyDir.getAbsolutePath().length() + 1, cls.getAbsolutePath().length() - ".class".length()).replace('/', '.');
                    if (this.cache.containsKey(className)) continue;
                    Class clazz = this.loadFromStream(new FileInputStream(cls));
                    this.checkClass(clazz);
                }
                catch (LinkageError err) {
                }
                catch (Exception exc) {
                    Logging.logMessage(4, Logging.Category.misc, this, "an error occurred while trying to load class from file " + cls, new Object[0]);
                    Logging.logMessage(4, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc), new Object[0]);
                }
            }
        }
        for (Class polClass : this.builtInPolicies) {
            this.checkClass(polClass);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException exc) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "could not find system class '%s', trying to define the class", name);
            }
            if (this.policyDir == null || !this.policyDir.exists()) {
                throw new ClassNotFoundException("no built-in policy '" + name + "' available, and no plug-in policy directory specified");
            }
            try {
                File classFile = new File(this.policyDir.getAbsolutePath() + "/" + name.replace('.', '/') + ".class");
                Class clazz = this.loadFromStream(new FileInputStream(classFile));
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException exc2) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "could not define class '%s', trying to load the class from a plug-in JAR file", name);
                }
            }
            catch (LinkageError err) {
                Logging.logMessage(4, Logging.Category.misc, this, "could not define class '%s'", name);
                Logging.logMessage(4, Logging.Category.misc, this, OutputUtils.stackTraceToString(err), new Object[0]);
            }
            URL[] urls = new URL[this.jarFiles.length];
            try {
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    urls[i] = this.jarFiles[i].toURI().toURL();
                }
            }
            catch (MalformedURLException exc3) {
                Logging.logMessage(3, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc3), new Object[0]);
            }
            return new URLClassLoader(urls){

                @Override
                public URL getResource(String name) {
                    URL resource = super.getResource(name);
                    if (resource != null) {
                        return resource;
                    }
                    return PolicyClassLoader.this.getResource(name);
                }

                @Override
                public InputStream getResourceAsStream(String name) {
                    InputStream stream = super.getResourceAsStream(name);
                    if (stream != null) {
                        return stream;
                    }
                    return PolicyClassLoader.this.getResourceAsStream(name);
                }
            }.loadClass(name);
        }
    }

    public Class<?> loadClass(long id, Class policyInterface) {
        Map<Long, Class> map = this.policyMap.get(policyInterface);
        if (map == null) {
            return null;
        }
        Class clazz = map.get(id);
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL resource = super.getResource(name);
        if (resource != null) {
            return resource;
        }
        File file = new File(this.policyDir.getAbsolutePath() + "/" + name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        File file = new File(this.policyDir.getAbsolutePath() + "/" + name);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    private Class loadFromStream(InputStream in) throws IOException {
        byte[] classData = new byte[in.available()];
        in.read(classData);
        in.close();
        Class<?> clazz = this.defineClass(null, classData, 0, classData.length);
        this.cache.put(clazz.getName(), clazz);
        return clazz;
    }

    private void checkClass(Class clazz) {
        for (Class ifc : this.policyInterfaces) {
            if (!ifc.isAssignableFrom(clazz)) continue;
            try {
                long policyId = clazz.getDeclaredField("POLICY_ID").getLong(null);
                Map<Long, Class> polIdMap = this.policyMap.get(ifc);
                if (polIdMap == null) {
                    polIdMap = new HashMap<Long, Class>();
                    this.policyMap.put(ifc, polIdMap);
                }
                if (polIdMap.containsKey(policyId)) {
                    Logging.logMessage(4, Logging.Category.misc, this, "duplicate ID for policy '%s': %d", ifc.getName(), policyId);
                }
                polIdMap.put(policyId, clazz);
            }
            catch (Exception exc) {
                Logging.logMessage(4, this, "could not load malformed policy '%s'", clazz.getName());
                Logging.logMessage(4, this, OutputUtils.stackTraceToString(exc), new Object[0]);
            }
        }
    }
}

