/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.config;

import java.io.IOException;
import org.xtreemfs.common.config.PolicyClassLoader;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.logging.Logging;

public class PolicyContainer {
    protected final ServiceConfig config;
    protected final PolicyClassLoader policyClassLoader;

    public PolicyContainer(ServiceConfig config) throws IOException {
        this.config = config;
        this.policyClassLoader = new PolicyClassLoader(config.getPolicyDir(), new String[0], new String[0]);
        this.policyClassLoader.init();
    }

    protected PolicyContainer(ServiceConfig config, PolicyClassLoader policyClassLoader) throws IOException {
        this.config = config;
        this.policyClassLoader = policyClassLoader;
        policyClassLoader.init();
    }

    public SSLOptions.TrustManager getTrustManager() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String trustManager = this.config.getTrustManager();
        if (trustManager == null || trustManager.equals("")) {
            return null;
        }
        try {
            return (SSLOptions.TrustManager)Class.forName(trustManager).newInstance();
        }
        catch (Exception exc) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "no built-in policy '%s' exists, searching for plug-in policies...", this.config.getTrustManager());
            }
            Class<?> cls = this.policyClassLoader.loadClass(trustManager);
            return (SSLOptions.TrustManager)cls.newInstance();
        }
    }
}

