/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.config;

import java.io.FileInputStream;
import java.util.HashMap;
import org.xtreemfs.common.config.PolicyContainer;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RemoteConfigHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceConfig getConfigurationFromDIR(ServiceConfig config) throws Exception {
        TimeSync ts = null;
        boolean timeSyncAlreadyRunning = true;
        try {
            int WAIT_BETWEEN_RETRIES = 1000;
            int retries = config.getWaitForDIR() * 1000 / 1000;
            if (retries <= 0) {
                retries = 1;
            }
            Logging.logMessage(6, null, "Loading configuration from DIR (will retry up to %d times)", retries);
            SSLOptions sslOptions = config.isUsingSSL() ? new SSLOptions(new FileInputStream(config.getServiceCredsFile()), config.getServiceCredsPassphrase(), config.getServiceCredsContainer(), new FileInputStream(config.getTrustedCertsFile()), config.getTrustedCertsPassphrase(), config.getTrustedCertsContainer(), false, config.isGRIDSSLmode(), config.getSSLProtocolString(), new PolicyContainer(config).getTrustManager()) : null;
            RPCNIOSocketClient clientStage = new RPCNIOSocketClient(sslOptions, 1000, 60000, "RemoteConfigHelper");
            DIRServiceClient dirRPCClient = new DIRServiceClient(clientStage, config.getDirectoryService());
            DIRClient dirClient = new DIRClient(dirRPCClient, config.getDirectoryServices(), retries, 1000);
            clientStage.start();
            clientStage.waitForStartup();
            timeSyncAlreadyRunning = TimeSync.isInitialized();
            if (!timeSyncAlreadyRunning) {
                ts = TimeSync.initializeLocal(0);
                ts.waitForStartup();
            }
            RPC.Auth authNone = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build();
            RPC.UserCredentials uc = RPC.UserCredentials.newBuilder().setUsername("main-method").addGroups("xtreemfs-services").build();
            DIR.Configuration conf = dirClient.xtreemfs_configuration_get(null, authNone, uc, config.getUUID().toString());
            clientStage.shutdown();
            clientStage.waitForShutdown();
            HashMap<String, String> returnMap = new HashMap<String, String>();
            for (GlobalTypes.KeyValuePair kvp : conf.getParameterList()) {
                returnMap.put(kvp.getKey(), kvp.getValue());
            }
            ServiceConfig serviceConfig = new ServiceConfig(returnMap);
            return serviceConfig;
        }
        finally {
            if (!timeSyncAlreadyRunning && ts != null) {
                ts.close();
            }
        }
    }
}

