/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.config;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xtreemfs.common.config.Config;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;

public class ServiceConfig
extends Config {
    private static final Logging.Category[] debugCategoryDefault = new Logging.Category[]{Logging.Category.all};
    private final Parameter[] connectionParameter = new Parameter[]{Parameter.DEBUG_CATEGORIES, Parameter.DEBUG_LEVEL, Parameter.HOSTNAME, Parameter.DIRECTORY_SERVICE, Parameter.WAIT_FOR_DIR, Parameter.PORT, Parameter.USE_SSL, Parameter.UUID};
    protected EnumMap<Parameter, Object> parameter = new EnumMap(Parameter.class);
    public static final String OSD_CUSTOM_PROPERTY_PREFIX = "config.";

    public Boolean isInitializable() {
        for (Parameter param : this.connectionParameter) {
            if (this.parameter.get((Object)param) != null) continue;
            throw new RuntimeException("property '" + param.getPropertyString() + "' is required but was not found");
        }
        this.checkSSLConfiguration();
        return true;
    }

    public Parameter[] getConnectionParameter() {
        return this.connectionParameter;
    }

    public void readParameters(Parameter[] params) throws IOException {
        for (Parameter param : params) {
            this.parameter.put(param, this.readParameter(param));
        }
        this.setDefaults(params);
    }

    public ServiceConfig() {
    }

    public ServiceConfig(Properties prop) {
        super(prop);
    }

    public ServiceConfig(String filename) throws IOException {
        super(filename);
    }

    public ServiceConfig(HashMap<String, String> hm) {
        for (Map.Entry<String, String> entry : hm.entrySet()) {
            if (entry.getKey().startsWith(OSD_CUSTOM_PROPERTY_PREFIX)) continue;
            Parameter param = null;
            try {
                param = Parameter.getParameterFromString(entry.getKey());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (Integer.class == param.getPropertyClass()) {
                this.parameter.put(param, (Object)Integer.parseInt(entry.getValue()));
            }
            if (Long.class == param.getPropertyClass()) {
                this.parameter.put(param, (Object)Long.parseLong(entry.getValue()));
            }
            if (String.class == param.getPropertyClass()) {
                this.parameter.put(param, (Object)entry.getValue());
            }
            if (Boolean.class == param.getPropertyClass()) {
                this.parameter.put(param, (Object)Boolean.valueOf(entry.getValue()));
            }
            if (ServiceUUID.class == param.getPropertyClass()) {
                this.parameter.put(param, (Object)new ServiceUUID(entry.getValue()));
            }
            if (InetAddress.class == param.getPropertyClass()) {
                InetAddress inetAddr = null;
                try {
                    inetAddr = InetAddress.getByName(entry.getValue().substring(entry.getValue().indexOf(47) + 1));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                this.parameter.put(param, inetAddr);
            }
            if (InetSocketAddress.class == param.getPropertyClass()) {
                String host = entry.getValue().substring(0, entry.getValue().indexOf("/"));
                String port = entry.getValue().substring(entry.getValue().lastIndexOf(":") + 1);
                InetSocketAddress isa = new InetSocketAddress(host, Integer.parseInt(port));
                this.parameter.put(param, (Object)isa);
            }
            if (Logging.Category[].class != param.getPropertyClass()) continue;
            StringTokenizer stk = new StringTokenizer(entry.getValue(), ", ");
            Logging.Category[] catArray = new Logging.Category[stk.countTokens()];
            int count = 0;
            while (stk.hasMoreElements()) {
                catArray[count] = Logging.Category.valueOf(stk.nextToken());
                ++count;
            }
            this.parameter.put(param, (Object)catArray);
        }
    }

    public void mergeConfig(ServiceConfig conf) {
        for (Map.Entry<Parameter, Object> entry : conf.parameter.entrySet()) {
            if (!entry.getKey().isRequired().booleanValue() || this.parameter.get((Object)entry.getKey()) != null) continue;
            this.parameter.put((Parameter)((Enum)entry.getKey()), entry.getValue());
        }
    }

    public void setDefaults(Parameter param) {
        if (this.parameter.get((Object)param) == null) {
            this.parameter.put(param, param.getDefaultValue());
        }
    }

    public void setDefaults(Parameter[] p) {
        for (Parameter parm : p) {
            if (!parm.isOptional().booleanValue() || this.parameter.get((Object)parm) != null) continue;
            this.parameter.put(parm, parm.getDefaultValue());
        }
    }

    protected int readDebugLevel() {
        String level = this.props.getProperty("debug.level");
        if (level == null) {
            return 6;
        }
        if ((level = level.trim().toUpperCase()).equals("EMERG")) {
            return 0;
        }
        if (level.equals("ALERT")) {
            return 1;
        }
        if (level.equals("CRIT")) {
            return 2;
        }
        if (level.equals("ERR")) {
            return 3;
        }
        if (level.equals("WARNING")) {
            return 4;
        }
        if (level.equals("NOTICE")) {
            return 5;
        }
        if (level.equals("INFO")) {
            return 6;
        }
        if (level.equals("DEBUG")) {
            return 7;
        }
        try {
            int levelInt = Integer.valueOf(level);
            return levelInt;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("'" + level + "' is not a valid level name nor an integer");
        }
    }

    protected Object readParameter(Parameter param) {
        String tmpString = this.props.getProperty(param.getPropertyString());
        if (tmpString == null) {
            return null;
        }
        if (Integer.class == param.getPropertyClass()) {
            return Integer.parseInt(tmpString.trim());
        }
        if (Long.class == param.getPropertyClass()) {
            return Long.parseLong(tmpString.trim());
        }
        if (Boolean.class == param.getPropertyClass()) {
            return Boolean.parseBoolean(tmpString.trim());
        }
        if (String.class == param.getPropertyClass()) {
            return tmpString.trim();
        }
        if (ServiceUUID.class == param.getPropertyClass()) {
            return new ServiceUUID(tmpString);
        }
        if (InetAddress.class == param.getPropertyClass()) {
            InetAddress iAddr = null;
            try {
                iAddr = InetAddress.getByName(tmpString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return iAddr;
        }
        if (InetSocketAddress.class == param.getPropertyClass()) {
            return this.readRequiredInetAddr(param.getPropertyString(), param.getPropertyString().replaceAll("host", "port"));
        }
        if (Logging.Category[].class == param.getPropertyClass()) {
            return this.readCategories(param.getPropertyString());
        }
        return null;
    }

    protected Logging.Category[] readCategories(String property) {
        String tmp = this.readOptionalString(property, "");
        StringTokenizer st = new StringTokenizer(tmp, " \t,");
        LinkedList<Logging.Category> cats = new LinkedList<Logging.Category>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                cats.add(Logging.Category.valueOf(token));
            }
            catch (IllegalArgumentException exc) {
                System.err.println("invalid logging category: " + token);
            }
        }
        if (cats.size() == 0) {
            cats.add(Logging.Category.all);
        }
        return cats.toArray(new Logging.Category[cats.size()]);
    }

    public HashMap<String, String> toHashMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (Parameter param : Parameter.values()) {
            if (this.parameter.get((Object)param) == null) continue;
            if (Logging.Category[].class == param.getPropertyClass()) {
                Logging.Category[] debugCategories = (Logging.Category[])this.parameter.get((Object)param);
                String putString = "";
                boolean firstValue = true;
                for (Logging.Category cat : debugCategories) {
                    if (firstValue) {
                        putString = putString + cat.toString();
                        firstValue = false;
                        continue;
                    }
                    putString = putString + ", " + cat.toString();
                }
                hm.put(param.getPropertyString(), putString);
                continue;
            }
            hm.put(param.getPropertyString(), this.parameter.get((Object)param).toString());
        }
        return hm;
    }

    public int getDebugLevel() {
        return (Integer)this.parameter.get((Object)Parameter.DEBUG_LEVEL);
    }

    public Logging.Category[] getDebugCategories() {
        return (Logging.Category[])this.parameter.get((Object)Parameter.DEBUG_CATEGORIES);
    }

    public int getPort() {
        return (Integer)this.parameter.get((Object)Parameter.PORT);
    }

    public int getHttpPort() {
        return (Integer)this.parameter.get((Object)Parameter.HTTP_PORT);
    }

    public InetAddress getAddress() {
        return (InetAddress)this.parameter.get((Object)Parameter.LISTEN_ADDRESS);
    }

    public boolean isUsingSSL() {
        return (Boolean)this.parameter.get((Object)Parameter.USE_SSL);
    }

    public String getServiceCredsContainer() {
        return (String)this.parameter.get((Object)Parameter.SERVICE_CREDS_CONTAINER);
    }

    public String getServiceCredsFile() {
        return (String)this.parameter.get((Object)Parameter.SERVICE_CREDS_FILE);
    }

    public String getServiceCredsPassphrase() {
        return (String)this.parameter.get((Object)Parameter.SERVICE_CREDS_PASSPHRASE);
    }

    public String getTrustedCertsContainer() {
        return (String)this.parameter.get((Object)Parameter.TRUSTED_CERTS_CONTAINER);
    }

    public String getTrustedCertsFile() {
        return (String)this.parameter.get((Object)Parameter.TRUSTED_CERTS_FILE);
    }

    public String getTrustedCertsPassphrase() {
        return (String)this.parameter.get((Object)Parameter.TRUSTED_CERTS_PASSPHRASE);
    }

    public String getTrustManager() {
        return (String)this.parameter.get((Object)Parameter.TRUST_MANAGER);
    }

    public String getGeoCoordinates() {
        return (String)this.parameter.get((Object)Parameter.GEO_COORDINATES);
    }

    public void setGeoCoordinates(String geoCoordinates) {
        this.parameter.put(Parameter.GEO_COORDINATES, (Object)geoCoordinates);
    }

    public String getAdminPassword() {
        return (String)this.parameter.get((Object)Parameter.ADMIN_PASSWORD);
    }

    public String getHostName() {
        return (String)this.parameter.get((Object)Parameter.HOSTNAME);
    }

    public ServiceUUID getUUID() {
        return (ServiceUUID)this.parameter.get((Object)Parameter.UUID);
    }

    public boolean isGRIDSSLmode() {
        return this.parameter.get((Object)Parameter.USE_GRID_SSL_MODE) != null && (Boolean)this.parameter.get((Object)Parameter.USE_GRID_SSL_MODE) != false;
    }

    public String getSSLProtocolString() {
        return (String)this.parameter.get((Object)Parameter.SSL_PROTOCOL_STRING);
    }

    public int getWaitForDIR() {
        return (Integer)this.parameter.get((Object)Parameter.WAIT_FOR_DIR);
    }

    public String getURLScheme() {
        if (this.isUsingSSL()) {
            if (this.isGRIDSSLmode()) {
                return "pbrpcg";
            }
            return "pbrpcs";
        }
        return "pbrpc";
    }

    public String getPolicyDir() {
        return (String)this.parameter.get((Object)Parameter.POLICY_DIR);
    }

    public Boolean isUsingSnmp() {
        return (Boolean)this.parameter.get((Object)Parameter.USE_SNMP);
    }

    public InetAddress getSnmpAddress() {
        return (InetAddress)this.parameter.get((Object)Parameter.SNMP_ADDRESS);
    }

    public Integer getSnmpPort() {
        return (Integer)this.parameter.get((Object)Parameter.SNMP_PORT);
    }

    public String getSnmpACLFile() {
        return (String)this.parameter.get((Object)Parameter.SNMP_ACL);
    }

    public Integer getFailoverMaxRetries() {
        return (Integer)this.parameter.get((Object)Parameter.FAILOVER_MAX_RETRIES);
    }

    public Integer getFailoverWait() {
        return (Integer)this.parameter.get((Object)Parameter.FAILOVER_WAIT);
    }

    public InetSocketAddress getDirectoryService() {
        return (InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE);
    }

    public InetSocketAddress[] getDirectoryServices() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE));
        if (this.parameter.get((Object)Parameter.DIRECTORY_SERVICE0) != null) {
            addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE0));
        }
        if (this.parameter.get((Object)Parameter.DIRECTORY_SERVICE1) != null) {
            addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE1));
        }
        if (this.parameter.get((Object)Parameter.DIRECTORY_SERVICE2) != null) {
            addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE2));
        }
        if (this.parameter.get((Object)Parameter.DIRECTORY_SERVICE3) != null) {
            addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE3));
        }
        if (this.parameter.get((Object)Parameter.DIRECTORY_SERVICE4) != null) {
            addresses.add((InetSocketAddress)this.parameter.get((Object)Parameter.DIRECTORY_SERVICE4));
        }
        return addresses.toArray(new InetSocketAddress[0]);
    }

    public void setDirectoryService(InetSocketAddress addr) {
        this.parameter.put(Parameter.DIRECTORY_SERVICE, (Object)addr);
    }

    public void checkSSLConfiguration() {
        Parameter[] sslRelatedParameter = new Parameter[]{Parameter.SERVICE_CREDS_CONTAINER, Parameter.SERVICE_CREDS_FILE, Parameter.SERVICE_CREDS_PASSPHRASE, Parameter.TRUSTED_CERTS_CONTAINER, Parameter.TRUSTED_CERTS_FILE, Parameter.TRUSTED_CERTS_PASSPHRASE};
        if (this.isUsingSSL()) {
            for (Parameter param : sslRelatedParameter) {
                if (this.parameter.get((Object)param) != null) continue;
                throw new RuntimeException("for SSL " + param.getPropertyString() + " must be set!");
            }
        } else if (this.parameter.get((Object)Parameter.USE_GRID_SSL_MODE) != null && this.isGRIDSSLmode()) {
            throw new RuntimeException("ssl must be enabled to use the grid_ssl mode. Please make sure to set ssl.enabled = true and to configure all SSL options.");
        }
    }

    protected void checkMultihomingConfiguration() {
        if (this.isUsingMultihoming() && this.getAddress() != null) {
            throw new RuntimeException(Parameter.USE_MULTIHOMING.getPropertyString() + " and " + Parameter.LISTEN_ADDRESS.getPropertyString() + " parameters are incompatible.");
        }
    }

    protected void checkConfig(Parameter[] params) {
        for (Parameter param : params) {
            if (!param.isRequired().booleanValue() || this.parameter.get((Object)param) != null) continue;
            throw new RuntimeException("property '" + param.getPropertyString() + "' is required but was not found");
        }
        this.checkSSLConfiguration();
    }

    public boolean isUsingRenewalSignal() {
        return (Boolean)this.parameter.get((Object)Parameter.USE_RENEWAL_SIGNAL);
    }

    public boolean isUsingMultihoming() {
        return (Boolean)this.parameter.get((Object)Parameter.USE_MULTIHOMING);
    }

    static /* synthetic */ Logging.Category[] access$000() {
        return debugCategoryDefault;
    }

    public static enum Parameter {
        DEBUG_LEVEL("debug.level", 6, Integer.class, false),
        DEBUG_CATEGORIES("debug.categories", ServiceConfig.access$000(), Logging.Category[].class, false),
        DIRECTORY_SERVICE("dir_service.host", null, InetSocketAddress.class, true),
        DIRECTORY_SERVICE0("dir_service.0.host", null, InetSocketAddress.class, false),
        DIRECTORY_SERVICE1("dir_service.1.host", null, InetSocketAddress.class, false),
        DIRECTORY_SERVICE2("dir_service.2.host", null, InetSocketAddress.class, false),
        DIRECTORY_SERVICE3("dir_service.3.host", null, InetSocketAddress.class, false),
        DIRECTORY_SERVICE4("dir_service.4.host", null, InetSocketAddress.class, false),
        PORT("listen.port", null, Integer.class, true),
        HTTP_PORT("http_port", null, Integer.class, true),
        LISTEN_ADDRESS("listen.address", null, InetAddress.class, false),
        USE_SSL("ssl.enabled", false, Boolean.class, false),
        SSL_PROTOCOL_STRING("ssl.protocol", null, String.class, false),
        SERVICE_CREDS_FILE("ssl.service_creds", null, String.class, false),
        SERVICE_CREDS_PASSPHRASE("ssl.service_creds.pw", null, String.class, false),
        SERVICE_CREDS_CONTAINER("ssl.service_creds.container", null, String.class, false),
        TRUSTED_CERTS_FILE("ssl.trusted_certs", null, String.class, false),
        TRUSTED_CERTS_CONTAINER("ssl.trusted_certs.container", null, String.class, false),
        TRUSTED_CERTS_PASSPHRASE("ssl.trusted_certs.pw", null, String.class, false),
        TRUST_MANAGER("ssl.trust_manager", "", String.class, false),
        GEO_COORDINATES("geographic_coordinates", "", String.class, false),
        ADMIN_PASSWORD("admin_password", "", String.class, false),
        HOSTNAME("hostname", "", String.class, false),
        USE_GRID_SSL_MODE("ssl.grid_ssl", false, Boolean.class, false),
        WAIT_FOR_DIR("startup.wait_for_dir", 30, Integer.class, false),
        POLICY_DIR("policy_dir", "/etc/xos/xtreemfs/policies/", String.class, false),
        USE_SNMP("snmp.enabled", false, Boolean.class, false),
        SNMP_ADDRESS("snmp.address", null, InetAddress.class, false),
        SNMP_PORT("snmp.port", null, Integer.class, false),
        SNMP_ACL("snmp.aclfile", null, String.class, false),
        FAILOVER_MAX_RETRIES("failover.retries", 15, Integer.class, false),
        FAILOVER_WAIT("failover.wait_ms", 15000, Integer.class, false),
        MAX_CLIENT_Q("max_client_queue", 100, Integer.class, false),
        MAX_REQUEST_QUEUE_LENGTH("max_requests_queue_length", 1000, Integer.class, false),
        USE_MULTIHOMING("multihoming.enabled", false, Boolean.class, false),
        USE_RENEWAL_SIGNAL("multihoming.renewal_signal", false, Boolean.class, false),
        AUTODISCOVER_ENABLED("discover", true, Boolean.class, false),
        MONITORING_ENABLED("monitoring.enabled", false, Boolean.class, false),
        ADMIN_EMAIL("monitoring.email.receiver", "", String.class, false),
        SENDER_ADDRESS("monitoring.email.sender", "XtreemFS DIR monitoring <dir@localhost>", String.class, false),
        MAX_WARNINGS("monitoring.max_warnings", 1, Integer.class, false),
        SENDMAIL_BIN("monitoring.email.programm", "/usr/sbin/sendmail", String.class, false),
        TIMEOUT_SECONDS("monitoring.service_timeout_s", 300, Integer.class, false),
        VIVALDI_MAX_CLIENTS("vivaldi.max_clients", 32, Integer.class, false),
        VIVALDI_CLIENT_TIMEOUT("vivaldi.client_timeout", 600000, Integer.class, false),
        UUID("uuid", null, ServiceUUID.class, true),
        LOCAL_CLOCK_RENEW("local_clock_renewal", null, Integer.class, true),
        REMOTE_TIME_SYNC("remote_time_sync", null, Integer.class, true),
        OSD_CHECK_INTERVAL("osd_check_interval", null, Integer.class, true),
        NOATIME("no_atime", null, Boolean.class, true),
        AUTHENTICATION_PROVIDER("authentication_provider", null, String.class, true),
        CAPABILITY_SECRET("capability_secret", null, String.class, true),
        CAPABILITY_TIMEOUT("capability_timeout", 600, Integer.class, false),
        RENEW_TIMED_OUT_CAPS("renew_to_caps", false, Boolean.class, false),
        OBJECT_DIR("object_dir", null, String.class, true),
        REPORT_FREE_SPACE("report_free_space", null, Boolean.class, true),
        CHECKSUM_ENABLED("checksums.enabled", false, Boolean.class, false),
        CHECKSUM_PROVIDER("checksums.algorithm", null, String.class, false),
        STORAGE_LAYOUT("storage_layout", "HashStorageLayout", String.class, false),
        IGNORE_CAPABILITIES("ignore_capabilities", false, Boolean.class, false),
        FLEASE_DMAX_MS("flease.dmax_ms", 1000, Integer.class, false),
        FLEASE_LEASE_TIMEOUT_MS("flease.lease_timeout_ms", 14000, Integer.class, false),
        FLEASE_MESSAGE_TO_MS("flease.message_to_ms", 500, Integer.class, false),
        FLEASE_RETRIES("flease.retries", 3, Integer.class, false),
        SOCKET_SEND_BUFFER_SIZE("socket.send_buffer_size", -1, Integer.class, false),
        SOCKET_RECEIVE_BUFFER_SIZE("socket.recv_buffer_size", -1, Integer.class, false),
        VIVALDI_RECALCULATION_INTERVAL_IN_MS("vivaldi.recalculation_interval_ms", 300000, Integer.class, false),
        VIVALDI_RECALCULATION_EPSILON_IN_MS("vivaldi.recalculation_epsilon_ms", 30000, Integer.class, false),
        VIVALDI_ITERATIONS_BEFORE_UPDATING("vivaldi.iterations_before_updating", 12, Integer.class, false),
        VIVALDI_MAX_RETRIES_FOR_A_REQUEST("vivaldi.max_retries_for_a_request", 2, Integer.class, false),
        VIVALDI_MAX_REQUEST_TIMEOUT_IN_MS("vivaldi.max_request_timeout_ms", 10000, Integer.class, false),
        VIVALDI_TIMER_INTERVAL_IN_MS("vivaldi.timer_interval_ms", 60000, Integer.class, false),
        STORAGE_THREADS("storage_threads", 1, Integer.class, false),
        HEALTH_CHECK("health_check", "", String.class, false),
        BASEFILE_SIZE_IN_BYTES("basefilesize_in_bytes", 0xC0000000L, Long.class, false),
        FILESIZE("filesize", 4096, Integer.class, false),
        USERNAME("username", "benchmark", String.class, false),
        GROUP("group", "benchmark", String.class, false),
        OSD_SELECTION_POLICIES("osd_selection_policies", "", String.class, false),
        REPLICATION_POLICY("replication_policy", "", String.class, false),
        REPLICATION_FACTOR("replication_factor", 3, Integer.class, false),
        CHUNK_SIZE_IN_BYTES("chunk_size_in_bytes", 131072, Integer.class, false),
        STRIPE_SIZE_IN_BYTES("stripe_size_in_bytes", 131072, Integer.class, false),
        STRIPE_SIZE_SET("stripe_size_set", false, Boolean.class, false),
        STRIPE_WIDTH("stripe_width", 1, Integer.class, false),
        STRIPE_WIDTH_SET("stripe_width_set", false, Boolean.class, false),
        NO_CLEANUP("no_cleanup", false, Boolean.class, false),
        NO_CLEANUP_VOLUMES("no_cleanup_volumes", false, Boolean.class, false),
        NO_CLEANUP_BASEFILE("no_cleanup_basefile", false, Boolean.class, false),
        OSD_CLEANUP("osd_cleanup", false, Boolean.class, false);

        private static final int size;
        private final String propertyString;
        private final Class propertyClass;
        private final Object defaultValue;
        private final Boolean required;

        private Parameter(String propString, Object defaultValue, Class propClass, Boolean req) {
            this.propertyString = propString;
            this.defaultValue = defaultValue;
            this.propertyClass = propClass;
            this.required = req;
        }

        public String getPropertyString() {
            return this.propertyString;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Class getPropertyClass() {
            return this.propertyClass;
        }

        public static int getSize() {
            return size;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public Boolean isOptional() {
            return this.required == false;
        }

        public static Parameter getParameterFromString(String s) throws RuntimeException {
            for (Parameter parm : Parameter.values()) {
                if (!s.equals(parm.getPropertyString())) continue;
                return parm;
            }
            throw new RuntimeException("Configuration parameter " + s + " doesn't exist!");
        }

        static {
            size = Parameter.values().length;
        }
    }
}

