/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.common.libxtreemfs.AsyncWriteBuffer;
import org.xtreemfs.common.libxtreemfs.FileInfo;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.UUIDResolver;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.UUIDIteratorListIsEmpyException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class AsyncWriteHandler {
    private State state;
    private List<AsyncWriteBuffer> writesInFlight;
    private int pendingBytes;
    private boolean writingPaused;
    private Object allPendingWritesDidComplete;
    private int waitingBlockingThreadsCount;
    private FileInfo fileInfo;
    private UUIDIterator uuidIterator;
    private UUIDResolver uuidResolver;
    OSDServiceClient osdServiceClient;
    private RPC.Auth authBogus;
    private RPC.UserCredentials userCredentialsBogus;
    private int maxWriteahead;
    private int maxWriteaheadRequests;
    private int maxWriteTries;

    protected AsyncWriteHandler(FileInfo fileInfo, UUIDIterator uuidIterator, UUIDResolver uuidResolver, OSDServiceClient osdServiceClient, RPC.Auth authBogus, RPC.UserCredentials userCredentialsBogus, int maxWriteahead, int maxWriteaheadRequests, int maxWriteTries) {
        this.fileInfo = fileInfo;
        this.uuidIterator = uuidIterator;
        this.uuidResolver = uuidResolver;
        this.osdServiceClient = osdServiceClient;
        this.authBogus = authBogus;
        this.userCredentialsBogus = userCredentialsBogus;
        this.maxWriteahead = maxWriteahead;
        this.maxWriteaheadRequests = maxWriteaheadRequests;
        this.maxWriteTries = maxWriteTries;
        this.writesInFlight = new ArrayList<AsyncWriteBuffer>();
        this.allPendingWritesDidComplete = new Object();
        this.state = State.IDLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(AsyncWriteBuffer writeBuffer) throws AddressToUUIDNotFoundException, XtreemFSException {
        assert (writeBuffer != null);
        if (writeBuffer.getDataLength() > this.maxWriteahead) {
            throw new XtreemFSException("The maximum allowed writeahead size: " + this.maxWriteahead + " is smaller than the size of this write request: " + writeBuffer.getDataLength());
        }
        AsyncWriteHandler asyncWriteHandler = this;
        synchronized (asyncWriteHandler) {
            while (this.writingPaused || this.pendingBytes + writeBuffer.getDataLength() > this.maxWriteahead || this.writesInFlight.size() == this.maxWriteaheadRequests) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.increasePendingBytesHelper(writeBuffer);
        }
        String osdUuid = this.retrieveOSDUuidAndSetItInWriteBuffer(writeBuffer);
        String osdAddress = this.uuidResolver.uuidToAddress(osdUuid);
        InetSocketAddress osdInetSocketAddress = Helper.stringToInetSocketAddress(osdAddress, GlobalTypes.PORTS.OSD_PBRPC_PORT_DEFAULT.getNumber());
        final AsyncWriteBuffer finalWriteBufferForCallback = writeBuffer;
        try {
            RPCResponse<GlobalTypes.OSDWriteResponse> response = this.osdServiceClient.write(osdInetSocketAddress, this.authBogus, this.userCredentialsBogus, writeBuffer.getWriteRequest(), writeBuffer.getData());
            response.registerListener(new RPCResponseAvailableListener<GlobalTypes.OSDWriteResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void responseAvailable(RPCResponse<GlobalTypes.OSDWriteResponse> r) {
                    try {
                        GlobalTypes.OSDWriteResponse osdWriteResponse = r.get();
                        AsyncWriteHandler.this.writeFinished(osdWriteResponse, r.getData(), finalWriteBufferForCallback);
                    }
                    catch (PBRPCException e) {
                        String errorTypeName = e.getErrorType().toString();
                        Descriptors.EnumValueDescriptor enumDescriptor = RPC.ErrorType.getDescriptor().findValueByNumber(e.getErrorType().getNumber());
                        if (enumDescriptor != null) {
                            errorTypeName = enumDescriptor.getName();
                        }
                        Logging.logMessage(3, Logging.Category.misc, this, "An async write sent to the server %s failed. Error type:  %s Error message: %s Complete error header: %s", finalWriteBufferForCallback.getOsdUuid(), errorTypeName, e.getErrorMessage(), e.getDebugInfo());
                        System.out.println("CLASSNAME: " + this.toString());
                        AsyncWriteHandler.this.decreasePendingBytesHelper(finalWriteBufferForCallback);
                    }
                    catch (Exception e) {
                        Logging.logMessage(3, Logging.Category.misc, this, "asyncWrite: failed due to the following reasons ", e.getMessage());
                        AsyncWriteHandler.this.decreasePendingBytesHelper(finalWriteBufferForCallback);
                    }
                    finally {
                        r.freeBuffers();
                    }
                }
            });
        }
        catch (IOException e1) {
            Logging.logMessage(3, Logging.Category.misc, this, "asyncWrite: failed due to the following reasons ", e1.getMessage());
            this.decreasePendingBytesHelper(finalWriteBufferForCallback);
        }
    }

    private String retrieveOSDUuidAndSetItInWriteBuffer(AsyncWriteBuffer writeBuffer) throws UUIDIteratorListIsEmpyException {
        String osdUuid;
        if (writeBuffer.isUsingUuidIterator()) {
            osdUuid = this.uuidIterator.getUUID();
            writeBuffer.setOsdUuid(osdUuid);
        } else {
            osdUuid = writeBuffer.getOsdUuid();
        }
        return osdUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForPendingWrites() {
        Object object = this;
        synchronized (object) {
            if (this.state != State.IDLE) {
                this.writingPaused = false;
                ++this.waitingBlockingThreadsCount;
            } else {
                return;
            }
        }
        while (this.state != State.IDLE) {
            object = this.allPendingWritesDidComplete;
            synchronized (object) {
                try {
                    this.allPendingWritesDidComplete.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        object = this;
        synchronized (object) {
            --this.waitingBlockingThreadsCount;
        }
    }

    private void writeFinished(GlobalTypes.OSDWriteResponse response, ReusableBuffer data, AsyncWriteBuffer writeBuffer) {
        if (response.hasSizeInBytes()) {
            GlobalTypes.XCap xcap = writeBuffer.getFileHandle().getXcap();
            this.fileInfo.tryToUpdateOSDWriteResponse(response, xcap);
        }
        this.decreasePendingBytesHelper(writeBuffer);
    }

    protected void increasePendingBytesHelper(AsyncWriteBuffer writeBuffer) {
        assert (writeBuffer != null);
        this.pendingBytes += writeBuffer.getDataLength();
        this.writesInFlight.add(writeBuffer);
        assert (this.writesInFlight.size() <= this.maxWriteaheadRequests);
        this.state = State.WRITES_PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decreasePendingBytesHelper(AsyncWriteBuffer writeBuffer) {
        assert (writeBuffer != null);
        this.writesInFlight.remove(writeBuffer);
        this.pendingBytes -= writeBuffer.getDataLength();
        if (this.pendingBytes == 0) {
            this.state = State.IDLE;
            if (this.writingPaused) {
                this.writingPaused = false;
            }
            if (this.waitingBlockingThreadsCount > 0) {
                Object object = this.allPendingWritesDidComplete;
                synchronized (object) {
                    this.allPendingWritesDidComplete.notifyAll();
                }
            }
        }
        this.notifyAll();
    }

    private static enum State {
        IDLE,
        WRITES_PENDING;

    }
}

