/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.AdminVolume;
import org.xtreemfs.common.libxtreemfs.Client;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.RPCCaller;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.UUIDResolver;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.common.libxtreemfs.VolumeImplementation;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.VolumeNotFoundException;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class ClientImplementation
implements UUIDResolver,
Client,
AdminClient {
    private UUIDIterator dirServiceAddresses = null;
    private RPC.Auth authBogus = null;
    private RPC.Auth dirServiceAuth;
    private RPC.UserCredentials dirServiceUserCredentials = null;
    private SSLOptions dirServiceSSLOptions = null;
    private Options options = null;
    private ConcurrentLinkedQueue<Volume> listOpenVolumes = null;
    private org.xtreemfs.common.uuids.UUIDResolver uuidResolver = null;
    private DIRServiceClient dirServiceClient = null;
    private OSDServiceClient osdServiceClient = null;
    private RPCNIOSocketClient networkClient = null;
    private String clientUUID = null;
    private String[] dirAddresses = null;
    private boolean startThreadsAsDaemons = false;

    protected ClientImplementation(String[] dirAddresses, RPC.UserCredentials userCredentials, SSLOptions sslOptions, Options options) {
        this.dirServiceUserCredentials = userCredentials;
        this.dirServiceSSLOptions = sslOptions;
        this.options = options;
        this.dirAddresses = dirAddresses;
        this.dirServiceAddresses = new UUIDIterator();
        for (String address : dirAddresses) {
            this.dirServiceAddresses.addUUID(address);
        }
        this.authBogus = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build();
        this.dirServiceAuth = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "Created a new libxtreemfs Client object (version %s)", options.getVersion());
        }
        this.listOpenVolumes = new ConcurrentLinkedQueue();
    }

    @Override
    public void start() throws Exception {
        this.start(false);
    }

    @Override
    public void start(boolean startThreadsAsDaemons) throws Exception {
        this.startThreadsAsDaemons = startThreadsAsDaemons;
        this.networkClient = new RPCNIOSocketClient(this.dirServiceSSLOptions, this.options.getRequestTimeout_s() * 1000, this.options.getLingerTimeout_s() * 1000, "Client", startThreadsAsDaemons);
        this.networkClient.start();
        this.networkClient.waitForStartup();
        TimeSync tsInstance = TimeSync.initializeLocal(50);
        tsInstance.waitForStartup();
        this.dirServiceClient = new DIRServiceClient(this.networkClient, null);
        this.osdServiceClient = new OSDServiceClient(this.networkClient, null);
        this.clientUUID = Helper.generateVersion4UUID();
        assert (this.clientUUID != null && this.clientUUID != "");
        InetSocketAddress[] isas = new InetSocketAddress[this.dirAddresses.length];
        for (int i = 0; i < this.dirAddresses.length; ++i) {
            isas[i] = Helper.stringToInetSocketAddress(this.dirAddresses[i], GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber());
        }
        DIRClient dirClient = new DIRClient(this.dirServiceClient, isas, this.options.getMaxTries(), this.options.getRetryDelay_s() * 1000);
        this.uuidResolver = org.xtreemfs.common.uuids.UUIDResolver.startNonSingelton(dirClient, 3600, 1000);
    }

    @Override
    public synchronized void shutdown() {
        for (Volume volume : this.listOpenVolumes) {
            volume.close();
        }
        if (this.dirServiceClient != null) {
            try {
                this.networkClient.shutdown();
                this.networkClient.waitForShutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void closeVolume(Volume volume) {
        boolean removed = this.listOpenVolumes.remove(volume);
        assert (removed);
    }

    @Override
    public AdminVolume openVolume(String volumeName, SSLOptions sslOptions, Options options) throws AddressToUUIDNotFoundException, VolumeNotFoundException, IOException {
        UUIDIterator mrcUuidIterator = new UUIDIterator();
        this.volumeNameToMRCUUID(volumeName, mrcUuidIterator);
        VolumeImplementation volume = new VolumeImplementation(this, this.clientUUID, mrcUuidIterator, volumeName, sslOptions, options);
        volume.start(this.startThreadsAsDaemons);
        this.listOpenVolumes.add(volume);
        return volume;
    }

    @Override
    public void createVolume(String mrcAddress, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        ArrayList<GlobalTypes.KeyValuePair> volumeAttributes = new ArrayList<GlobalTypes.KeyValuePair>();
        this.createVolume(mrcAddress, auth, userCredentials, volumeName, 511, "", "", GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX, GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0, 128, 1, volumeAttributes);
    }

    @Override
    public void createVolume(List<String> mrcAddresses, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        ArrayList<GlobalTypes.KeyValuePair> volumeAttributes = new ArrayList<GlobalTypes.KeyValuePair>();
        this.createVolume(mrcAddresses, auth, userCredentials, volumeName, 511, "", "", GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX, GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0, 128, 1, volumeAttributes);
    }

    @Override
    public void createVolume(String mrcAddress, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName, int mode, String ownerUsername, String ownerGroupname, GlobalTypes.AccessControlPolicyType accessPolicyType, GlobalTypes.StripingPolicyType defaultStripingPolicyType, int defaultStripeSize, int defaultStripeWidth, List<GlobalTypes.KeyValuePair> volumeAttributes) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUID(mrcAddress);
        this.createVolume(iteratorWithAddresses, auth, userCredentials, volumeName, mode, ownerUsername, ownerGroupname, accessPolicyType, defaultStripingPolicyType, defaultStripeSize, defaultStripeWidth, volumeAttributes);
    }

    @Override
    public void createVolume(RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName, int mode, String ownerUsername, String ownerGroupname, GlobalTypes.AccessControlPolicyType accessPolicyType, GlobalTypes.StripingPolicyType defaultStripingPolicyType, int defaultStripeSize, int defaultStripeWidth, List<GlobalTypes.KeyValuePair> volumeAttributes) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        DIR.ServiceSet mrcs = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, null, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, DIR.ServiceType.SERVICE_TYPE_MRC);
            }
        });
        if (mrcs.getServicesCount() == 0) {
            throw new IOException("no MRC available for volume creation");
        }
        ArrayList<String> mrcAddresses = new ArrayList<String>();
        for (DIR.Service uuid : mrcs.getServicesList()) {
            mrcAddresses.add(this.uuidToAddress(uuid.getUuid()));
        }
        this.createVolume(mrcAddresses, auth, userCredentials, volumeName, mode, ownerUsername, ownerGroupname, accessPolicyType, defaultStripingPolicyType, defaultStripeSize, defaultStripeWidth, volumeAttributes);
    }

    @Override
    public void createVolume(List<String> mrcAddresses, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName, int mode, String ownerUsername, String ownerGroupname, GlobalTypes.AccessControlPolicyType accessPolicyType, GlobalTypes.StripingPolicyType defaultStripingPolicyType, int defaultStripeSize, int defaultStripeWidth, List<GlobalTypes.KeyValuePair> volumeAttributes) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUIDs(mrcAddresses);
        this.createVolume(iteratorWithAddresses, auth, userCredentials, volumeName, mode, ownerUsername, ownerGroupname, accessPolicyType, defaultStripingPolicyType, defaultStripeSize, defaultStripeWidth, volumeAttributes);
    }

    private void createVolume(UUIDIterator mrcAddresses, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName, int mode, String ownerUsername, String ownerGroupname, GlobalTypes.AccessControlPolicyType accessPolicyType, GlobalTypes.StripingPolicyType defaultStripingPolicyType, int defaultStripeSize, int defaultStripeWidth, List<GlobalTypes.KeyValuePair> volumeAttributes) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        final MRCServiceClient mrcClient = new MRCServiceClient(this.networkClient, null);
        GlobalTypes.StripingPolicy sp = GlobalTypes.StripingPolicy.newBuilder().setType(defaultStripingPolicyType).setStripeSize(defaultStripeSize).setWidth(defaultStripeWidth).build();
        MRC.Volume volume = MRC.Volume.newBuilder().setName(volumeName).setMode(mode).setOwnerUserId(ownerUsername).setOwnerGroupId(ownerGroupname).setAccessControlPolicy(accessPolicyType).setDefaultStripingPolicy(sp).addAllAttrs(volumeAttributes).setId("").build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, auth, this.options, this, mrcAddresses, true, volume, new RPCCaller.CallGenerator<MRC.Volume, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth auth, RPC.UserCredentials userCreds, MRC.Volume input) throws IOException {
                return mrcClient.xtreemfs_mkvol(server, auth, userCreds, input);
            }
        });
    }

    @Override
    public void deleteVolume(RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        DIR.ServiceSet s = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, volumeName, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String volumeName) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_name(server, authHeader, userCreds, volumeName);
            }
        });
        if (s == null || s.getServicesCount() == 0) {
            throw new IOException("volume '" + volumeName + "' does not exist");
        }
        if (s != null) {
            DIR.Service vol = s.getServices(0);
            String mrcAddress = this.uuidToAddress(KeyValuePairs.getValue(vol.getData().getDataList(), "mrc"));
            this.deleteVolume(mrcAddress, auth, userCredentials, volumeName);
        }
    }

    @Override
    public void deleteVolume(String mrcAddress, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUID(mrcAddress);
        this.deleteVolume(iteratorWithAddresses, auth, userCredentials, volumeName);
    }

    @Override
    public void deleteVolume(List<String> mrcAddresses, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUIDs(mrcAddresses);
        this.deleteVolume(iteratorWithAddresses, auth, userCredentials, volumeName);
    }

    private void deleteVolume(UUIDIterator mrcAddresses, RPC.Auth auth, RPC.UserCredentials userCredentials, String volumeName) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        final MRCServiceClient mrcServiceClient = new MRCServiceClient(this.networkClient, null);
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, auth, this.options, this, mrcAddresses, true, volumeName, new RPCCaller.CallGenerator<String, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return mrcServiceClient.xtreemfs_rmvol(server, authHeader, userCreds, input);
            }
        });
    }

    @Override
    public MRC.Volumes listVolumes(String mrcAddress) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUID(mrcAddress);
        return this.listVolumes(iteratorWithAddresses);
    }

    @Override
    public MRC.Volumes listVolumes(List<String> mrcAddresses) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        iteratorWithAddresses.addUUIDs(mrcAddresses);
        return this.listVolumes(iteratorWithAddresses);
    }

    private MRC.Volumes listVolumes(UUIDIterator uuidIteratorWithAddresses) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        final MRCServiceClient mrcServiceClient = new MRCServiceClient(this.networkClient, null);
        RPC.UserCredentials userCredentials = RPC.UserCredentials.newBuilder().setUsername("xtreemfs").build();
        MRC.Volumes volumes = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.options, this, uuidIteratorWithAddresses, true, Common.emptyRequest.getDefaultInstance(), new RPCCaller.CallGenerator<Common.emptyRequest, MRC.Volumes>(){

            @Override
            public RPCResponse<MRC.Volumes> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
                return mrcServiceClient.xtreemfs_lsvol(server, authHeader, userCreds, input);
            }
        });
        return volumes;
    }

    @Override
    public MRC.Volumes listVolumes() throws IOException {
        DIR.ServiceSet sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, null, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, DIR.ServiceType.SERVICE_TYPE_VOLUME);
            }
        });
        UUIDIterator iteratorWithAddresses = new UUIDIterator();
        block0: for (int i = 0; i < sSet.getServicesCount(); ++i) {
            for (GlobalTypes.KeyValuePair kvp : sSet.getServices(i).getData().getDataList()) {
                if (!kvp.getKey().substring(0, 3).equals("mrc")) continue;
                String mrcUuid = kvp.getValue();
                iteratorWithAddresses.addUUID(this.uuidToAddress(mrcUuid));
                continue block0;
            }
        }
        return this.listVolumes(iteratorWithAddresses);
    }

    @Override
    public String[] listVolumeNames() throws IOException {
        DIR.ServiceSet sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, null, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, DIR.ServiceType.SERVICE_TYPE_VOLUME);
            }
        });
        String[] volNames = new String[sSet.getServicesCount()];
        for (int i = 0; i < volNames.length; ++i) {
            volNames[i] = sSet.getServices(i).getName();
        }
        return volNames;
    }

    @Override
    public Map<String, DIR.Service> listServers() throws IOException, PosixErrorException {
        DIR.ServiceSet osds = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, null, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, DIR.ServiceType.SERVICE_TYPE_MIXED);
            }
        });
        HashMap<String, DIR.Service> serviceConfigs = new HashMap<String, DIR.Service>();
        for (DIR.Service service : osds.getServicesList()) {
            if (service.getType() != DIR.ServiceType.SERVICE_TYPE_MRC && service.getType() != DIR.ServiceType.SERVICE_TYPE_OSD) continue;
            serviceConfigs.put(this.uuidToAddress(service.getUuid()), service);
        }
        return serviceConfigs;
    }

    @Override
    public Map<String, DIR.Service> listOSDsAndAttributes() throws IOException, PosixErrorException {
        DIR.ServiceSet osds = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, null, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, DIR.ServiceType.SERVICE_TYPE_OSD);
            }
        });
        HashMap<String, DIR.Service> osdConfigs = new HashMap<String, DIR.Service>();
        for (DIR.Service service : osds.getServicesList()) {
            osdConfigs.put(service.getUuid(), service);
        }
        return osdConfigs;
    }

    @Override
    public String uuidToAddress(String uuid) throws AddressToUUIDNotFoundException {
        assert (!uuid.isEmpty());
        String address = "";
        ServiceUUID serviceUuid = new ServiceUUID(uuid, this.uuidResolver);
        try {
            serviceUuid.resolve();
            address = serviceUuid.getAddressString();
        }
        catch (UnknownUUIDException e) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "UUID: SERVICE NOT FOUND FOR UUID %S", uuid);
            }
            throw new AddressToUUIDNotFoundException(uuid);
        }
        return address;
    }

    @Override
    public String volumeNameToMRCUUID(String volumeName) throws VolumeNotFoundException, AddressToUUIDNotFoundException {
        assert (!volumeName.isEmpty());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "Searching MRC for volume %s", volumeName);
        }
        String parsedVolumeName = this.parseVolumeName(volumeName);
        DIR.ServiceSet sSet = null;
        try {
            sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, parsedVolumeName, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

                @Override
                public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                    return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_name(server, authHeader, userCreds, input);
                }
            });
        }
        catch (IOException e) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "volumeNameToMRCUUID: couldn't resolve mrc UUID for volumeName %s Reason: %s", volumeName, e.getMessage());
            }
            throw new VolumeNotFoundException(parsedVolumeName);
        }
        String mrcUuid = "";
        for (DIR.Service service : sSet.getServicesList()) {
            if (!service.getType().equals(DIR.ServiceType.SERVICE_TYPE_VOLUME) || !service.getName().equals(parsedVolumeName)) continue;
            for (GlobalTypes.KeyValuePair kvp : service.getData().getDataList()) {
                if (!kvp.getKey().substring(0, 3).equals("mrc")) continue;
                mrcUuid = kvp.getValue();
                break;
            }
            if (mrcUuid.isEmpty()) continue;
            break;
        }
        if (mrcUuid.isEmpty()) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "No MRC found for volume $s.", parsedVolumeName);
            }
            throw new VolumeNotFoundException(parsedVolumeName);
        }
        return mrcUuid;
    }

    @Override
    public void volumeNameToMRCUUID(String volumeName, UUIDIterator uuidIterator) throws VolumeNotFoundException, AddressToUUIDNotFoundException {
        assert (uuidIterator != null);
        assert (!volumeName.isEmpty());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "Searching MRC for volume %s", volumeName);
        }
        String parsedVolumeName = this.parseVolumeName(volumeName);
        DIR.ServiceSet sSet = null;
        try {
            sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, this.dirServiceUserCredentials, this.dirServiceAuth, this.options, this, this.dirServiceAddresses, true, parsedVolumeName, new RPCCaller.CallGenerator<String, DIR.ServiceSet>(){

                @Override
                public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String input) throws IOException {
                    return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_name(server, authHeader, userCreds, input);
                }
            });
        }
        catch (IOException e) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "volumeNameToMRCUUID: couldn't resolve mrc UUID for volumeName %s Reason: %s", volumeName, e.getMessage());
            }
            throw new VolumeNotFoundException(parsedVolumeName);
        }
        boolean mrcFound = false;
        for (DIR.Service service : sSet.getServicesList()) {
            if (!service.getType().equals(DIR.ServiceType.SERVICE_TYPE_VOLUME) || !service.getName().equals(parsedVolumeName)) continue;
            for (GlobalTypes.KeyValuePair kvp : service.getData().getDataList()) {
                if (!kvp.getKey().substring(0, 3).equals("mrc")) continue;
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MRC with UUID: %s added (key: %s).", kvp.getValue(), kvp.getKey());
                }
                uuidIterator.addUUID(kvp.getValue());
                mrcFound = true;
            }
        }
        if (!mrcFound) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "No MRC found for volume $s.", parsedVolumeName);
            }
            throw new VolumeNotFoundException(parsedVolumeName);
        }
    }

    private String parseVolumeName(String volumeName) {
        int pos = 0;
        pos = volumeName.indexOf(64);
        String parsedVolumeName = pos == -1 ? volumeName : volumeName.substring(0, pos);
        return parsedVolumeName;
    }

    private RPC.Auth StringToAuth(String password) {
        return RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_PASSWORD).setAuthPasswd(RPC.AuthPassword.newBuilder().setPassword(password).build()).build();
    }

    @Override
    public void startCleanUp(String osdUUID, String password, boolean remove, boolean deleteVolumes, boolean restore, boolean removeMetdata, int metaDataTimeoutS) throws IOException {
        try {
            OSD.xtreemfs_cleanup_startRequest request = OSD.xtreemfs_cleanup_startRequest.newBuilder().setRemoveZombies(remove).setRemoveUnavailVolume(deleteVolumes).setLostAndFound(restore).setDeleteMetadata(removeMetdata).setMetadataTimeout(metaDataTimeoutS).build();
            RPC.Auth pw = this.StringToAuth(password);
            UUIDIterator it = new UUIDIterator();
            it.addUUID(osdUUID);
            RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, request, new RPCCaller.CallGenerator<OSD.xtreemfs_cleanup_startRequest, Common.emptyResponse>(){

                @Override
                public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.xtreemfs_cleanup_startRequest input) throws IOException {
                    return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_start(server, authHeader, userCreds, input);
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Cleanup could not be started on the given OSD, because: " + e.getMessage());
        }
    }

    @Override
    public void startVersionCleanUp(String osdUUID, String password) throws IOException {
        try {
            RPC.Auth pw = this.StringToAuth(password);
            UUIDIterator it = new UUIDIterator();
            it.addUUID(osdUUID);
            RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, null, new RPCCaller.CallGenerator<Common.emptyRequest, Common.emptyResponse>(){

                @Override
                public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
                    return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_versions_start(server, authHeader, userCreds);
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Version cleanup could not be started on the given OSD, because: " + e.getMessage());
        }
    }

    @Override
    public void stopCleanUp(String osdUUID, String password) throws IOException {
        RPC.Auth pw = this.StringToAuth(password);
        UUIDIterator it = new UUIDIterator();
        it.addUUID(osdUUID);
        RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, null, new RPCCaller.CallGenerator<Common.emptyRequest, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException, PosixErrorException {
                return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_stop(server, authHeader, userCreds);
            }
        });
    }

    @Override
    public boolean isRunningCleanUp(String osdUUID, String password) throws IOException {
        RPC.Auth pw = this.StringToAuth(password);
        UUIDIterator it = new UUIDIterator();
        it.addUUID(osdUUID);
        OSD.xtreemfs_cleanup_is_runningResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, null, new RPCCaller.CallGenerator<Common.emptyRequest, OSD.xtreemfs_cleanup_is_runningResponse>(){

            @Override
            public RPCResponse<OSD.xtreemfs_cleanup_is_runningResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException, PosixErrorException {
                return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_is_running(server, authHeader, userCreds);
            }
        });
        assert (response != null);
        return response.getIsRunning();
    }

    @Override
    public String getCleanUpState(String osdUUID, String password) throws IOException {
        RPC.Auth pw = this.StringToAuth(password);
        UUIDIterator it = new UUIDIterator();
        it.addUUID(osdUUID);
        OSD.xtreemfs_cleanup_statusResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, null, new RPCCaller.CallGenerator<Common.emptyRequest, OSD.xtreemfs_cleanup_statusResponse>(){

            @Override
            public RPCResponse<OSD.xtreemfs_cleanup_statusResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException, PosixErrorException {
                return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_status(server, authHeader, userCreds);
            }
        });
        assert (response != null);
        return response.getStatus();
    }

    @Override
    public List<String> getCleanUpResult(String osdUUID, String password) throws IOException {
        RPC.Auth pw = this.StringToAuth(password);
        UUIDIterator it = new UUIDIterator();
        it.addUUID(osdUUID);
        OSD.xtreemfs_cleanup_get_resultsResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, pw, this.options, this, it, false, null, new RPCCaller.CallGenerator<Common.emptyRequest, OSD.xtreemfs_cleanup_get_resultsResponse>(){

            @Override
            public RPCResponse<OSD.xtreemfs_cleanup_get_resultsResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException, PosixErrorException {
                return ClientImplementation.this.osdServiceClient.xtreemfs_cleanup_get_results(server, authHeader, userCreds);
            }
        });
        assert (response != null);
        return response.getResultsList();
    }

    @Override
    public DIR.ServiceSet getServiceByType(DIR.ServiceType serviceType) throws IOException {
        DIR.serviceGetByTypeRequest request = DIR.serviceGetByTypeRequest.newBuilder().setType(serviceType).build();
        DIR.ServiceSet sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, RPCAuthentication.userService, RPCAuthentication.authNone, this.options, this, this.dirServiceAddresses, true, request, new RPCCaller.CallGenerator<DIR.serviceGetByTypeRequest, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByTypeRequest input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_type(server, authHeader, userCreds, input);
            }
        });
        assert (sSet != null);
        return sSet;
    }

    @Override
    public DIR.Service getServiceByUUID(String uuid) throws IOException {
        DIR.serviceGetByUUIDRequest request = DIR.serviceGetByUUIDRequest.newBuilder().setName(uuid).build();
        DIR.ServiceSet sSet = RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, RPCAuthentication.userService, RPCAuthentication.authNone, this.options, this, this.dirServiceAddresses, true, request, new RPCCaller.CallGenerator<DIR.serviceGetByUUIDRequest, DIR.ServiceSet>(){

            @Override
            public RPCResponse<DIR.ServiceSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByUUIDRequest input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_get_by_uuid(server, authHeader, userCreds, input);
            }
        });
        if (sSet.getServicesCount() == 0) {
            throw new IOException("No Service with UUID " + uuid + " available");
        }
        return sSet.getServices(0);
    }

    @Override
    public void setOSDServiceStatus(String osdUUID, DIR.ServiceStatus serviceStatus) throws IOException {
        DIR.Service osdService = this.getServiceByUUID(osdUUID);
        LinkedList<GlobalTypes.KeyValuePair> data = new LinkedList<GlobalTypes.KeyValuePair>(osdService.getData().getDataList());
        KeyValuePairs.putValue(data, "static.status", Integer.toString(serviceStatus.getNumber()));
        KeyValuePairs.putValue(data, "static.do_not_set_last_updated", Boolean.toString(true));
        DIR.ServiceDataMap dataMap = DIR.ServiceDataMap.newBuilder().addAllData(data).build();
        osdService = osdService.toBuilder().setData(dataMap).build();
        DIR.serviceRegisterRequest request = DIR.serviceRegisterRequest.newBuilder().setService(osdService).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.DIR, RPCAuthentication.userService, RPCAuthentication.authNone, this.options, this, this.dirServiceAddresses, true, request, new RPCCaller.CallGenerator<DIR.serviceRegisterRequest, DIR.serviceRegisterResponse>(){

            @Override
            public RPCResponse<DIR.serviceRegisterResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceRegisterRequest input) throws IOException {
                return ClientImplementation.this.dirServiceClient.xtreemfs_service_register(server, RPCAuthentication.authNone, userCreds, input);
            }
        });
    }

    @Override
    public DIR.ServiceStatus getOSDServiceStatus(String osdUUID) throws IOException {
        DIR.Service osdService = this.getServiceByUUID(osdUUID);
        String serviceStatus = KeyValuePairs.getValue(osdService.getData().getDataList(), "static.status");
        return DIR.ServiceStatus.valueOf(Integer.valueOf(serviceStatus));
    }

    @Override
    public Set<String> getRemovedOsds() throws IOException {
        TreeSet<String> removedOSDs = new TreeSet<String>();
        String statusRemoved = Integer.toString(DIR.ServiceStatus.SERVICE_STATUS_REMOVED.getNumber());
        DIR.ServiceSet servs = this.getServiceByType(DIR.ServiceType.SERVICE_TYPE_OSD);
        for (DIR.Service serv : servs.getServicesList()) {
            String hbAttr = KeyValuePairs.getValue(serv.getData().getDataList(), "static.status");
            if (hbAttr == null || !hbAttr.equalsIgnoreCase(statusRemoved)) continue;
            removedOSDs.add(serv.getUuid());
        }
        return removedOSDs;
    }
}

