/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xtreemfs.common.libxtreemfs.AdminFileHandle;
import org.xtreemfs.common.libxtreemfs.AsyncWriteBuffer;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.common.libxtreemfs.FileInfo;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.RPCCaller;
import org.xtreemfs.common.libxtreemfs.ReadOperation;
import org.xtreemfs.common.libxtreemfs.StripeTranslator;
import org.xtreemfs.common.libxtreemfs.Tupel;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.UUIDResolver;
import org.xtreemfs.common.libxtreemfs.VolumeImplementation;
import org.xtreemfs.common.libxtreemfs.WriteOperation;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.InternalServerErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.InvalidChecksumException;
import org.xtreemfs.common.libxtreemfs.exceptions.InvalidViewException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.UUIDIteratorListIsEmpyException;
import org.xtreemfs.common.libxtreemfs.exceptions.UUIDNotInXlocSetException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class FileHandleImplementation
implements FileHandle,
AdminFileHandle {
    private final String clientUuid;
    private final UUIDIterator mrcUuidIterator;
    private final UUIDIterator osdUuidIterator;
    private final UUIDResolver uuidResolver;
    private final FileInfo fileInfo;
    private final VolumeImplementation volume;
    private GlobalTypes.XCap xcap;
    private boolean xcapRenewalPending;
    private final Object xcapRenewalPendingLock;
    private GlobalTypes.OSDWriteResponse osdWriteResponseForAsyncWriteBack;
    private final MRCServiceClient mrcServiceClient;
    private final OSDServiceClient osdServiceClient;
    final Map<GlobalTypes.StripingPolicyType, StripeTranslator> stripeTranslators;
    private boolean asyncWritesEnabled;
    private boolean asyncWritesFailed;
    private final Options volumeOptions;
    private final RPC.Auth authBogus;
    private final RPC.UserCredentials userCredentialsBogus;

    public FileHandleImplementation(VolumeImplementation volume, String clientUuid, FileInfo fileInfo, GlobalTypes.XCap xcap, UUIDIterator mrcUuidIterator, UUIDIterator osdUuidIterator, UUIDResolver uuidResolver, MRCServiceClient mrcServiceClient, OSDServiceClient osdServiceClient, Map<GlobalTypes.StripingPolicyType, StripeTranslator> stripeTranslators, boolean asyncWritesEnabled, Options options, RPC.Auth authBogus, RPC.UserCredentials userCredentialsBogus) {
        this.volume = volume;
        this.clientUuid = clientUuid;
        this.fileInfo = fileInfo;
        this.xcap = xcap;
        this.mrcUuidIterator = mrcUuidIterator;
        this.osdUuidIterator = osdUuidIterator;
        this.uuidResolver = uuidResolver;
        this.mrcServiceClient = mrcServiceClient;
        this.osdServiceClient = osdServiceClient;
        this.stripeTranslators = stripeTranslators;
        this.asyncWritesEnabled = asyncWritesEnabled;
        this.volumeOptions = options;
        this.authBogus = authBogus;
        this.userCredentialsBogus = userCredentialsBogus;
        this.xcapRenewalPending = false;
        this.xcapRenewalPendingLock = new Object();
    }

    @Override
    public int read(RPC.UserCredentials userCredentials, byte[] data, int count, long offset) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.read(userCredentials, data, 0, count, offset);
    }

    @Override
    public int read(final RPC.UserCredentials userCredentials, final byte[] data, final int dataOffset, final int count, final long offset) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        ViewCheckedOperation<Integer> operation = new ViewCheckedOperation<Integer>(){

            @Override
            Integer doOperation() throws IOException {
                return FileHandleImplementation.this.doRead(userCredentials, data, dataOffset, count, offset);
            }
        };
        return (Integer)operation.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(RPC.UserCredentials userCredentials, byte[] data, int dataOffset, int count, long offset) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.fileInfo.waitForPendingAsyncWrites();
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            if (this.asyncWritesFailed) {
                throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, "A previous asynchronous write did fail. No more actions on this file handle are allowed.");
            }
            fcBuilder.setXcap(this.xcap.toBuilder());
        }
        GlobalTypes.FileCredentials fc = fcBuilder.setXlocs(this.fileInfo.getXLocSet()).build();
        ReusableBuffer buf = ReusableBuffer.wrap(data, dataOffset, count);
        int receivedData = 0;
        if (fc.getXlocs().getReplicasCount() == 0) {
            Logging.logMessage(3, Logging.Category.misc, this, "No replica found for file %s", this.fileInfo.getPath());
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, "no replica found for file: " + this.fileInfo.getPath());
        }
        GlobalTypes.StripingPolicy policy = fc.getXlocs().getReplicas(0).getStripingPolicy();
        StripeTranslator translator = this.getStripeTranslator(policy.getType());
        Vector<ReadOperation> operations = new Vector<ReadOperation>();
        translator.translateReadRequest(count, offset, policy, operations);
        UUIDIterator tempUuidIteratorForStriping = new UUIDIterator();
        for (int j = 0; j < operations.size(); ++j) {
            UUIDIterator uuidIterator;
            OSD.readRequest.Builder readRqBuilder = OSD.readRequest.newBuilder();
            readRqBuilder.setFileCredentials(fc);
            readRqBuilder.setFileId(fc.getXcap().getFileId());
            readRqBuilder.setObjectNumber(operations.get(j).getObjNumber());
            readRqBuilder.setObjectVersion(0L);
            readRqBuilder.setOffset(operations.get(j).getReqOffset());
            readRqBuilder.setLength(operations.get(j).getReqSize());
            if (readRqBuilder.getFileCredentials().getXlocs().getReplicas(0).getOsdUuidsCount() > 1) {
                tempUuidIteratorForStriping.clear();
                int stripeWidthFirstReplica = fc.getXlocs().getReplicas(0).getStripingPolicy().getWidth();
                for (int replicaIdx = 0; replicaIdx < fc.getXlocs().getReplicasCount(); ++replicaIdx) {
                    if (fc.getXlocs().getReplicas(replicaIdx).getStripingPolicy().getWidth() != stripeWidthFirstReplica) continue;
                    tempUuidIteratorForStriping.addUUID(Helper.getOSDUUIDFromXlocSet(fc.getXlocs(), replicaIdx, operations.get(j).getOsdOffset()));
                }
                uuidIterator = tempUuidIteratorForStriping;
            } else {
                uuidIterator = this.osdUuidIterator;
            }
            buf.position(operations.get(j).getBufferStart());
            OSD.ObjectData objectData = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, this.userCredentialsBogus, this.authBogus, this.volumeOptions, this.uuidResolver, uuidIterator, false, readRqBuilder.build(), buf, new RPCCaller.CallGenerator<OSD.readRequest, OSD.ObjectData>(){

                @Override
                public RPCResponse<OSD.ObjectData> executeCall(InetSocketAddress server, RPC.Auth auth, RPC.UserCredentials userCreds, OSD.readRequest callRequest) throws IOException {
                    return FileHandleImplementation.this.osdServiceClient.read(server, auth, userCreds, callRequest);
                }
            });
            for (int i = 0; i < objectData.getZeroPadding(); ++i) {
                buf.put((byte)0);
            }
            receivedData += buf.position() - operations.get(j).getBufferStart();
        }
        return receivedData;
    }

    @Override
    public synchronized int write(RPC.UserCredentials userCredentials, byte[] data, int count, long offset) throws IOException, PosixErrorException, InternalServerErrorException, AddressToUUIDNotFoundException {
        ReusableBuffer buffer = ReusableBuffer.wrap(data);
        return this.write(userCredentials, buffer, count, offset);
    }

    @Override
    public synchronized int write(RPC.UserCredentials userCredentials, byte[] data, int dataOffset, int count, long offset) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        ReusableBuffer buffer = ReusableBuffer.wrap(data, dataOffset, count);
        return this.write(userCredentials, buffer, count, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(RPC.UserCredentials userCredentials, ReusableBuffer buffer, int count, long offset) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            if (this.asyncWritesFailed) {
                throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, "A previous asynchronous write did fail. No further writes on this file handle are allowed.");
            }
            fcBuilder.setXcap(this.xcap.toBuilder());
        }
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        String globalFileId = fcBuilder.getXcap().getFileId();
        GlobalTypes.XLocSet xlocs = fcBuilder.getXlocs();
        if (xlocs.getReplicasCount() == 0) {
            String error = "No replica found for file: " + this.fileInfo.getPath();
            Logging.logMessage(3, Logging.Category.misc, this, error, new Object[0]);
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, error);
        }
        Vector<WriteOperation> operations = new Vector<WriteOperation>();
        GlobalTypes.StripingPolicy stripingPolicy = xlocs.getReplicas(0).getStripingPolicy();
        StripeTranslator translator = this.getStripeTranslator(stripingPolicy.getType());
        translator.translateWriteRequest(count, offset, stripingPolicy, buffer, operations);
        GlobalTypes.FileCredentials fileCredentials = fcBuilder.build();
        String osdUuid = "";
        if (this.asyncWritesEnabled) {
            for (int j = 0; j < operations.size(); ++j) {
                OSD.writeRequest.Builder request = OSD.writeRequest.newBuilder();
                request.setFileCredentials(fileCredentials);
                request.setFileId(globalFileId);
                request.setObjectNumber(operations.get(j).getObjNumber());
                request.setObjectVersion(0L);
                request.setOffset(operations.get(j).getReqOffset());
                request.setLeaseTimeout(0L);
                OSD.ObjectData objectData = OSD.ObjectData.newBuilder().setChecksum(0).setInvalidChecksumOnOsd(false).setZeroPadding(0).build();
                request.setObjectData(objectData);
                AsyncWriteBuffer writeBuffer = xlocs.getReplicas(0).getOsdUuidsCount() > 1 ? new AsyncWriteBuffer(request.build(), operations.get(j).getReqData(), operations.get(j).getReqSize(), this, Helper.getOSDUUIDFromXlocSet(xlocs, 0, operations.get(j).getOsdOffset())) : new AsyncWriteBuffer(request.build(), operations.get(j).getReqData(), operations.get(j).getReqSize(), this);
                this.fileInfo.asyncWrite(writeBuffer);
            }
        } else {
            for (int j = 0; j < operations.size(); ++j) {
                UUIDIterator uuidIterator;
                OSD.writeRequest.Builder request = OSD.writeRequest.newBuilder();
                request.setFileCredentials(fileCredentials);
                request.setFileId(globalFileId);
                request.setObjectNumber(operations.get(j).getObjNumber());
                request.setObjectVersion(0L);
                request.setOffset(operations.get(j).getReqOffset());
                request.setLeaseTimeout(0L);
                OSD.ObjectData objectData = OSD.ObjectData.newBuilder().setChecksum(0).setInvalidChecksumOnOsd(false).setZeroPadding(0).build();
                request.setObjectData(objectData);
                if (xlocs.getReplicas(0).getOsdUuidsCount() > 1) {
                    osdUuid = Helper.getOSDUUIDFromXlocSet(xlocs, 0, operations.get(j).getOsdOffset());
                    uuidIterator = new UUIDIterator();
                    uuidIterator.clearAndAddUUID(osdUuid);
                } else {
                    uuidIterator = this.osdUuidIterator;
                }
                final ReusableBuffer writeDataBuffer = operations.get(j).getReqData();
                GlobalTypes.OSDWriteResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, uuidIterator, false, request.build(), new RPCCaller.CallGenerator<OSD.writeRequest, GlobalTypes.OSDWriteResponse>(){

                    @Override
                    public RPCResponse<GlobalTypes.OSDWriteResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.writeRequest input) throws IOException {
                        return FileHandleImplementation.this.osdServiceClient.write(server, authHeader, userCreds, input, writeDataBuffer.createViewBuffer());
                    }
                });
                assert (response != null);
                if (!response.hasSizeInBytes()) continue;
                this.fileInfo.tryToUpdateOSDWriteResponse(response, this.xcap);
            }
        }
        return count;
    }

    @Override
    public void flush() throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.flush(false);
    }

    protected void flush(boolean closeFile) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.fileInfo.flush(this, closeFile);
        this.throwIfAsyncWritesFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean didAsyncWriteFail() {
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            return this.asyncWritesFailed;
        }
    }

    private void throwIfAsyncWritesFailed() throws PosixErrorException {
        if (this.didAsyncWriteFail()) {
            String error = "Flush for file " + this.fileInfo.getPath() + " did not succeed flushing " + "all pending writes as at least one asynchronous write did fail.";
            Logging.logMessage(3, Logging.Category.misc, this, error, new Object[0]);
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, error);
        }
    }

    @Override
    public void truncate(RPC.UserCredentials userCredentials, long newFileSize) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.truncate(userCredentials, newFileSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(RPC.UserCredentials userCredentials, long newFileSize, boolean updateOnlyMRC) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.fileInfo.waitForPendingAsyncWrites();
        boolean awf = false;
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            awf = this.asyncWritesFailed;
        }
        if (awf) {
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, "A previous asynchronous write did fail.No further action on this file handle are allowed.");
        }
        GlobalTypes.XCap xcapCopy = this.getXcap();
        GlobalTypes.XCap truncateXCap = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUuidIterator, false, xcapCopy, new RPCCaller.CallGenerator<GlobalTypes.XCap, GlobalTypes.XCap>(){

            @Override
            public RPCResponse<GlobalTypes.XCap> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.XCap input) throws IOException {
                return FileHandleImplementation.this.mrcServiceClient.ftruncate(server, authHeader, userCreds, input);
            }
        });
        GlobalTypes.XCap xCap = this.xcap;
        synchronized (xCap) {
            this.xcap = truncateXCap;
        }
        this.truncatePhaseTwoAndThree(userCredentials, newFileSize, updateOnlyMRC);
    }

    protected void truncatePhaseTwoAndThree(RPC.UserCredentials userCredentials, long newFileSize, boolean updateOnlyMRC) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        GlobalTypes.OSDWriteResponse response = null;
        GlobalTypes.XCap xCapCopy = this.getXcap();
        if (!updateOnlyMRC) {
            OSD.truncateRequest.Builder requestBuilder = OSD.truncateRequest.newBuilder();
            GlobalTypes.FileCredentials.Builder fileCredentialsBuilder = GlobalTypes.FileCredentials.newBuilder();
            fileCredentialsBuilder.setXlocs(this.fileInfo.getXLocSet());
            fileCredentialsBuilder.setXcap(xCapCopy);
            requestBuilder.setFileId(fileCredentialsBuilder.getXcap().getFileId());
            requestBuilder.setFileCredentials(fileCredentialsBuilder.build());
            requestBuilder.setNewFileSize(newFileSize);
            response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, requestBuilder.build(), new RPCCaller.CallGenerator<OSD.truncateRequest, GlobalTypes.OSDWriteResponse>(){

                @Override
                public RPCResponse<GlobalTypes.OSDWriteResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.truncateRequest input) throws IOException {
                    return FileHandleImplementation.this.osdServiceClient.truncate(server, authHeader, userCreds, input);
                }
            });
            assert (response != null);
            assert (response.hasSizeInBytes());
        } else {
            response = GlobalTypes.OSDWriteResponse.newBuilder().setTruncateEpoch(xCapCopy.getTruncateEpoch()).setSizeInBytes(newFileSize).build();
        }
        this.fileInfo.tryToUpdateOSDWriteResponse(response, xCapCopy);
        this.fileInfo.flushPendingFileSizeUpdate(this);
    }

    @Override
    public MRC.Stat getAttr(RPC.UserCredentials userCredentials) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.volume.getAttr(userCredentials, this.fileInfo.getPath());
    }

    @Override
    public OSD.Lock acquireLock(RPC.UserCredentials userCredentials, int processId, long offset, long length, boolean exclusive, boolean waitForLock) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        OSD.Lock.Builder lockBuilder = OSD.Lock.newBuilder();
        lockBuilder.setClientUuid(this.clientUuid);
        lockBuilder.setClientPid(processId);
        lockBuilder.setOffset(offset);
        lockBuilder.setLength(length);
        lockBuilder.setExclusive(exclusive);
        OSD.Lock lock = lockBuilder.build();
        Tupel<OSD.Lock, boolean[]> checkLockReturn = this.fileInfo.checkLock(lock);
        boolean conflictFound = checkLockReturn.getSecond()[0];
        boolean cachedLockForPidEqual = checkLockReturn.getSecond()[2];
        if (conflictFound) {
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "conflicting lock");
        }
        if (cachedLockForPidEqual) {
            return lock;
        }
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        OSD.lockRequest request = OSD.lockRequest.newBuilder().setLockRequest(lock).setFileCredentials(fcBuilder.build()).build();
        OSD.Lock response = null;
        if (!waitForLock) {
            response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, request, new RPCCaller.CallGenerator<OSD.lockRequest, OSD.Lock>(){

                @Override
                public RPCResponse<OSD.Lock> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.lockRequest input) throws IOException {
                    return FileHandleImplementation.this.osdServiceClient.xtreemfs_lock_acquire(server, authHeader, userCreds, input);
                }
            });
        } else {
            for (int retriesLeft = this.volumeOptions.getMaxTries(); retriesLeft >= 0; --retriesLeft) {
                try {
                    response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, true, 1, request, new RPCCaller.CallGenerator<OSD.lockRequest, OSD.Lock>(){

                        @Override
                        public RPCResponse<OSD.Lock> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.lockRequest input) throws IOException {
                            return FileHandleImplementation.this.osdServiceClient.xtreemfs_lock_acquire(server, authHeader, userCreds, input);
                        }
                    });
                    break;
                }
                catch (PosixErrorException pe) {
                    if (pe.getPosixError().equals(RPC.POSIXErrno.POSIX_ERROR_EAGAIN)) continue;
                    throw pe;
                }
            }
        }
        this.fileInfo.putLock(response);
        return response;
    }

    @Override
    public OSD.Lock checkLock(RPC.UserCredentials userCredentials, int processId, long offset, long length, boolean exclusive) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        OSD.Lock.Builder lockBuilder = OSD.Lock.newBuilder();
        lockBuilder.setClientUuid(this.clientUuid);
        lockBuilder.setClientPid(processId);
        lockBuilder.setOffset(offset);
        lockBuilder.setLength(length);
        lockBuilder.setExclusive(exclusive);
        OSD.Lock lock = lockBuilder.build();
        Tupel<OSD.Lock, boolean[]> checkLockReturn = this.fileInfo.checkLock(lock);
        OSD.Lock conflictingLock = checkLockReturn.getFirst();
        boolean conflictFound = checkLockReturn.getSecond()[0];
        boolean lockForPidCached = checkLockReturn.getSecond()[1];
        if (conflictFound) {
            return conflictingLock;
        }
        if (lockForPidCached) {
            return lock;
        }
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        OSD.lockRequest request = OSD.lockRequest.newBuilder().setLockRequest(lock).setFileCredentials(fcBuilder.build()).build();
        OSD.Lock response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, request, new RPCCaller.CallGenerator<OSD.lockRequest, OSD.Lock>(){

            @Override
            public RPCResponse<OSD.Lock> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.lockRequest input) throws IOException {
                return FileHandleImplementation.this.osdServiceClient.xtreemfs_lock_check(server, authHeader, userCreds, input);
            }
        });
        return response;
    }

    @Override
    public void releaseLock(RPC.UserCredentials userCredentials, int processId, long offset, long length, boolean exclusive) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        OSD.Lock.Builder lockBuilder = OSD.Lock.newBuilder();
        lockBuilder.setClientUuid(this.clientUuid);
        lockBuilder.setClientPid(processId);
        lockBuilder.setOffset(offset);
        lockBuilder.setLength(length);
        lockBuilder.setExclusive(exclusive);
        this.releaseLock(userCredentials, lockBuilder.build());
    }

    @Override
    public void releaseLock(RPC.UserCredentials userCredentials, OSD.Lock lock) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        if (!this.fileInfo.checkIfProcessHasLocks(lock.getClientPid())) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "FileHandleImplementation.releaseLock(): Skipping unlock request as there is no lock known for PID: %s (Lock description: %s, %s ,%s)", lock.getClientPid(), lock.getOffset(), lock.getLength(), lock.getExclusive());
            }
            return;
        }
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        OSD.lockRequest unlockRequest = OSD.lockRequest.newBuilder().setFileCredentials(fcBuilder.build()).setLockRequest(lock).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, unlockRequest, new RPCCaller.CallGenerator<OSD.lockRequest, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.lockRequest input) throws IOException {
                return FileHandleImplementation.this.osdServiceClient.xtreemfs_lock_release(server, authHeader, userCreds, input);
            }
        });
        this.fileInfo.delLock(lock);
    }

    @Override
    public void releaseLockOfProcess(int processId) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.fileInfo.releaseLockOfProcess(this, processId);
    }

    protected void releaseLock(OSD.Lock lock) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.releaseLock(this.userCredentialsBogus, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingReplica(RPC.UserCredentials userCredentials, String osdUuid) throws IOException, AddressToUUIDNotFoundException {
        OSD.readRequest.Builder readRequestBuilder = OSD.readRequest.newBuilder();
        GlobalTypes.FileCredentials.Builder fileCredentialsBuilder = GlobalTypes.FileCredentials.newBuilder();
        GlobalTypes.XCap xCap = this.xcap;
        synchronized (xCap) {
            fileCredentialsBuilder.setXcap(this.xcap.toBuilder());
        }
        GlobalTypes.XLocSet xlocs = this.fileInfo.getXLocSet();
        fileCredentialsBuilder.setXlocs(xlocs);
        readRequestBuilder.setFileId(fileCredentialsBuilder.getXcap().getFileId());
        readRequestBuilder.setFileCredentials(fileCredentialsBuilder);
        if (xlocs.getReplicasCount() == 0) {
            throw new UUIDIteratorListIsEmpyException("pingReplica: The Xlocset contains no replicas");
        }
        boolean uuidFound = false;
        for (GlobalTypes.Replica replica : xlocs.getReplicasList()) {
            if (!replica.getOsdUuids(0).equals(osdUuid)) continue;
            uuidFound = true;
            if (!xlocs.getReplicaUpdatePolicy().equals("ronly") || (replica.getReplicationFlags() & GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber()) != 0) break;
            return;
        }
        if (!uuidFound) {
            throw new UUIDNotInXlocSetException("UUID: " + osdUuid + " not found  in the xlocset: " + xlocs.toString());
        }
        readRequestBuilder.setObjectNumber(0L);
        readRequestBuilder.setObjectVersion(0L);
        readRequestBuilder.setOffset(0);
        readRequestBuilder.setLength(1);
        UUIDIterator tempUuidIterator = new UUIDIterator();
        tempUuidIterator.addUUID(osdUuid);
        RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, this.userCredentialsBogus, this.authBogus, this.volumeOptions, this.uuidResolver, tempUuidIterator, false, readRequestBuilder.build(), new RPCCaller.CallGenerator<OSD.readRequest, OSD.ObjectData>(){

            @Override
            public RPCResponse<OSD.ObjectData> executeCall(InetSocketAddress server, RPC.Auth auth, RPC.UserCredentials userCreds, OSD.readRequest callRequest) throws IOException {
                return FileHandleImplementation.this.osdServiceClient.read(server, auth, userCreds, callRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.fileInfo.closeFileHandle(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBackFileSizeAsync() throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.xtreemfs_update_file_sizeRequest.Builder rqBuilder = MRC.xtreemfs_update_file_sizeRequest.newBuilder();
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            if (this.osdWriteResponseForAsyncWriteBack == null) {
                return;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "updateFileSize: %s #bytes: %s", this.fileInfo.getPath(), this.osdWriteResponseForAsyncWriteBack.getSizeInBytes());
            }
            rqBuilder.setXcap(this.xcap).setOsdWriteResponse(this.osdWriteResponseForAsyncWriteBack.toBuilder());
        }
        rqBuilder.setCloseFile(false);
        String address = this.uuidResolver.uuidToAddress(this.mrcUuidIterator.getUUID());
        InetSocketAddress server = RPCCaller.getInetSocketAddressFromAddress(address, GlobalTypes.SERVICES.MRC);
        RPCResponse<MRC.timestampResponse> r = this.mrcServiceClient.xtreemfs_update_file_size(server, this.authBogus, this.userCredentialsBogus, rqBuilder.build());
        final FileHandleImplementation fileHandle = this;
        r.registerListener(new RPCResponseAvailableListener<MRC.timestampResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void responseAvailable(RPCResponse<MRC.timestampResponse> r) {
                try {
                    r.get();
                    FileHandleImplementation.this.fileInfo.asyncFileSizeUpdateResponseHandler(FileHandleImplementation.this.osdWriteResponseForAsyncWriteBack, fileHandle, true);
                }
                catch (Exception e) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "renewXcapAsync: The following error occurred during the async all: ", e.getMessage());
                    }
                    FileHandleImplementation.this.fileInfo.asyncFileSizeUpdateResponseHandler(FileHandleImplementation.this.osdWriteResponseForAsyncWriteBack, fileHandle, false);
                }
                finally {
                    r.freeBuffers();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOsdWriteResponseForAsyncWriteBack(GlobalTypes.OSDWriteResponse osdwr) {
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            assert (this.osdWriteResponseForAsyncWriteBack == null);
            this.osdWriteResponseForAsyncWriteBack = osdwr.toBuilder().build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renewXCapAsync() throws IOException, AddressToUUIDNotFoundException {
        GlobalTypes.XCap xcapCopy;
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "Renew SCap for fileId: %s  Expiration in: %s", Helper.extractFileIdFromXcap(this.xcap), (long)this.xcap.getExpireTimeoutS() - System.currentTimeMillis() / 1000L);
            }
            xcapCopy = this.xcap.toBuilder().build();
            Object object = this.xcapRenewalPendingLock;
            synchronized (object) {
                this.xcapRenewalPending = true;
            }
        }
        String address = this.uuidResolver.uuidToAddress(this.mrcUuidIterator.getUUID());
        InetSocketAddress server = RPCCaller.getInetSocketAddressFromAddress(address, GlobalTypes.SERVICES.MRC);
        RPCResponse<GlobalTypes.XCap> r = this.mrcServiceClient.xtreemfs_renew_capability(server, this.authBogus, this.userCredentialsBogus, xcapCopy);
        r.registerListener(new RPCResponseAvailableListener<GlobalTypes.XCap>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void responseAvailable(RPCResponse<GlobalTypes.XCap> r) {
                try {
                    GlobalTypes.XCap newXCap = r.get();
                    FileHandleImplementation.this.setRenewedXcap(newXCap);
                }
                catch (Exception e) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "renewXcapAsync: Renewing XCap of file %s failed. Error: %s", FileHandleImplementation.this.fileInfo.getPath(), e.getMessage());
                    }
                }
                finally {
                    r.freeBuffers();
                    Object object = FileHandleImplementation.this.xcapRenewalPendingLock;
                    synchronized (object) {
                        FileHandleImplementation.this.xcapRenewalPending = false;
                        FileHandleImplementation.this.xcapRenewalPendingLock.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRenewedXcap(GlobalTypes.XCap newXCap) {
        GlobalTypes.XCap xCap = this.xcap;
        synchronized (xCap) {
            if (newXCap.getExpireTimeS() > this.xcap.getExpireTimeS()) {
                this.xcap = newXCap;
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "XCap renewed for fileId %s", Helper.extractFileIdFromXcap(this.xcap));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsyncWritesAsFailed() {
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            this.asyncWritesFailed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlobalTypes.XCap getXcap() {
        FileHandleImplementation fileHandleImplementation = this;
        synchronized (fileHandleImplementation) {
            return this.xcap.toBuilder().build();
        }
    }

    protected void writeBackFileSize(GlobalTypes.OSDWriteResponse response, boolean closeFile) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        long fileId = 0L;
        fileId = Helper.extractFileIdFromXcap(this.getXcap());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "WriteBackFileSize: fileId: %s  #bytes: %s  close file?: %s", fileId, response.getSizeInBytes(), closeFile);
        }
        MRC.xtreemfs_update_file_sizeRequest.Builder requestBuilder = MRC.xtreemfs_update_file_sizeRequest.newBuilder();
        requestBuilder.setXcap(this.getXcap());
        requestBuilder.setOsdWriteResponse(response.toBuilder().build());
        requestBuilder.setCloseFile(closeFile);
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, this.userCredentialsBogus, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUuidIterator, false, requestBuilder.build(), new RPCCaller.CallGenerator<MRC.xtreemfs_update_file_sizeRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_update_file_sizeRequest input) throws IOException {
                return FileHandleImplementation.this.mrcServiceClient.xtreemfs_update_file_size(server, authHeader, userCreds, input);
            }
        });
    }

    @Override
    public String getGlobalFileId() {
        return this.getXcap().getFileId();
    }

    private StripeTranslator getStripeTranslator(GlobalTypes.StripingPolicyType type) throws IOException {
        StripeTranslator st = this.stripeTranslators.get(type);
        if (st == null) {
            throw new XtreemFSException("No StripingPolicy found for type:" + type);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAsyncXcapRenewalFinished() {
        Object object = this.xcapRenewalPendingLock;
        synchronized (object) {
            if (this.xcapRenewalPending) {
                try {
                    this.xcapRenewalPendingLock.wait();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    protected GlobalTypes.XLocSet getXlocSet() {
        return this.fileInfo.getXLocSet();
    }

    @Override
    public List<GlobalTypes.Replica> getReplicasList() {
        return this.getXlocSet().getReplicasList();
    }

    @Override
    public GlobalTypes.Replica getReplica(int replicaIndex) {
        return this.getReplicasList().get(replicaIndex);
    }

    @Override
    public GlobalTypes.StripingPolicy getStripingPolicy() {
        return this.getStripingPolicy(0);
    }

    @Override
    public GlobalTypes.StripingPolicy getStripingPolicy(int replicaIndex) {
        return this.getReplica(replicaIndex).getStripingPolicy();
    }

    @Override
    public String getReplicaUpdatePolicy() {
        return this.getXlocSet().getReplicaUpdatePolicy();
    }

    @Override
    public long getNumObjects(RPC.UserCredentials userCredentials) throws IOException, AddressToUUIDNotFoundException, PosixErrorException {
        return Helper.getNumObjects(userCredentials, this.getAttr(userCredentials), this.getStripingPolicy());
    }

    @Override
    public boolean checkAndMarkIfReadOnlyReplicaComplete(int replicaIndex, RPC.UserCredentials userCredentials) throws IOException, AddressToUUIDNotFoundException {
        GlobalTypes.Replica replica = this.getReplica(replicaIndex);
        if ((replica.getReplicationFlags() & GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber()) != 0) {
            return true;
        }
        long lastObjectNo = this.getNumObjects(userCredentials) - 1L;
        int osdRelPos = 0;
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        String fileId = Helper.extractGlobalFileIdFromXcap(fcBuilder.getXcap());
        for (String osdUUID : replica.getOsdUuidsList()) {
            UUIDIterator it = new UUIDIterator();
            it.addUUID(osdUUID);
            OSD.xtreemfs_internal_get_object_setRequest request = OSD.xtreemfs_internal_get_object_setRequest.newBuilder().setFileId(fileId).setFileCredentials(fcBuilder.build()).build();
            OSD.ObjectList ol = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, RPCAuthentication.authNone, this.volumeOptions, this.uuidResolver, it, false, request, new RPCCaller.CallGenerator<OSD.xtreemfs_internal_get_object_setRequest, OSD.ObjectList>(){

                @Override
                public RPCResponse<OSD.ObjectList> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.xtreemfs_internal_get_object_setRequest input) throws IOException, PosixErrorException {
                    return FileHandleImplementation.this.osdServiceClient.xtreemfs_internal_get_object_set(server, authHeader, userCreds, input);
                }
            });
            byte[] serializedBitSet = ol.getSet().toByteArray();
            ObjectSet oset = null;
            try {
                oset = new ObjectSet(replica.getStripingPolicy().getWidth(), osdRelPos, serializedBitSet);
            }
            catch (Exception e) {
                throw new IOException("cannot deserialize object set: " + e, e);
            }
            for (long objNo = (long)osdRelPos; objNo <= lastObjectNo; objNo += (long)replica.getStripingPolicy().getWidth()) {
                if (oset.contains(objNo)) continue;
                return false;
            }
            ++osdRelPos;
        }
        try {
            this.volume.setXAttr(userCredentials, this.fileInfo.getPath(), "xtreemfs.mark_replica_complete", replica.getOsdUuids(0), MRC.XATTR_FLAGS.XATTR_FLAGS_CREATE);
        }
        catch (IOException e) {
            Logging.logMessage(7, this, "unable to mark replica as complete: %s", e.toString());
        }
        return true;
    }

    @Override
    public int checkObjectAndGetSize(int replicaIndex, long objectNo) throws IOException, InvalidChecksumException {
        OSD.ObjectData od = null;
        Object osdRsp = null;
        try {
            GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
            fcBuilder.setXlocs(this.fileInfo.getXLocSet());
            fcBuilder.setXcap(this.getXcap());
            String fileId = Helper.extractGlobalFileIdFromXcap(fcBuilder.getXcap());
            GlobalTypes.Replica r = this.getReplica(replicaIndex);
            String objOsd = r.getOsdUuids((int)objectNo % r.getStripingPolicy().getWidth());
            UUIDIterator it = new UUIDIterator();
            it.addUUID(objOsd);
            OSD.xtreemfs_check_objectRequest request = OSD.xtreemfs_check_objectRequest.newBuilder().setFileCredentials(fcBuilder.build()).setFileId(fileId).setObjectNumber(objectNo).setObjectVersion(0L).build();
            od = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, RPCAuthentication.authNone, this.volumeOptions, this.uuidResolver, it, false, request, new RPCCaller.CallGenerator<OSD.xtreemfs_check_objectRequest, OSD.ObjectData>(){

                @Override
                public RPCResponse<OSD.ObjectData> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.xtreemfs_check_objectRequest input) throws IOException, PosixErrorException {
                    return FileHandleImplementation.this.osdServiceClient.xtreemfs_check_object(server, authHeader, userCreds, input);
                }
            });
        }
        catch (IOException e) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "IO error: %s", e.toString());
            }
            throw new IOException("operation aborted", e);
        }
        if (od.getInvalidChecksumOnOsd()) {
            throw new InvalidChecksumException("object " + objectNo + " has an invalid checksum");
        }
        return od.getZeroPadding();
    }

    @Override
    public long getSizeOnOSD() throws IOException {
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        String fileId = Helper.extractGlobalFileIdFromXcap(fcBuilder.getXcap());
        OSD.xtreemfs_internal_get_file_sizeRequest request = OSD.xtreemfs_internal_get_file_sizeRequest.newBuilder().setFileCredentials(fcBuilder.build()).setFileId(fileId).build();
        OSD.xtreemfs_internal_get_file_sizeResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, RPCAuthentication.authNone, this.volumeOptions, this.uuidResolver, this.osdUuidIterator, false, request, new RPCCaller.CallGenerator<OSD.xtreemfs_internal_get_file_sizeRequest, OSD.xtreemfs_internal_get_file_sizeResponse>(){

            @Override
            public RPCResponse<OSD.xtreemfs_internal_get_file_sizeResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.xtreemfs_internal_get_file_sizeRequest input) throws IOException, PosixErrorException {
                return FileHandleImplementation.this.osdServiceClient.xtreemfs_internal_get_file_size(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        return response.getFileSize();
    }

    @Override
    public void repairObject(int replicaIndex, long objectNo) throws IOException {
        if (this.getReplicaUpdatePolicy().equals("")) {
            throw new IOException("file must be replicated");
        }
        GlobalTypes.FileCredentials.Builder fcBuilder = GlobalTypes.FileCredentials.newBuilder();
        fcBuilder.setXlocs(this.fileInfo.getXLocSet());
        fcBuilder.setXcap(this.getXcap());
        String fileId = Helper.extractGlobalFileIdFromXcap(fcBuilder.getXcap());
        String objOsd = Helper.getOSDUUIDFromObjectNo(this.getReplica(replicaIndex), objectNo);
        UUIDIterator it = new UUIDIterator();
        it.addUUID(objOsd);
        OSD.xtreemfs_repair_objectRequest request = OSD.xtreemfs_repair_objectRequest.newBuilder().setFileCredentials(fcBuilder.build()).setFileId(fileId).setObjectNumber(objectNo).setObjectVersion(0L).build();
        Common.emptyResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, RPCAuthentication.userService, RPCAuthentication.authNone, this.volumeOptions, this.uuidResolver, it, false, request, new RPCCaller.CallGenerator<OSD.xtreemfs_repair_objectRequest, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.xtreemfs_repair_objectRequest input) throws IOException, PosixErrorException {
                return FileHandleImplementation.this.osdServiceClient.xtreemfs_repair_object(server, authHeader, userCreds, input);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewXLocSet() throws PosixErrorException, InternalServerErrorException, IOException {
        GlobalTypes.XLocSet xLocSetToRenew = this.fileInfo.getXLocSet();
        Object object = this.fileInfo.xLocSetRenewalLock;
        synchronized (object) {
            GlobalTypes.XLocSet xLocSetCurrent = this.fileInfo.getXLocSet();
            if (xLocSetCurrent.getVersion() <= xLocSetToRenew.getVersion()) {
                GlobalTypes.XCap xCap = this.getXcap();
                MRC.xtreemfs_get_xlocsetRequest request = MRC.xtreemfs_get_xlocsetRequest.newBuilder().setXcap(xCap).build();
                GlobalTypes.XLocSet newXLocSet = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, this.userCredentialsBogus, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUuidIterator, false, false, 1, request, new RPCCaller.CallGenerator<MRC.xtreemfs_get_xlocsetRequest, GlobalTypes.XLocSet>(){

                    @Override
                    public RPCResponse<GlobalTypes.XLocSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_get_xlocsetRequest input) throws IOException, PosixErrorException {
                        return FileHandleImplementation.this.mrcServiceClient.xtreemfs_get_xlocset(server, authHeader, userCreds, input);
                    }
                });
                this.fileInfo.updateXLocSetAndRest(newXLocSet);
            }
        }
    }

    private abstract class ViewCheckedOperation<T> {
        private ViewCheckedOperation() {
        }

        T execute() throws IOException {
            int maxTries = FileHandleImplementation.this.volumeOptions.getMaxViewRenewals();
            int attempt = 0;
            while (++attempt <= maxTries || maxTries == 0) {
                try {
                    return this.doOperation();
                }
                catch (InvalidViewException e) {
                    if (attempt == maxTries && maxTries > 0) {
                        String errorMsg = e.getMessage() + " Request finally failed after " + attempt + " attempts";
                        throw new InvalidViewException(errorMsg);
                    }
                    RPCCaller.waitDelay(FileHandleImplementation.this.volumeOptions.getRetryDelay_s());
                    FileHandleImplementation.this.renewXLocSet();
                }
            }
            throw new InvalidViewException("The operation did fail due to an outdated view after " + attempt + " attempts.");
        }

        abstract T doOperation() throws IOException;
    }
}

