/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.xtreemfs.common.libxtreemfs.AsyncWriteBuffer;
import org.xtreemfs.common.libxtreemfs.AsyncWriteHandler;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.common.libxtreemfs.FileHandleImplementation;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.Tupel;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.VolumeImplementation;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class FileInfo {
    private VolumeImplementation volume;
    long fileId;
    private String path;
    private final Object pathLock;
    boolean replicateOnClose;
    private AtomicInteger referenceCount;
    private GlobalTypes.XLocSet xlocset;
    Object xLocSetLock;
    Object xLocSetRenewalLock;
    private UUIDIterator osdUuidIterator;
    private ConcurrentHashMap<Integer, OSD.Lock> activeLocks;
    private String clientUuid;
    private ConcurrentLinkedQueue<FileHandleImplementation> openFileHandles;
    private List<FileHandle> pendingFilesizeUpdates;
    private GlobalTypes.OSDWriteResponse osdWriteResponse;
    private FilesizeUpdateStatus osdWriteResponseStatus;
    private GlobalTypes.XCap osdWriteResponseXcap;
    private final Object osdWriteResponseLock;
    AsyncWriteHandler asyncWriteHandler;

    public FileInfo(VolumeImplementation volume, long fileId, String path, boolean replicateOnClose, GlobalTypes.XLocSet xlocset, String clientUuid) {
        this.volume = volume;
        this.fileId = fileId;
        this.path = path;
        this.replicateOnClose = replicateOnClose;
        this.xlocset = xlocset;
        this.clientUuid = clientUuid;
        this.referenceCount = new AtomicInteger(0);
        this.osdWriteResponse = null;
        this.osdWriteResponseStatus = FilesizeUpdateStatus.kClean;
        this.osdWriteResponseLock = new Object();
        this.pathLock = new Object();
        this.xLocSetLock = new Object();
        this.xLocSetRenewalLock = new Object();
        this.openFileHandles = new ConcurrentLinkedQueue();
        this.activeLocks = new ConcurrentHashMap();
        this.osdUuidIterator = new UUIDIterator();
        this.osdUuidIterator.addUUIDs(Helper.getOSDUUIDsFromXlocSet(xlocset));
        this.asyncWriteHandler = new AsyncWriteHandler(this, this.osdUuidIterator, volume.getUUIDResolver(), volume.getOsdServiceClient(), volume.getAuthBogus(), volume.getUserCredentialsBogus(), volume.getOptions().getMaxWriteahead(), volume.getOptions().getMaxWriteaheadRequests(), volume.getOptions().getMaxWriteTries());
        this.pendingFilesizeUpdates = new ArrayList<FileHandle>(volume.getOptions().getMaxWriteahead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateXLocSetAndRest(GlobalTypes.XLocSet newXlocset, boolean replicateOnClose) {
        Object object = this.xLocSetLock;
        synchronized (object) {
            this.xlocset = GlobalTypes.XLocSet.newBuilder(newXlocset).build();
            this.replicateOnClose = replicateOnClose;
        }
        this.osdUuidIterator.clearAndAddUUIDs(Helper.getOSDUUIDsFromXlocSet(newXlocset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateXLocSetAndRest(GlobalTypes.XLocSet newXlocset) {
        Object object = this.xLocSetLock;
        synchronized (object) {
            this.xlocset = GlobalTypes.XLocSet.newBuilder(newXlocset).build();
        }
        this.osdUuidIterator.clearAndAddUUIDs(Helper.getOSDUUIDsFromXlocSet(newXlocset));
    }

    FileHandleImplementation createFileHandle(GlobalTypes.XCap xcap, boolean asyncWritesEnabled) {
        return this.createFileHandle(xcap, asyncWritesEnabled, false);
    }

    FileHandleImplementation createFileHandle(GlobalTypes.XCap xcap, boolean asyncWritesEnabled, boolean usedForPendingFilesizeUpdate) {
        FileHandleImplementation fileHandleImplementation = new FileHandleImplementation(this.volume, this.clientUuid, this, xcap, this.volume.getMrcUuidIterator(), this.osdUuidIterator, this.volume.getUUIDResolver(), this.volume.getMrcServiceClient(), this.volume.getOsdServiceClient(), this.volume.getStripeTranslators(), asyncWritesEnabled, this.volume.getOptions(), this.volume.getAuthBogus(), this.volume.getUserCredentialsBogus());
        this.referenceCount.incrementAndGet();
        this.openFileHandles.add(fileHandleImplementation);
        return fileHandleImplementation;
    }

    protected void closeFileHandle(FileHandleImplementation fileHandle) {
        this.openFileHandles.remove(fileHandle);
        this.volume.closeFile(this.fileId, this, fileHandle);
    }

    protected int decreaseReferenceCount() {
        int count = this.referenceCount.decrementAndGet();
        assert (count >= 0);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlobalTypes.OSDWriteResponse getOSDWriteResponse() {
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (this.osdWriteResponse == null) {
                return null;
            }
            return this.osdWriteResponse.toBuilder().build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPath() {
        Object object = this.pathLock;
        synchronized (object) {
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renamePath(String path, String newPath) {
        Object object = this.pathLock;
        synchronized (object) {
            if (this.path.equals(path)) {
                this.path = newPath;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryToUpdateOSDWriteResponse(GlobalTypes.OSDWriteResponse response, GlobalTypes.XCap xcap) {
        assert (response != null);
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (Helper.compareOSDWriteResponses(response, this.osdWriteResponse) == 1) {
                this.osdWriteResponse = response.toBuilder().build();
                this.osdWriteResponseXcap = xcap.toBuilder().build();
                this.osdWriteResponseStatus = FilesizeUpdateStatus.kDirty;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MRC.Stat mergeStatAndOSDWriteResponse(MRC.Stat stat) {
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (this.osdWriteResponse != null && (stat.getTruncateEpoch() < this.osdWriteResponse.getTruncateEpoch() || stat.getTruncateEpoch() == this.osdWriteResponse.getTruncateEpoch() && stat.getSize() < this.osdWriteResponse.getSizeInBytes())) {
                stat = stat.toBuilder().setSize(this.osdWriteResponse.getSizeInBytes()).setTruncateEpoch(this.osdWriteResponse.getTruncateEpoch()).build();
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "getattr: merged infos from osdWriteResponse, size: %s", stat.getSize());
                }
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBackFileSizeAsync() throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (this.osdWriteResponse != null && this.osdWriteResponseStatus == FilesizeUpdateStatus.kDirty) {
                FileHandleImplementation fileHandle = this.createFileHandle(this.osdWriteResponseXcap, false, true);
                this.pendingFilesizeUpdates.add(fileHandle);
                this.osdWriteResponseStatus = FilesizeUpdateStatus.kDirtyAndAsyncPending;
                fileHandle.setOsdWriteResponseForAsyncWriteBack(this.osdWriteResponse);
                fileHandle.writeBackFileSizeAsync();
            }
        }
    }

    protected void renewXCapsAsync() throws AddressToUUIDNotFoundException {
        block3: {
            Iterator<FileHandleImplementation> fhiIterator = this.openFileHandles.iterator();
            try {
                while (fhiIterator.hasNext()) {
                    fhiIterator.next().renewXCapAsync();
                }
            }
            catch (IOException ioe) {
                if (!Logging.isDebug()) break block3;
                Logging.logMessage(7, Logging.Category.misc, this, "renewXcapsSync: Failed to renew XCap for fileHandles. Reason: %s", ioe.getCause());
            }
        }
    }

    protected void releaseLockOfProcess(FileHandleImplementation fileHandle, int processId) throws PosixErrorException, AddressToUUIDNotFoundException {
        block3: {
            OSD.Lock lock = this.activeLocks.get(processId);
            if (lock != null) {
                try {
                    fileHandle.releaseLock(lock);
                }
                catch (IOException ioe) {
                    if (!Logging.isDebug()) break block3;
                    Logging.logMessage(7, Logging.Category.misc, this, "releaseLock: Failed to release Lock for processID: %s. Reason: %s", processId, ioe.getCause());
                }
            }
        }
    }

    protected void releaseAllLocks(FileHandleImplementation fileHandle) throws PosixErrorException, AddressToUUIDNotFoundException {
        for (OSD.Lock lock : this.activeLocks.values()) {
            try {
                fileHandle.releaseLock(lock);
            }
            catch (IOException ioe) {
                if (!Logging.isDebug()) continue;
                Logging.logMessage(7, Logging.Category.misc, this, "releaseAllLocks: Failed to release for some Locks. Reason: %s", ioe.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForPendingFileSizeUpdates() {
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            while (this.pendingFilesizeUpdates.size() > 0) {
                try {
                    this.osdWriteResponseLock.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncFileSizeUpdateResponseHandler(GlobalTypes.OSDWriteResponse owr, FileHandleImplementation fileHandle, boolean success) {
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (Helper.compareOSDWriteResponses(owr, this.osdWriteResponse) == 0) {
                assert (this.osdWriteResponseStatus == FilesizeUpdateStatus.kDirtyAndAsyncPending);
                this.osdWriteResponseStatus = success ? FilesizeUpdateStatus.kClean : FilesizeUpdateStatus.kDirty;
            }
            this.pendingFilesizeUpdates.remove(fileHandle);
            this.decreaseReferenceCount();
            if (this.pendingFilesizeUpdates.size() == 0) {
                this.osdWriteResponseLock.notifyAll();
            }
        }
    }

    protected Tupel<OSD.Lock, boolean[]> checkLock(OSD.Lock lock) {
        assert (lock.getClientUuid().equals(this.clientUuid));
        boolean conflictFound = false;
        boolean lockForPidCached = false;
        boolean cachedLockForPidEqual = false;
        OSD.Lock conflictionLock = null;
        for (Map.Entry<Integer, OSD.Lock> entry : this.activeLocks.entrySet()) {
            if (entry.getKey().intValue() == lock.getClientPid()) {
                lockForPidCached = true;
                if (!Helper.checkIfLocksAreEqual(lock, entry.getValue())) continue;
                cachedLockForPidEqual = true;
                continue;
            }
            if (!Helper.checkIfLocksDoConflict(lock, entry.getValue())) continue;
            conflictFound = true;
            conflictionLock = entry.getValue();
            break;
        }
        boolean[] bools = new boolean[]{conflictFound, lockForPidCached, cachedLockForPidEqual};
        return new Tupel<Object, boolean[]>(conflictionLock, bools);
    }

    protected boolean checkIfProcessHasLocks(int processId) {
        return this.activeLocks.containsKey(processId);
    }

    protected void putLock(OSD.Lock lock) {
        assert (lock.getClientUuid().equals(this.clientUuid));
        this.activeLocks.remove(lock.getClientPid());
        OSD.Lock newLock = lock.toBuilder().build();
        this.activeLocks.put(newLock.getClientPid(), newLock);
    }

    protected void delLock(OSD.Lock lock) {
        assert (lock.getClientUuid().equals(this.clientUuid));
        this.activeLocks.remove(lock.getClientPid());
    }

    protected void flush(FileHandleImplementation fileHandle) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.flush(fileHandle, false);
    }

    protected void flush(FileHandleImplementation fileHandle, boolean closeFile) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.waitForPendingAsyncWrites();
        this.flushPendingFileSizeUpdate(fileHandle, closeFile);
    }

    protected void flushPendingFileSizeUpdate(FileHandleImplementation fileHandle) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.flushPendingFileSizeUpdate(fileHandle, false);
    }

    void asyncWrite(AsyncWriteBuffer writeBuffer) throws XtreemFSException {
        this.asyncWriteHandler.write(writeBuffer);
    }

    protected void waitForPendingAsyncWrites() {
        this.asyncWriteHandler.waitForPendingWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingFileSizeUpdate(FileHandleImplementation fileHandle, boolean closeFile) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        GlobalTypes.OSDWriteResponse responseCopy = null;
        Object object = this.osdWriteResponseLock;
        synchronized (object) {
            if (this.osdWriteResponse != null) {
                this.waitForPendingFileSizeUpdates();
                if (this.osdWriteResponseStatus != FilesizeUpdateStatus.kDirty) {
                    return;
                }
            } else {
                return;
            }
            this.osdWriteResponseStatus = FilesizeUpdateStatus.kDirtyAndSyncPending;
            responseCopy = this.osdWriteResponse.toBuilder().build();
        }
        try {
            fileHandle.writeBackFileSize(responseCopy, closeFile);
        }
        catch (IOException e) {
            this.osdWriteResponseStatus = FilesizeUpdateStatus.kDirty;
            throw e;
        }
        object = this.osdWriteResponseLock;
        synchronized (object) {
            if (Helper.compareOSDWriteResponses(this.osdWriteResponse, responseCopy) == 0) {
                this.osdWriteResponseStatus = FilesizeUpdateStatus.kClean;
            }
            boolean replicateOnCloseValue = false;
            Object object2 = this.xLocSetLock;
            synchronized (object2) {
                replicateOnCloseValue = this.replicateOnClose;
            }
            if (closeFile && replicateOnCloseValue) {
                fileHandle.writeBackFileSize(GlobalTypes.OSDWriteResponse.getDefaultInstance(), closeFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlobalTypes.XLocSet getXLocSet() {
        Object object = this.xLocSetLock;
        synchronized (object) {
            return this.xlocset.toBuilder().build();
        }
    }

    static enum FilesizeUpdateStatus {
        kClean,
        kDirty,
        kDirtyAndAsyncPending,
        kDirtyAndSyncPending;

    }
}

