/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class Helper {
    public static String generateVersion4UUID() {
        char[] set = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        String uuid = "";
        int[] block_length = new int[]{8, 4, 4, 4, 12};
        Random generator = new Random();
        for (int i = 0; i < block_length.length; ++i) {
            for (int j = 0; j < block_length[i]; ++j) {
                uuid = uuid + set[generator.nextInt(62)];
            }
        }
        assert (uuid.length() == 32);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, new Helper(), "Generated client UUID: %s", uuid);
        }
        return uuid;
    }

    protected static InetSocketAddress stringToInetSocketAddress(String address, int defaultPort) {
        int pos = 0;
        pos = address.indexOf(58);
        InetSocketAddress isa = pos == -1 ? new InetSocketAddress(address, defaultPort) : new InetSocketAddress(address.substring(0, pos), Integer.parseInt(address.substring(pos + 1)));
        return isa;
    }

    public static String getOSDUUIDFromObjectNo(GlobalTypes.Replica replica, long objectNo) {
        return replica.getOsdUuids((int)objectNo % replica.getStripingPolicy().getWidth());
    }

    public static String getOSDUUIDFromXlocSet(GlobalTypes.XLocSet xlocs, int replicaIndex, int stripeIndex) {
        if (xlocs.getReplicasCount() == 0) {
            Logging.logMessage(3, Logging.Category.misc, xlocs, "getOSDUUIDFromXlocSet: Empty replicas list in XlocSet: %s", xlocs.toString());
            return "";
        }
        GlobalTypes.Replica replica = xlocs.getReplicas(replicaIndex);
        if (replica.getOsdUuidsCount() == 0) {
            Logging.logMessage(3, Logging.Category.misc, xlocs, "GetOSDUUIDFromXlocSet: No head OSD available in XlocSet: %s", xlocs.toString());
            return "";
        }
        return replica.getOsdUuids(stripeIndex);
    }

    public static String getOSDUUIDFromXlocSet(GlobalTypes.XLocSet xlocs) {
        return Helper.getOSDUUIDFromXlocSet(xlocs, 0, 0);
    }

    public static List<String> getOSDUUIDsFromXlocSet(GlobalTypes.XLocSet xlocs) {
        ArrayList<String> uuids = new ArrayList<String>(xlocs.getReplicasCount());
        for (int i = 0; i < xlocs.getReplicasCount(); ++i) {
            uuids.add(xlocs.getReplicas(i).getOsdUuids(0));
        }
        return uuids;
    }

    public static long extractFileIdFromXcap(GlobalTypes.XCap xcap) {
        String fileId = xcap.getFileId();
        int start = fileId.indexOf(58);
        return Long.parseLong(fileId.substring(start + 1, fileId.length()));
    }

    public static String extractGlobalFileIdFromXcap(GlobalTypes.XCap xcap) {
        return xcap.getFileId();
    }

    public static String resolveParentDirectory(String path) {
        path = Helper.setLeadingSlashIfMissing(path);
        int lastSlash = path.lastIndexOf(47);
        if (path.equals("/") || lastSlash == 0) {
            return "/";
        }
        assert (lastSlash != path.length() - 1);
        return path.substring(0, lastSlash);
    }

    private static String setLeadingSlashIfMissing(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    protected static long getNumObjects(RPC.UserCredentials userCredentials, MRC.Stat fileAttr, GlobalTypes.StripingPolicy stripingPolicy) throws IOException, AddressToUUIDNotFoundException, PosixErrorException {
        long fileSize = fileAttr.getSize();
        if (fileSize > 0L) {
            int stripeSize = stripingPolicy.getStripeSize() * 1024;
            return (fileSize - 1L) / (long)stripeSize + 1L;
        }
        return 0L;
    }

    public static String getBasename(String path) {
        path = Helper.setLeadingSlashIfMissing(path);
        int lastSlash = path.lastIndexOf(47);
        if (path.equals("/")) {
            return path;
        }
        assert (lastSlash != path.length() - 1);
        return path.substring(lastSlash + 1);
    }

    public static String concatenatePath(String directory, String file) {
        directory = Helper.setLeadingSlashIfMissing(directory);
        if (file.equals(".")) {
            return directory;
        }
        if (file.equals("..")) {
            if (directory.equals("/")) {
                return "/";
            }
            return directory.substring(0, directory.lastIndexOf(47));
        }
        if (directory.endsWith("/")) {
            return directory + file;
        }
        return directory + "/" + file;
    }

    protected static int compareOSDWriteResponses(GlobalTypes.OSDWriteResponse newResponse, GlobalTypes.OSDWriteResponse currentResponse) {
        if (newResponse == null && currentResponse == null) {
            return 0;
        }
        if (newResponse != null && currentResponse == null) {
            return 1;
        }
        if (newResponse == null && currentResponse != null) {
            return -1;
        }
        if (newResponse.getTruncateEpoch() > currentResponse.getTruncateEpoch() || newResponse.getTruncateEpoch() == currentResponse.getTruncateEpoch() && newResponse.getSizeInBytes() > currentResponse.getSizeInBytes()) {
            return 1;
        }
        if (newResponse.getTruncateEpoch() < currentResponse.getTruncateEpoch() || newResponse.getTruncateEpoch() == currentResponse.getTruncateEpoch() && newResponse.getSizeInBytes() < currentResponse.getSizeInBytes()) {
            return -1;
        }
        return 0;
    }

    protected static boolean checkIfLocksAreEqual(OSD.Lock lock1, OSD.Lock lock2) {
        return lock1.getClientUuid().equals(lock2.getClientUuid()) && lock1.getClientPid() == lock2.getClientPid() && lock1.getOffset() == lock2.getOffset() && lock1.getLength() == lock2.getLength();
    }

    protected static boolean checkIfLocksDoConflict(OSD.Lock lock1, OSD.Lock lock2) {
        long lock2End;
        long lock1End = lock1.getLength() == 0L ? 0L : lock1.getLength() + lock1.getOffset();
        long l = lock2End = lock2.getLength() == 0L ? 0L : lock2.getLength() + lock2.getOffset();
        if (lock1End == 0L && (lock2End >= lock1.getOffset() || lock2End == 0L)) {
            return true;
        }
        if (lock2End == 0L && (lock1End >= lock2.getOffset() || lock1End == 0L)) {
            return true;
        }
        if (lock1End >= lock2.getOffset() && lock2End >= lock1.getOffset()) {
            return lock1.getExclusive() || lock2.getExclusive();
        }
        return false;
    }

    public static String policiesToString(GlobalTypes.OSDSelectionPolicyType[] policies) {
        StringBuffer policiesSB = new StringBuffer();
        boolean firstEntry = true;
        for (GlobalTypes.OSDSelectionPolicyType policy : policies) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                policiesSB.append(",");
            }
            policiesSB.append(String.valueOf(policy.getNumber()));
        }
        return policiesSB.toString();
    }

    public static int flagsToInt(GlobalTypes.SYSTEM_V_FCNTL ... flags) {
        int flagsInt = 0;
        for (GlobalTypes.SYSTEM_V_FCNTL flag : flags) {
            flagsInt |= flag.getNumber();
        }
        return flagsInt;
    }
}

