/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.xtreemfs.common.libxtreemfs.MetadataCacheEntry;
import org.xtreemfs.common.libxtreemfs.Tupel;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class MetadataCache {
    private final long maxNumberOfEntries;
    private final long ttlS;
    private boolean enabled;
    private final LinkedHashMap<String, MetadataCacheEntry> cache;
    private final SortedSet<String> pathIndex;
    private final ReadWriteLock readWriteLock;
    private final Lock writeLock;
    private final Lock readLock;

    protected MetadataCache(long maxNumberOfEntries, long ttlS) {
        this.maxNumberOfEntries = maxNumberOfEntries;
        this.ttlS = ttlS;
        this.enabled = maxNumberOfEntries > 0L;
        this.cache = new LinkedHashMap();
        this.pathIndex = new TreeSet<String>();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.readLock = this.readWriteLock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(String path) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.remove(path);
            this.pathIndex.remove(path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidatePrefix(String path) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        ArrayList<String> indicesToRemove = new ArrayList<String>();
        this.writeLock.lock();
        try {
            String deletePath;
            this.cache.remove(path);
            this.pathIndex.remove(path);
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            Iterator i$ = this.pathIndex.tailSet(path).iterator();
            while (i$.hasNext() && (deletePath = (String)i$.next()).startsWith(path)) {
                this.cache.remove(deletePath);
                indicesToRemove.add(deletePath);
            }
            this.pathIndex.removeAll(indicesToRemove);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renamePrefix(String path, String newPath) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        TreeSet<String> tempPaths = new TreeSet<String>();
        this.writeLock.lock();
        try {
            String renamePath;
            MetadataCacheEntry entry = (MetadataCacheEntry)this.cache.remove(path);
            this.cache.put(newPath, entry);
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!newPath.endsWith("/")) {
                newPath = newPath + "/";
            }
            Iterator i$ = this.pathIndex.tailSet(path).iterator();
            while (i$.hasNext() && (renamePath = (String)i$.next()).startsWith(path)) {
                entry = (MetadataCacheEntry)this.cache.remove(renamePath);
                this.cache.put(renamePath.replaceFirst(path, newPath), entry);
                tempPaths.add(renamePath.replaceFirst(path, newPath));
            }
            for (String tmpPath : tempPaths) {
                this.pathIndex.remove(tmpPath);
                this.pathIndex.add(tmpPath.replace(path, newPath));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MRC.Stat getStat(String path) {
        if (path.isEmpty() || !this.enabled) {
            return null;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                assert (entry.getStat() == null || entry.getStat().getNlink() == 1);
                long currentTimeS = System.currentTimeMillis() / 1000L;
                if (entry.getStatTimeoutS() >= currentTimeS) {
                    MRC.Stat stat = entry.getStat();
                    return stat;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getStat expired: %s", path);
                }
                if (entry.getTimeoutS() < currentTimeS) {
                    this.cache.remove(path);
                    this.pathIndex.remove(path);
                }
            } else if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getStat miss: ", this.cache.size());
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStat(String path, MRC.Stat stat) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = (MetadataCacheEntry)this.cache.remove(path);
            if (entry == null) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache: registering %s", path);
                }
                entry = new MetadataCacheEntry();
                this.pathIndex.add(path);
            }
            entry.setStat(stat);
            entry.setStatTimeoutS(System.currentTimeMillis() / 1000L + this.ttlS);
            entry.setTimeoutS(entry.getStatTimeoutS());
            this.evictUnmutexed(1);
            this.cache.put(path, entry);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatTime(String path, long timestampS, int toSet) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                if (entry.getStat() == null) {
                    return;
                }
                MRC.Stat.Builder newStat = entry.getStat().toBuilder();
                long timeNS = timestampS * 1000000000L;
                if ((toSet & MRC.Setattrs.SETATTR_ATIME.getNumber()) > 0 && timeNS > entry.getStat().getAtimeNs()) {
                    newStat.setAtimeNs(timeNS);
                }
                if ((toSet & MRC.Setattrs.SETATTR_MTIME.getNumber()) > 0 && timeNS > entry.getStat().getMtimeNs()) {
                    newStat.setMtimeNs(timeNS);
                }
                if ((toSet & MRC.Setattrs.SETATTR_CTIME.getNumber()) > 0 && timeNS > entry.getStat().getCtimeNs()) {
                    newStat.setCtimeNs(timeNS);
                }
                entry.setStat(newStat.build());
                entry.setStatTimeoutS(System.currentTimeMillis() / 1000L + this.ttlS);
                entry.setTimeoutS(entry.getStatTimeoutS());
                this.cache.remove(path);
                this.cache.put(path, entry);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatAttributes(String path, MRC.Stat stat, int toSet) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                if (entry.getStat() == null) {
                    return;
                }
                MRC.Stat.Builder statBuilder = entry.getStat().toBuilder();
                if ((toSet & MRC.Setattrs.SETATTR_ATTRIBUTES.getNumber()) > 0) {
                    statBuilder.setAttributes(stat.getAttributes());
                }
                if ((toSet & MRC.Setattrs.SETATTR_MODE.getNumber()) > 0) {
                    statBuilder.setMode(statBuilder.getMode() & 0xFFFFF000 | stat.getMode() & 0xFFF);
                }
                if ((toSet & MRC.Setattrs.SETATTR_UID.getNumber()) > 0) {
                    statBuilder.setUserId(stat.getUserId());
                }
                if ((toSet & MRC.Setattrs.SETATTR_GID.getNumber()) > 0) {
                    statBuilder.setGroupId(stat.getGroupId());
                }
                if ((toSet & MRC.Setattrs.SETATTR_SIZE.getNumber()) > 0) {
                    if (stat.hasTruncateEpoch() && stat.getTruncateEpoch() > statBuilder.getTruncateEpoch()) {
                        statBuilder.setSize(stat.getSize());
                        statBuilder.setTruncateEpoch(stat.getTruncateEpoch());
                    } else if (stat.hasTruncateEpoch() && stat.getTruncateEpoch() == statBuilder.getTruncateEpoch() && stat.getSize() > statBuilder.getSize()) {
                        statBuilder.setSize(stat.getSize());
                    }
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache UpdateStatAttributes SETATTR_SIZE: new size: %s truncate epoch: %s", statBuilder.getSize(), statBuilder.getTruncateEpoch());
                    }
                }
                if ((toSet & MRC.Setattrs.SETATTR_ATIME.getNumber()) > 0) {
                    statBuilder.setAtimeNs(stat.getAtimeNs());
                }
                if ((toSet & MRC.Setattrs.SETATTR_MTIME.getNumber()) > 0) {
                    statBuilder.setMtimeNs(stat.getMtimeNs());
                }
                if ((toSet & MRC.Setattrs.SETATTR_CTIME.getNumber()) > 0) {
                    statBuilder.setCtimeNs(stat.getCtimeNs());
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache UpdateStatAttributes: %s toSet: %s", path, toSet);
                }
                entry.setStat(statBuilder.build());
                entry.setStatTimeoutS(System.currentTimeMillis() / 1000L + this.ttlS);
                entry.setTimeoutS(entry.getStatTimeoutS());
                this.cache.remove(path);
                this.cache.put(path, entry);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatFromOSDWriteResponse(String path, GlobalTypes.OSDWriteResponse response) {
        if (path.isEmpty() || !this.enabled || !response.hasSizeInBytes() || !response.hasTruncateEpoch()) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                if (entry.getStat() == null) {
                    return;
                }
                MRC.Stat.Builder statBuilder = entry.getStat().toBuilder();
                if (response.getTruncateEpoch() > statBuilder.getTruncateEpoch() || response.getTruncateEpoch() == statBuilder.getTruncateEpoch() && response.getSizeInBytes() > statBuilder.getSize()) {
                    statBuilder.setSize(response.getSizeInBytes());
                    statBuilder.setTruncateEpoch(response.getTruncateEpoch());
                    entry.setStat(statBuilder.build());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MRC.DirectoryEntries getDirEntries(String path, int offset, int count) {
        if (path.isEmpty() || !this.enabled) {
            return null;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null && entry.getDirectoryEntries() != null) {
                long currentTimeS = System.currentTimeMillis() / 1000L;
                if (entry.getDirectoryEntriesTimeoutS() >= currentTimeS) {
                    MRC.DirectoryEntries.Builder result;
                    if (offset == 0 && count >= entry.getDirectoryEntries().getEntriesCount()) {
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getDirEntries() hit: %s [%s]", path, this.cache.size());
                        }
                        result = entry.getDirectoryEntries().toBuilder();
                    } else {
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getDirectoryEntries() hit (partial copy): %s [%s] offset: %s", path, this.cache.size(), offset);
                        }
                        result = MRC.DirectoryEntries.newBuilder();
                        for (int i = offset; i < offset + count; ++i) {
                            result.addEntries(entry.getDirectoryEntries().getEntries(i));
                        }
                    }
                    MRC.DirectoryEntries directoryEntries = result.build();
                    return directoryEntries;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache entry expired: %s", path);
                }
                if (entry.getTimeoutS() < currentTimeS) {
                    this.cache.remove(path);
                    this.pathIndex.remove(path);
                }
                MRC.DirectoryEntries directoryEntries = null;
                return directoryEntries;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getDirectoryEntries() miss: %s", path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateStat(String path) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                entry.setStat(null);
                entry.setStatTimeoutS(0L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDirEntries(String path, MRC.DirectoryEntries dirEntries) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            boolean created = false;
            if (entry == null) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache updateDirEntries(): new entry for path %s", path);
                }
                entry = new MetadataCacheEntry();
                entry.setPath(path);
                created = true;
            }
            entry.setDirectoryEntries(dirEntries);
            entry.setDirectoryEntriesTimeoutS(System.currentTimeMillis() / 1000L + this.ttlS);
            entry.setTimeoutS(entry.getDirectoryEntriesTimeoutS());
            if (created) {
                this.evictUnmutexed(1);
                this.pathIndex.add(path);
                this.cache.put(path, entry);
            } else {
                this.cache.remove(path);
                this.cache.put(path, entry);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateDirEntry(String pathToDirectory, String entryName) {
        if (pathToDirectory.isEmpty() || entryName.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(pathToDirectory);
            if (entry != null) {
                if (entry.getDirectoryEntries() == null) {
                    return;
                }
                MRC.DirectoryEntries.Builder dirEntriesBuilder = MRC.DirectoryEntries.newBuilder();
                for (int i = 0; i < entry.getDirectoryEntries().getEntriesCount(); ++i) {
                    if (entry.getDirectoryEntries().getEntries(i).getName().equals(entryName)) continue;
                    dirEntriesBuilder.addEntries(entry.getDirectoryEntries().getEntries(i));
                }
                entry.setDirectoryEntries(dirEntriesBuilder.build());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateDirEntries(String path) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                entry.setDirectoryEntries(null);
                entry.setDirectoryEntriesTimeoutS(0L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tupel<String, Boolean> getXAttr(String path, String name) {
        boolean xattrsCached;
        block12: {
            xattrsCached = false;
            if (path.isEmpty() || !this.enabled) {
                return new Tupel<Object, Boolean>(null, xattrsCached);
            }
            this.writeLock.lock();
            try {
                MetadataCacheEntry entry = this.cache.get(path);
                long currentTimeMS = System.currentTimeMillis() / 1000L;
                if (entry == null || entry.getXattrs() == null) break block12;
                if (entry.getXattrTimeoutS() >= currentTimeMS) {
                    xattrsCached = true;
                    for (MRC.XAttr xattr : entry.getXattrs().getXattrsList()) {
                        if (!xattr.getName().equals(name)) continue;
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattr() hit: %s [%s]", path, this.cache.size());
                        }
                        Tupel<String, Boolean> tupel = new Tupel<String, Boolean>(xattr.getValue(), xattrsCached);
                        return tupel;
                    }
                    Tupel<Object, Boolean> tupel = new Tupel<Object, Boolean>(null, xattrsCached);
                    return tupel;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattr() expired: %s", path);
                }
                if (entry.getTimeoutS() < currentTimeMS) {
                    this.cache.remove(path);
                    this.pathIndex.remove(path);
                }
                Tupel<Object, Boolean> tupel = new Tupel<Object, Boolean>(null, xattrsCached);
                return tupel;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattr() miss: %s [%s]", path, this.cache.size());
        }
        return new Tupel<Object, Boolean>(null, xattrsCached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tupel<Integer, Boolean> getXAttrSize(String path, String name) {
        boolean xattrCached;
        block10: {
            xattrCached = false;
            this.writeLock.lock();
            try {
                MetadataCacheEntry entry = this.cache.get(path);
                long currentTimeS = System.currentTimeMillis() / 1000L;
                if (entry == null || entry.getXattrs() == null) break block10;
                if (entry.getXattrTimeoutS() >= currentTimeS) {
                    xattrCached = true;
                    for (MRC.XAttr xattr : entry.getXattrs().getXattrsList()) {
                        if (!xattr.getName().equals(name)) continue;
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrSize() hit: %s [%s]", path, this.cache.size());
                        }
                        Tupel<Integer, Boolean> tupel = new Tupel<Integer, Boolean>(xattr.getValue().length(), xattrCached);
                        return tupel;
                    }
                    break block10;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrSize() expired: %s", path);
                }
                if (entry.getTimeoutS() < currentTimeS) {
                    this.cache.remove(path);
                    this.pathIndex.remove(path);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrSize() miss: %s [%s]", path, this.cache.size());
        }
        return new Tupel<Integer, Boolean>(0, xattrCached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MRC.listxattrResponse getXAttrs(String path) {
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            long currentTimeS = System.currentTimeMillis() / 1000L;
            if (entry != null && entry.getXattrs() != null) {
                if (entry.getXattrTimeoutS() >= currentTimeS) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrs() hit: %s [%s]", path, this.cache.size());
                    }
                    MRC.listxattrResponse listxattrResponse2 = entry.getXattrs();
                    return listxattrResponse2;
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrs() expired: %s", path, this.cache.size());
                }
                if (entry.getTimeoutS() < currentTimeS) {
                    this.cache.remove(path);
                    this.pathIndex.remove(path);
                }
                MRC.listxattrResponse listxattrResponse3 = null;
                return listxattrResponse3;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache getXattrs() miss %s [%s]", path, this.cache.size());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateXAttr(String path, String name, String value) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry == null) {
                return;
            }
            if (entry.getXattrs() == null) {
                return;
            }
            long currentTimeS = System.currentTimeMillis() / 1000L;
            if (entry.getXattrTimeoutS() < currentTimeS) {
                return;
            }
            MRC.listxattrResponse.Builder newXattrs = entry.getXattrs().toBuilder();
            boolean nameFound = false;
            for (int i = 0; i < newXattrs.getXattrsList().size(); ++i) {
                if (!newXattrs.getXattrs(i).getName().equals(name)) continue;
                nameFound = true;
                MRC.XAttr.Builder xattr = newXattrs.getXattrs(i).toBuilder();
                xattr.setValue(value);
                newXattrs.setXattrs(i, xattr.build());
                break;
            }
            if (!nameFound) {
                newXattrs.addXattrs(MRC.XAttr.newBuilder().setName(name).setValue(value).build());
            }
            entry.setXattrs(newXattrs.build());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateXAttrs(String path, MRC.listxattrResponse xattrs) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry == null) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache updateXattrs: new entry for path %s", path);
                }
                entry = new MetadataCacheEntry();
                entry.setPath(path);
            }
            entry.setXattrs(xattrs);
            entry.setXattrTimeoutS(System.currentTimeMillis() / 1000L + this.ttlS);
            entry.setTimeoutS(entry.getXattrTimeoutS());
            if (this.cache.remove(path) == null) {
                this.pathIndex.add(path);
            }
            this.cache.put(path, entry);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateXAttr(String path, String name) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry == null) {
                return;
            }
            if (entry.getXattrs() == null) {
                return;
            }
            long currentTimeS = System.currentTimeMillis() / 1000L;
            if (entry.getXattrTimeoutS() < currentTimeS) {
                return;
            }
            MRC.listxattrResponse.Builder xattrs = MRC.listxattrResponse.newBuilder();
            for (MRC.XAttr xattr : entry.getXattrs().getXattrsList()) {
                if (xattr.getName().equals(name)) continue;
                xattrs.addXattrs(xattr);
            }
            entry.setXattrs(xattrs.build());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateXAttrs(String path) {
        if (path.isEmpty() || !this.enabled) {
            return;
        }
        this.writeLock.lock();
        try {
            MetadataCacheEntry entry = this.cache.get(path);
            if (entry != null) {
                entry.setXattrs(null);
                entry.setXattrTimeoutS(0L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long size() {
        this.readLock.lock();
        try {
            long l = this.cache.size();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected long capacity() {
        return this.maxNumberOfEntries;
    }

    private void evictUnmutexed(int n) {
        while ((long)this.cache.size() > this.maxNumberOfEntries - (long)n) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "MetadataCache evictUnmutexed: Deleting one entry from cache; entries in total: %s", this.cache.size());
            }
            String path = this.cache.keySet().iterator().next();
            this.cache.remove(path);
            this.pathIndex.remove(path);
        }
    }
}

