/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.util.Map;
import org.xtreemfs.common.libxtreemfs.FileInfo;
import org.xtreemfs.common.libxtreemfs.VolumeImplementation;
import org.xtreemfs.foundation.logging.Logging;

public class PeriodicFileSizeUpdateThread
extends Thread {
    private VolumeImplementation volume = null;

    public PeriodicFileSizeUpdateThread(VolumeImplementation volume, boolean startAsDaemon) {
        this.volume = volume;
        this.setDaemon(startAsDaemon);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(this.volume.getOptions().getPeriodicFileSizeUpdatesIntervalS() * 1000);
            }
            catch (InterruptedException e) {
                break;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "START openFileTable: Periodic filesize update for %s open files.", this.volume.getOpenFileTable().size());
            }
            for (Map.Entry<Long, FileInfo> entry : this.volume.getOpenFileTable().entrySet()) {
                try {
                    entry.getValue().writeBackFileSizeAsync();
                }
                catch (IOException e) {
                    if (!Logging.isDebug()) continue;
                    Logging.logMessage(7, Logging.Category.misc, this, "PeriodicFileSizeUpdateThread: failed to update filesize. Reason: ", e.getMessage());
                }
            }
            if (!Logging.isDebug()) continue;
            Logging.logMessage(7, Logging.Category.misc, this, "END openFileTable: Periodic filesize update for %s open files.", this.volume.getOpenFileTable().size());
        }
    }
}

