/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.util.Map;
import org.xtreemfs.common.libxtreemfs.FileInfo;
import org.xtreemfs.common.libxtreemfs.VolumeImplementation;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.foundation.logging.Logging;

public class PeriodicXcapRenewalThread
extends Thread {
    private VolumeImplementation volume = null;

    public PeriodicXcapRenewalThread(VolumeImplementation volume, boolean startAsDaemon) {
        this.volume = volume;
        this.setDaemon(startAsDaemon);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(this.volume.getOptions().getPeriodicXcapRenewalIntervalS() * 1000);
            }
            catch (Exception e) {
                break;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "START openFileTable: Periodic Xcap renewal for %s open files.", this.volume.getOpenFileTable().size());
            }
            for (Map.Entry<Long, FileInfo> entry : this.volume.getOpenFileTable().entrySet()) {
                try {
                    entry.getValue().renewXCapsAsync();
                }
                catch (AddressToUUIDNotFoundException e) {
                    if (!Logging.isDebug()) continue;
                    Logging.logMessage(7, Logging.Category.misc, this, "PeriodicXCapThread: failed to renew XCap. Reason: ", e.getMessage());
                }
            }
            if (!Logging.isDebug()) continue;
            Logging.logMessage(7, Logging.Category.misc, this, "END openFileTable: Periodic Xcap renewal for %s open files.", this.volume.getOpenFileTable().size());
        }
    }
}

