/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.UUIDResolver;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.InternalServerErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.InvalidViewException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RPCCaller {
    protected static <C, R extends Message> R syncCall(GlobalTypes.SERVICES service, RPC.UserCredentials userCreds, RPC.Auth auth, Options options, UUIDResolver uuidResolver, UUIDIterator it, boolean uuidIteratorHasAddresses, C callRequest, CallGenerator<C, R> callGen) throws IOException, PosixErrorException, InternalServerErrorException, AddressToUUIDNotFoundException {
        return RPCCaller.syncCall(service, userCreds, auth, options, uuidResolver, it, uuidIteratorHasAddresses, false, options.getMaxTries(), callRequest, null, callGen);
    }

    protected static <C, R extends Message> R syncCall(GlobalTypes.SERVICES service, RPC.UserCredentials userCreds, RPC.Auth auth, Options options, UUIDResolver uuidResolver, UUIDIterator it, boolean uuidIteratorHasAddresses, boolean delayNextTry, int maxRetries, C callRequest, CallGenerator<C, R> callGen) throws IOException, PosixErrorException, InternalServerErrorException, AddressToUUIDNotFoundException {
        return RPCCaller.syncCall(service, userCreds, auth, options, uuidResolver, it, uuidIteratorHasAddresses, delayNextTry, maxRetries, callRequest, null, callGen);
    }

    protected static <C, R extends Message> R syncCall(GlobalTypes.SERVICES service, RPC.UserCredentials userCreds, RPC.Auth auth, Options options, UUIDResolver uuidResolver, UUIDIterator it, boolean uuidIteratorHasAddresses, C callRequest, ReusableBuffer buf, CallGenerator<C, R> callGen) throws IOException, PosixErrorException, InternalServerErrorException, AddressToUUIDNotFoundException {
        return RPCCaller.syncCall(service, userCreds, auth, options, uuidResolver, it, uuidIteratorHasAddresses, false, options.getMaxTries(), callRequest, buf, callGen);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <C, R extends Message> R syncCall(GlobalTypes.SERVICES service, RPC.UserCredentials userCreds, RPC.Auth auth, Options options, UUIDResolver uuidResolver, UUIDIterator it, boolean uuidIteratorHasAddresses, boolean delayNextTry, int maxRetries, C callRequest, ReusableBuffer buffer, CallGenerator<C, R> callGen) throws PosixErrorException, IOException, InternalServerErrorException, AddressToUUIDNotFoundException {
        int maxTries = maxRetries;
        int attempt = 0;
        R response = null;
        try {
            while (true) {
                IOException responseError;
                boolean retry;
                block25: {
                    if (++attempt > maxTries) {
                        if (maxTries != 0) return null;
                    }
                    retry = false;
                    responseError = null;
                    RPCResponse<R> r = null;
                    try {
                        InetSocketAddress server;
                        if (uuidIteratorHasAddresses) {
                            server = RPCCaller.getInetSocketAddressFromAddress(it.getUUID(), service);
                        } else {
                            String address = uuidResolver.uuidToAddress(it.getUUID());
                            server = RPCCaller.getInetSocketAddressFromAddress(address, service);
                        }
                        r = callGen.executeCall(server, auth, userCreds, callRequest);
                        response = r.get();
                        if (r.getData() == null) break block25;
                        if (buffer != null) {
                            buffer.put(r.getData());
                        }
                        BufferPool.free(r.getData());
                    }
                    catch (PBRPCException pbe) {
                        responseError = pbe;
                        if (pbe.getErrorType().equals(RPC.ErrorType.REDIRECT)) {
                            assert (pbe.getRedirectToServerUUID() != null);
                            if (Logging.isInfo()) {
                                String error = uuidIteratorHasAddresses ? "The server " + it.getUUID() + " redirected to the current master: " + pbe.getRedirectToServerUUID() + " at attempt: " + attempt : "The server with UUID " + it.getUUID() + " redirected to the current master: " + pbe.getRedirectToServerUUID() + " at attempt: " + attempt;
                                Logging.logMessage(6, Logging.Category.misc, pbe, error, new Object[0]);
                            }
                            if (maxTries != 0 && attempt == maxTries) {
                                ++maxTries;
                            }
                            it.markUUIDAsFailed(it.getUUID());
                            continue;
                        }
                        if (!pbe.getErrorType().equals(RPC.ErrorType.IO_ERROR) && !pbe.getErrorType().equals(RPC.ErrorType.INTERNAL_SERVER_ERROR)) break block25;
                        it.markUUIDAsFailed(it.getUUID());
                        retry = true;
                    }
                    catch (IOException ioe) {
                        responseError = ioe;
                        it.markUUIDAsFailed(it.getUUID());
                        retry = true;
                    }
                    catch (InterruptedException ie) {
                        if (options.getInterruptSignal() != 0) throw new IOException();
                        if (!Logging.isDebug()) return null;
                        Logging.logMessage(7, Logging.Category.misc, ie, "Caught interrupt, aborting sync request", new Object[0]);
                        return null;
                    }
                    finally {
                        if (r == null) continue;
                        r.freeBuffers();
                        continue;
                    }
                }
                if (responseError == null) return response;
                if (attempt == 1 && maxTries != 1) {
                    String retriesLeft = maxTries == 0 ? "infinite" : String.valueOf(maxTries - attempt);
                    Logging.logMessage(3, Logging.Category.misc, responseError, "Got no response from %s, retrying (%s attemps left, waiting at least %s seconds between two attemps) Error was: %s", it.getUUID(), retriesLeft, options.getRetryDelay_s(), responseError.getMessage());
                    if (Logging.isDebug()) {
                        Logging.logError(7, null, responseError);
                    }
                }
                if (!retry || attempt >= maxTries && maxTries != 0) {
                    if (attempt != maxTries) throw responseError;
                    if (!delayNextTry) throw responseError;
                }
                RPCCaller.waitDelay(options.getRetryDelay_s());
            }
        }
        catch (PBRPCException e) {
            RPCCaller.handleErrorAfterMaxTriesExceeded(e, it);
        }
        return null;
    }

    static void waitDelay(long delay_s) throws IOException {
        try {
            Thread.sleep(delay_s * 1000L);
        }
        catch (InterruptedException e) {
            String msg = "Caught interrupt while waiting for the next attempt, aborting sync request";
            if (Logging.isInfo()) {
                Logging.logMessage(7, Logging.Category.misc, e, msg, new Object[0]);
            }
            throw new IOException(msg);
        }
    }

    private static void handleErrorAfterMaxTriesExceeded(PBRPCException e, UUIDIterator it) throws PosixErrorException, IOException, InternalServerErrorException, InvalidViewException, XtreemFSException {
        int logLevel = 6;
        String errorMsg = "";
        switch (e.getErrorType()) {
            case ERRNO: {
                if (e.getPOSIXErrno().equals(RPC.POSIXErrno.POSIX_ERROR_ENOENT)) {
                    logLevel = 7;
                }
                errorMsg = "The server " + it.getUUID() + " denied the requested operation. " + "Error value: " + e.getErrorType().name() + " Error message: " + e.getErrorMessage();
                Logging.logMessage(logLevel, Logging.Category.misc, e, errorMsg, new Object[0]);
                throw new PosixErrorException(e.getPOSIXErrno(), errorMsg);
            }
            case IO_ERROR: {
                Logging.logMessage(logLevel, Logging.Category.misc, e, "The client encountered a communication error sending a request to the server %s Error: %s", it.getUUID(), e.getErrorMessage());
                throw new IOException(e.getErrorMessage());
            }
            case INTERNAL_SERVER_ERROR: {
                Logging.logMessage(logLevel, Logging.Category.misc, e, "The server %s returned an internal servererror: %s", it.getUUID(), e.getErrorMessage());
                throw new InternalServerErrorException(errorMsg);
            }
            case REDIRECT: {
                throw new XtreemFSException("This error (A REDIRECT error was not handled and retried but thrown instead) should never happen. Report this");
            }
            case INVALID_VIEW: {
                Logging.logMessage(logLevel, Logging.Category.replication, e, "The server %s denied the requested operation because the clients view is outdated. Error: %s", it.getUUID(), e.getErrorMessage());
                throw new InvalidViewException(e.getErrorMessage());
            }
        }
        errorMsg = "The server " + it.getUUID() + "returned an error: " + e.getErrorType().name() + " Error: " + e.getErrorMessage();
        Logging.logMessage(logLevel, Logging.Category.misc, e, errorMsg, new Object[0]);
        throw new XtreemFSException(errorMsg);
    }

    protected static InetSocketAddress getInetSocketAddressFromAddress(String address, GlobalTypes.SERVICES service) {
        if (GlobalTypes.SERVICES.DIR.equals(service)) {
            return Helper.stringToInetSocketAddress(address, GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber());
        }
        if (GlobalTypes.SERVICES.MRC.equals(service)) {
            return Helper.stringToInetSocketAddress(address, GlobalTypes.PORTS.MRC_PBRPC_PORT_DEFAULT.getNumber());
        }
        if (GlobalTypes.SERVICES.OSD.equals(service)) {
            return Helper.stringToInetSocketAddress(address, GlobalTypes.PORTS.OSD_PBRPC_PORT_DEFAULT.getNumber());
        }
        return null;
    }

    protected static interface CallGenerator<C, R extends Message> {
        public RPCResponse<R> executeCall(InetSocketAddress var1, RPC.Auth var2, RPC.UserCredentials var3, C var4) throws IOException, PosixErrorException;
    }
}

