/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.util.Vector;
import org.xtreemfs.common.libxtreemfs.ReadOperation;
import org.xtreemfs.common.libxtreemfs.StripeTranslator;
import org.xtreemfs.common.libxtreemfs.WriteOperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class StripeTranslatorRaid0
implements StripeTranslator {
    @Override
    public void translateWriteRequest(int size, long offset, GlobalTypes.StripingPolicy policy, ReusableBuffer buf, Vector<WriteOperation> operations) {
        int reqSize;
        int stripeSize = policy.getStripeSize() * 1024;
        int osdCount = policy.getWidth();
        for (int start = 0; start < size; start += reqSize) {
            long objNumber = ((long)start + offset) / (long)stripeSize;
            int osdOffset = (int)(objNumber % (long)osdCount);
            int reqOffset = (int)(((long)start + offset) % (long)stripeSize);
            reqSize = Math.min(size - start, stripeSize - reqOffset);
            ReusableBuffer viewBuffer = buf.createViewBuffer();
            viewBuffer.range(start, reqSize);
            operations.add(new WriteOperation(objNumber, osdOffset, reqSize, reqOffset, viewBuffer));
        }
    }

    @Override
    public void translateReadRequest(int size, long offset, GlobalTypes.StripingPolicy policy, Vector<ReadOperation> operations) {
        int reqSize;
        int stripeSize = policy.getStripeSize() * 1024;
        int osdCount = policy.getWidth();
        for (int start = 0; start < size; start += reqSize) {
            long objNumber = ((long)start + offset) / (long)stripeSize;
            int osdOffset = (int)(objNumber % (long)osdCount);
            int reqOffset = (int)(((long)start + offset) % (long)stripeSize);
            reqSize = Math.min(size - start, stripeSize - reqOffset);
            operations.add(new ReadOperation(objNumber, osdOffset, reqSize, reqOffset, start));
        }
    }
}

