/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.util.ArrayList;
import java.util.Collection;
import org.xtreemfs.common.libxtreemfs.exceptions.UUIDIteratorListIsEmpyException;

public class UUIDIterator {
    private ArrayList<UUIDItem> uuids = new ArrayList();
    private UUIDItem currentUUID = null;

    public UUIDIterator() {
    }

    public UUIDIterator(Collection<String> uuids) {
        this();
        this.addUUIDs(uuids);
    }

    public synchronized void addUUID(String uuid) {
        UUIDItem entry = new UUIDItem(uuid);
        this.uuids.add(entry);
        if (this.uuids.size() == 1) {
            this.currentUUID = entry;
        }
    }

    public synchronized void addUUIDs(Collection<String> uuids) {
        for (String uuid : uuids) {
            this.addUUID(uuid);
        }
    }

    public synchronized void clear() {
        this.uuids.clear();
        this.currentUUID = null;
    }

    public synchronized void clearAndAddUUID(String uuid) {
        this.clear();
        this.addUUID(uuid);
    }

    public synchronized void clearAndAddUUIDs(Collection<String> uuids) {
        this.clear();
        this.addUUIDs(uuids);
    }

    public synchronized String debugString() {
        StringBuffer debugStringBuffer = new StringBuffer("[ ");
        for (UUIDItem item : this.uuids) {
            debugStringBuffer.append("[ " + item.uuid + ", " + item.markedAsFailed + " ]");
        }
        debugStringBuffer.append(" ]");
        return debugStringBuffer.toString();
    }

    public synchronized String getUUID() throws UUIDIteratorListIsEmpyException {
        if (this.uuids.isEmpty()) {
            throw new UUIDIteratorListIsEmpyException("GetUUID() failed as no current  UUID is set. Size of list of UUIDs: " + this.uuids.size());
        }
        assert (!this.currentUUID.markedAsFailed);
        return this.currentUUID.uuid;
    }

    public synchronized void markUUIDAsFailed(String uuid) {
        if (this.currentUUID != null && this.currentUUID.uuid.equals(uuid)) {
            this.currentUUID.markedAsFailed = true;
            int index = this.uuids.indexOf(this.currentUUID);
            if (index == this.uuids.size() - 1) {
                for (UUIDItem item : this.uuids) {
                    item.markedAsFailed = false;
                }
                this.currentUUID = this.uuids.get(0);
            } else {
                this.currentUUID = this.uuids.get(index + 1);
            }
        }
    }

    public synchronized void setCurrentUUID(String uuid) {
        for (UUIDItem item : this.uuids) {
            if (!item.uuid.equals(uuid)) continue;
            this.currentUUID = item;
            return;
        }
        UUIDItem entry = new UUIDItem(uuid);
        this.uuids.add(entry);
        this.currentUUID = entry;
    }

    public synchronized int size() {
        return this.uuids.size();
    }

    private static class UUIDItem {
        public String uuid;
        public boolean markedAsFailed = false;

        public UUIDItem(String addUUID) {
            this.uuid = addUUID;
        }
    }
}

