/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.libxtreemfs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.xtreemfs.common.libxtreemfs.AdminFileHandle;
import org.xtreemfs.common.libxtreemfs.AdminVolume;
import org.xtreemfs.common.libxtreemfs.ClientImplementation;
import org.xtreemfs.common.libxtreemfs.FileHandleImplementation;
import org.xtreemfs.common.libxtreemfs.FileInfo;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.libxtreemfs.MetadataCache;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.PeriodicFileSizeUpdateThread;
import org.xtreemfs.common.libxtreemfs.PeriodicXcapRenewalThread;
import org.xtreemfs.common.libxtreemfs.RPCCaller;
import org.xtreemfs.common.libxtreemfs.StripeTranslator;
import org.xtreemfs.common.libxtreemfs.StripeTranslatorRaid0;
import org.xtreemfs.common.libxtreemfs.Tupel;
import org.xtreemfs.common.libxtreemfs.UUIDIterator;
import org.xtreemfs.common.libxtreemfs.UUIDResolver;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.common.libxtreemfs.exceptions.XtreemFSException;
import org.xtreemfs.common.xloc.ReplicationPolicyImplementation;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.json.JSONString;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class VolumeImplementation
implements Volume,
AdminVolume {
    private final String clientUuid;
    private final ClientImplementation client;
    private final UUIDResolver uuidResolver;
    private final String volumeName;
    private final Options volumeOptions;
    private final RPC.UserCredentials userCredentialsBogus;
    private RPCNIOSocketClient networkClient;
    private MRCServiceClient mrcServiceClient;
    private OSDServiceClient osdServiceClient;
    private final SSLOptions sslOptions;
    private final RPC.Auth authBogus;
    private final UUIDIterator mrcUUIDIterator;
    private ConcurrentHashMap<Long, FileInfo> openFileTable;
    private final MetadataCache metadataCache;
    private PeriodicXcapRenewalThread xcapRenewalThread;
    private PeriodicFileSizeUpdateThread fileSizeUpdateThread;
    private final Map<GlobalTypes.StripingPolicyType, StripeTranslator> stripeTranslators;
    private static final String XTREEMFS_DEFAULT_RP = "xtreemfs.default_rp";
    private static final String OSD_SELECTION_POLICY = "xtreemfs.osel_policy";
    private static final String REPLICA_SELECTION_POLICY = "xtreemfs.rsel_policy";

    public VolumeImplementation(ClientImplementation client, String clientUUID, UUIDIterator mrcUuidIterator, String volumeName, SSLOptions sslOptions, Options options) {
        this.client = client;
        this.clientUuid = clientUUID;
        this.uuidResolver = client;
        this.volumeName = volumeName;
        this.volumeOptions = options;
        this.sslOptions = sslOptions;
        this.mrcUUIDIterator = mrcUuidIterator;
        this.userCredentialsBogus = RPC.UserCredentials.newBuilder().setUsername("xtreemfs").build();
        this.authBogus = RPCAuthentication.authNone;
        this.metadataCache = new MetadataCache(options.getMetadataCacheSize(), options.getMetadataCacheTTLs());
        this.stripeTranslators = new HashMap<GlobalTypes.StripingPolicyType, StripeTranslator>();
        this.stripeTranslators.put(GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0, new StripeTranslatorRaid0());
    }

    @Override
    public void start() throws IOException {
        this.start(false);
    }

    @Override
    public void start(boolean startThreadsAsDaemons) throws IOException {
        this.networkClient = new RPCNIOSocketClient(this.sslOptions, this.volumeOptions.getRequestTimeout_s() * 1000, this.volumeOptions.getLingerTimeout_s() * 1000, "Volume", startThreadsAsDaemons);
        this.networkClient.start();
        try {
            this.networkClient.waitForStartup();
        }
        catch (Exception e) {
            throw new IOException("Volume: Could not start networkClient!");
        }
        this.mrcServiceClient = new MRCServiceClient(this.networkClient, null);
        this.osdServiceClient = new OSDServiceClient(this.networkClient, null);
        this.openFileTable = new ConcurrentHashMap();
        this.fileSizeUpdateThread = new PeriodicFileSizeUpdateThread(this, startThreadsAsDaemons);
        this.fileSizeUpdateThread.start();
        this.xcapRenewalThread = new PeriodicXcapRenewalThread(this, startThreadsAsDaemons);
        this.xcapRenewalThread.start();
    }

    @Override
    public void internalShutdown() {
        block5: {
            try {
                this.fileSizeUpdateThread.interrupt();
                this.xcapRenewalThread.interrupt();
                this.fileSizeUpdateThread.join();
                this.xcapRenewalThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            assert (this.openFileTable.size() == 0);
            this.networkClient.shutdown();
            try {
                this.networkClient.waitForShutdown();
            }
            catch (Exception e) {
                if (!Logging.isDebug()) break block5;
                Logging.logMessage(7, Logging.Category.misc, this, "Volume: Couldn't shut down network client corretly: %s ", e.getMessage());
            }
        }
    }

    @Override
    public void close() {
        this.internalShutdown();
        this.client.closeVolume(this);
    }

    @Override
    public MRC.StatVFS statFS(RPC.UserCredentials userCredentials) throws IOException, PosixErrorException, AddressToUUIDNotFoundException, AddressToUUIDNotFoundException {
        MRC.statvfsRequest request = MRC.statvfsRequest.newBuilder().setKnownEtag(0L).setVolumeName(this.volumeName).build();
        MRC.StatVFS stat = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.statvfsRequest, MRC.StatVFS>(){

            @Override
            public RPCResponse<MRC.StatVFS> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.statvfsRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.statvfs(server, authHeader, userCreds, input);
            }
        });
        return stat;
    }

    @Override
    public String readLink(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException, AddressToUUIDNotFoundException {
        MRC.readlinkRequest request = MRC.readlinkRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).build();
        MRC.readlinkResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.readlinkRequest, MRC.readlinkResponse>(){

            @Override
            public RPCResponse<MRC.readlinkResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.readlinkRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.readlink(server, authHeader, userCreds, input);
            }
        });
        assert (response != null && response.getLinkTargetPathCount() == 1);
        return response.getLinkTargetPath(0);
    }

    @Override
    public void symlink(RPC.UserCredentials userCredentials, String targetPath, String linkPath) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.symlinkRequest request = MRC.symlinkRequest.newBuilder().setLinkPath(linkPath).setTargetPath(targetPath).setVolumeName(this.volumeName).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.symlinkRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.symlinkRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.symlink(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        String parentDir = Helper.resolveParentDirectory(linkPath);
        this.metadataCache.updateStatTime(parentDir, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
        this.metadataCache.invalidateDirEntries(parentDir);
    }

    @Override
    public void link(RPC.UserCredentials userCredentials, String targetPath, String linkPath) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.linkRequest request = MRC.linkRequest.newBuilder().setLinkPath(linkPath).setTargetPath(targetPath).setVolumeName(this.volumeName).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.linkRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.linkRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.link(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        String parentDir = Helper.resolveParentDirectory(linkPath);
        this.metadataCache.updateStatTime(parentDir, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
        this.metadataCache.invalidateDirEntries(parentDir);
        this.metadataCache.invalidate(linkPath);
        this.metadataCache.invalidate(targetPath);
    }

    @Override
    public void access(RPC.UserCredentials userCredentials, String path, int flags) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.accessRequest request = MRC.accessRequest.newBuilder().setFlags(flags).setPath(path).setVolumeName(this.volumeName).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.accessRequest, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.accessRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.access(server, authHeader, userCreds, input);
            }
        });
    }

    @Override
    public AdminFileHandle openFile(RPC.UserCredentials userCredentials, String path, int flags) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.openFile(userCredentials, path, flags, 0, 0);
    }

    @Override
    public AdminFileHandle openFile(RPC.UserCredentials userCredentials, String path, int flags, int mode) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.openFile(userCredentials, path, flags, mode, 0);
    }

    public AdminFileHandle openFile(RPC.UserCredentials userCredentials, String path, int flags, int mode, int truncateNewFileSize) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        boolean asyncWritesEnabled;
        boolean bl = asyncWritesEnabled = this.volumeOptions.getMaxWriteahead() > 0;
        if ((GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_SYNC.getNumber() & flags) > 0) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "open called with O_SYNC, async writes were disabled", new Object[0]);
            }
            asyncWritesEnabled = false;
        }
        MRC.openRequest request = MRC.openRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setFlags(flags).setMode(mode).setAttributes(0).build();
        MRC.openResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.openRequest, MRC.openResponse>(){

            @Override
            public RPCResponse<MRC.openResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.openRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.open(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        assert (response.hasCreds());
        if (response.getCreds().getXlocs().getReplicasCount() == 0) {
            String errorMessage = "MRC assigned no OSDs to file on open" + path + ", xloc: " + response.getCreds().getXlocs().toString();
            Logging.logMessage(3, Logging.Category.misc, this, errorMessage, new Object[0]);
            throw new PosixErrorException(RPC.POSIXErrno.POSIX_ERROR_EIO, errorMessage);
        }
        FileHandleImplementation fileHandle = null;
        FileInfo fileInfo = this.getOrCreateFileInfo(Helper.extractFileIdFromXcap(response.getCreds().getXcap()), path, response.getCreds().getXcap().getReplicateOnClose(), response.getCreds().getXlocs());
        fileHandle = fileInfo.createFileHandle(response.getCreds().getXcap(), asyncWritesEnabled);
        if ((flags & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber()) > 0) {
            String parentDir = Helper.resolveParentDirectory(path);
            this.metadataCache.updateStatTime(path, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
            this.metadataCache.invalidate(parentDir);
        }
        if ((flags & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber()) > 0) {
            this.metadataCache.updateStatTime(path, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "open called with O_TRUNK.", new Object[0]);
            }
            try {
                fileHandle.truncatePhaseTwoAndThree(userCredentials, truncateNewFileSize, false);
            }
            catch (XtreemFSException e) {
                fileHandle.close();
                throw e;
            }
        }
        return fileHandle;
    }

    @Override
    public void truncate(RPC.UserCredentials userCredentials, String path, int newFileSize) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_WRONLY.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber();
        AdminFileHandle fileHandle = this.openFile(userCredentials, path, flags, 0, newFileSize);
        fileHandle.close();
    }

    @Override
    public MRC.Stat getAttr(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.getAttr(userCredentials, path, null);
    }

    protected MRC.Stat getAttr(RPC.UserCredentials userCredentials, String path, FileInfo fileInfo) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.Stat stat = this.getAttrHelper(userCredentials, path);
        if (fileInfo == null) {
            FileInfo fileInfoFromOpenFileTable = this.openFileTable.get(stat.getIno());
            if (fileInfoFromOpenFileTable != null) {
                fileInfoFromOpenFileTable.waitForPendingAsyncWrites();
                stat = fileInfoFromOpenFileTable.mergeStatAndOSDWriteResponse(stat);
            }
        } else {
            fileInfo.waitForPendingAsyncWrites();
            stat = fileInfo.mergeStatAndOSDWriteResponse(stat);
        }
        return stat;
    }

    private MRC.Stat getAttrHelper(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.Stat stat = this.metadataCache.getStat(path);
        if (stat != null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "getattr: serving from stat-cache %s  %s", path, stat.getSize());
            }
        } else {
            MRC.getattrRequest request = MRC.getattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setKnownEtag(0L).build();
            MRC.getattrResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.getattrRequest, MRC.getattrResponse>(){

                @Override
                public RPCResponse<MRC.getattrResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.getattrRequest input) throws IOException {
                    return VolumeImplementation.this.mrcServiceClient.getattr(server, authHeader, userCreds, input);
                }
            });
            assert (response != null);
            stat = response.getStbuf();
            if (stat.getNlink() > 1) {
                this.metadataCache.invalidate(path);
            } else {
                this.metadataCache.updateStat(path, stat);
            }
        }
        return stat;
    }

    @Override
    public void setAttr(RPC.UserCredentials userCredentials, String path, MRC.Stat stat, int toSet) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.setattrRequest request = MRC.setattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setStbuf(stat).setToSet(toSet).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.setattrRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.setattrRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.setattr(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        if ((toSet & MRC.Setattrs.SETATTR_MODE.getNumber()) > 0 || (toSet & MRC.Setattrs.SETATTR_UID.getNumber()) > 0 || (toSet & MRC.Setattrs.SETATTR_GID.getNumber()) > 0) {
            toSet |= MRC.Setattrs.SETATTR_CTIME.getNumber();
            stat = stat.toBuilder().setAtimeNs(1000000000L * (long)response.getTimestampS()).build();
        }
        if (stat.getNlink() > 1 || (toSet & MRC.Setattrs.SETATTR_MODE.getNumber()) > 0 && (stat.getMode() & 0x400) > 0) {
            this.metadataCache.invalidate(path);
        } else {
            this.metadataCache.updateStatAttributes(path, stat, toSet);
        }
    }

    @Override
    public void unlink(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.unlink(userCredentials, path, false);
    }

    @Override
    public void unlink(RPC.UserCredentials userCredentials, String path, boolean unlinkOnlyAtMrc) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.unlinkRequest request = MRC.unlinkRequest.newBuilder().setPath(path).setVolumeName(this.volumeName).build();
        MRC.unlinkResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.unlinkRequest, MRC.unlinkResponse>(){

            @Override
            public RPCResponse<MRC.unlinkResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.unlinkRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.unlink(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        this.metadataCache.invalidate(path);
        String parentDir = Helper.resolveParentDirectory(path);
        this.metadataCache.updateStatTime(path, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
        this.metadataCache.invalidateDirEntry(parentDir, Helper.getBasename(path));
        if (response.hasCreds() & !unlinkOnlyAtMrc) {
            this.unlinkAtOsd(response.getCreds(), path);
        }
    }

    private void unlinkAtOsd(GlobalTypes.FileCredentials fc, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        OSD.unlink_osd_Request request = OSD.unlink_osd_Request.newBuilder().setFileCredentials(fc).setFileId(fc.getXcap().getFileId()).build();
        UUIDIterator osdUuidIterator = new UUIDIterator();
        for (int i = 0; i < fc.getXlocs().getReplicasCount(); ++i) {
            String headOsd = Helper.getOSDUUIDFromXlocSet(fc.getXlocs(), i, 0);
            osdUuidIterator.clearAndAddUUID(headOsd);
            RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, this.userCredentialsBogus, this.authBogus, this.volumeOptions, this.uuidResolver, osdUuidIterator, false, request, new RPCCaller.CallGenerator<OSD.unlink_osd_Request, Common.emptyResponse>(){

                @Override
                public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.unlink_osd_Request input) throws IOException {
                    return VolumeImplementation.this.osdServiceClient.unlink(server, authHeader, userCreds, input);
                }
            });
        }
    }

    @Override
    public void rename(RPC.UserCredentials userCredentials, String path, String newPath) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        if (path.equals(newPath)) {
            return;
        }
        MRC.renameRequest request = MRC.renameRequest.newBuilder().setVolumeName(this.volumeName).setSourcePath(path).setTargetPath(newPath).build();
        MRC.renameResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.renameRequest, MRC.renameResponse>(){

            @Override
            public RPCResponse<MRC.renameResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.renameRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.rename(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        if (response.hasCreds()) {
            this.unlinkAtOsd(response.getCreds(), newPath);
        }
        String parentPath = Helper.resolveParentDirectory(path);
        String parentNewPath = Helper.resolveParentDirectory(parentPath);
        if (response.getTimestampS() != 0) {
            this.metadataCache.updateStatTime(parentPath, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
            this.metadataCache.updateStatTime(parentNewPath, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
        }
        this.metadataCache.invalidateDirEntry(parentPath, Helper.getBasename(path));
        this.metadataCache.invalidateDirEntries(parentNewPath);
        this.metadataCache.invalidate(newPath);
        this.metadataCache.renamePrefix(path, newPath);
        this.metadataCache.updateStatTime(newPath, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber());
        for (Map.Entry<Long, FileInfo> entry : this.openFileTable.entrySet()) {
            entry.getValue().renamePath(path, newPath);
        }
    }

    @Override
    public void createDirectory(RPC.UserCredentials userCredentials, String path, int mode, boolean recursive) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        if (recursive) {
            String parent;
            if (path.equals("/")) {
                return;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (this.isDirectory(userCredentials, parent = path.substring(0, path.lastIndexOf("/"))) || parent.isEmpty()) {
                this.createDirectory(userCredentials, path, mode, false);
            } else {
                this.createDirectory(userCredentials, parent, mode, true);
                this.createDirectory(userCredentials, path, mode, false);
            }
        } else {
            MRC.mkdirRequest request = MRC.mkdirRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setMode(mode).build();
            MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.mkdirRequest, MRC.timestampResponse>(){

                @Override
                public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.mkdirRequest input) throws IOException {
                    return VolumeImplementation.this.mrcServiceClient.mkdir(server, authHeader, userCreds, input);
                }
            });
            assert (response != null);
            String parentDir = Helper.resolveParentDirectory(path);
            this.metadataCache.updateStatTime(path, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
            this.metadataCache.invalidateDirEntries(parentDir);
        }
    }

    private boolean isDirectory(RPC.UserCredentials userCredentials, String path) throws PosixErrorException, IOException, AddressToUUIDNotFoundException {
        try {
            MRC.Stat stat = this.getAttr(userCredentials, path);
            return (stat.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber()) > 0;
        }
        catch (PosixErrorException pee) {
            if (pee.getPosixError().equals(RPC.POSIXErrno.POSIX_ERROR_ENOENT)) {
                return false;
            }
            throw pee;
        }
    }

    @Override
    public void createDirectory(RPC.UserCredentials userCredentials, String path, int mode) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        this.createDirectory(userCredentials, path, mode, false);
    }

    @Override
    public void removeDirectory(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.rmdirRequest request = MRC.rmdirRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.rmdirRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.rmdirRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.rmdir(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        String parentDir = Helper.resolveParentDirectory(path);
        this.metadataCache.updateStatTime(parentDir, response.getTimestampS(), MRC.Setattrs.SETATTR_CTIME.getNumber() | MRC.Setattrs.SETATTR_MTIME.getNumber());
        this.metadataCache.invalidatePrefix(path);
        this.metadataCache.invalidateDirEntry(path, Helper.getBasename(path));
    }

    @Override
    public MRC.DirectoryEntries readDir(RPC.UserCredentials userCredentials, String path, int offset, int count, boolean namesOnly) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.DirectoryEntries result = null;
        if (count == 0) {
            count = Integer.MAX_VALUE - offset - 1;
        }
        if ((result = this.metadataCache.getDirEntries(path, offset, count)) != null) {
            return result;
        }
        MRC.DirectoryEntries.Builder dirEntriesBuilder = MRC.DirectoryEntries.newBuilder();
        for (int currentOffset = offset; currentOffset < offset + count; currentOffset += this.volumeOptions.getReaddirChunkSize()) {
            int limitDirEntriesCount = currentOffset > offset + count ? currentOffset - offset - count : this.volumeOptions.getReaddirChunkSize();
            MRC.readdirRequest request = MRC.readdirRequest.newBuilder().setPath(path).setVolumeName(this.volumeName).setNamesOnly(namesOnly).setKnownEtag(0L).setSeenDirectoryEntriesCount(currentOffset).setLimitDirectoryEntriesCount(limitDirEntriesCount).build();
            MRC.DirectoryEntries readDirResponse = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.readdirRequest, MRC.DirectoryEntries>(){

                @Override
                public RPCResponse<MRC.DirectoryEntries> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.readdirRequest input) throws IOException {
                    return VolumeImplementation.this.mrcServiceClient.readdir(server, authHeader, userCreds, input);
                }
            });
            assert (readDirResponse != null);
            dirEntriesBuilder.addAllEntries(readDirResponse.getEntriesList());
            if (dirEntriesBuilder.getEntriesCount() < currentOffset + this.volumeOptions.getReaddirChunkSize()) break;
        }
        int minimum = this.volumeOptions.getMetadataCacheSize() > dirEntriesBuilder.getEntriesCount() ? dirEntriesBuilder.getEntriesCount() : this.volumeOptions.getMetadataCacheSize();
        for (int i = 0; i < minimum; ++i) {
            if (!dirEntriesBuilder.getEntries(i).hasStbuf()) continue;
            if (dirEntriesBuilder.getEntries(i).getStbuf().getNlink() > 1) {
                this.metadataCache.invalidate(path);
                continue;
            }
            this.metadataCache.updateStat(Helper.concatenatePath(path, dirEntriesBuilder.getEntries(i).getName()), dirEntriesBuilder.getEntries(i).getStbuf());
        }
        result = dirEntriesBuilder.build();
        if (!namesOnly && offset == 0 && result.getEntriesCount() < count) {
            this.metadataCache.updateDirEntries(path, result);
        }
        return result;
    }

    @Override
    public MRC.listxattrResponse listXAttrs(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        return this.listXAttrs(userCredentials, path, true);
    }

    @Override
    public MRC.listxattrResponse listXAttrs(RPC.UserCredentials userCredentials, String path, boolean useCache) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.listxattrResponse response = null;
        if (useCache && (response = this.metadataCache.getXAttrs(path)) != null) {
            return response;
        }
        MRC.listxattrRequest request = MRC.listxattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setNamesOnly(false).build();
        response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.listxattrRequest, MRC.listxattrResponse>(){

            @Override
            public RPCResponse<MRC.listxattrResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.listxattrRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.listxattr(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        this.metadataCache.updateXAttrs(path, response);
        return response;
    }

    @Override
    public void setXAttr(RPC.UserCredentials userCredentials, RPC.Auth auth, String path, String name, String value, MRC.XATTR_FLAGS flags) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.setxattrRequest request = MRC.setxattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setName(name).setValue(value).setFlags(flags.getNumber()).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, auth, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.setxattrRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.setxattrRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.setxattr(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        this.metadataCache.updateXAttr(path, name, value);
    }

    @Override
    public void setXAttr(RPC.UserCredentials userCredentials, String path, String name, String value, MRC.XATTR_FLAGS flags) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.setxattrRequest request = MRC.setxattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setName(name).setValue(value).setFlags(flags.getNumber()).build();
        MRC.timestampResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.setxattrRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.setxattrRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.setxattr(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        this.metadataCache.updateXAttr(path, name, value);
    }

    @Override
    public String getXAttr(RPC.UserCredentials userCredentials, String path, String name) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        boolean xtreemfsAttrRequest = name.substring(0, 9).equals("xtreemfs.");
        if (xtreemfsAttrRequest) {
            MRC.getxattrRequest request = MRC.getxattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setName(name).build();
            MRC.getxattrResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.getxattrRequest, MRC.getxattrResponse>(){

                @Override
                public RPCResponse<MRC.getxattrResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.getxattrRequest input) throws IOException {
                    return VolumeImplementation.this.mrcServiceClient.getxattr(server, authHeader, userCreds, input);
                }
            });
            assert (response != null);
            if (response.hasValue()) {
                return response.getValue();
            }
            return null;
        }
        Tupel<String, Boolean> cachedXattr = this.metadataCache.getXAttr(path, name);
        if (cachedXattr.getFirst() == null && cachedXattr.getSecond().booleanValue()) {
            return null;
        }
        MRC.listxattrResponse xattrList = this.listXAttrs(userCredentials, path);
        if (xattrList.getXattrsCount() > 0) {
            for (MRC.XAttr xattr : xattrList.getXattrsList()) {
                if (!xattr.getName().equals(name)) continue;
                return xattr.getValue();
            }
        }
        return null;
    }

    @Override
    public int getXAttrSize(RPC.UserCredentials userCredentials, String path, String name) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        boolean xtreemfsAttributeRequested = name.length() >= 9 ? name.substring(0, 9).equals("xtreemfs.") : false;
        if (xtreemfsAttributeRequested) {
            String attr = this.getXAttr(userCredentials, path, name);
            return attr.length();
        }
        Tupel<Integer, Boolean> cachedXattrSize = this.metadataCache.getXAttrSize(path, name);
        if (cachedXattrSize.getFirst() != 0) {
            return cachedXattrSize.getFirst();
        }
        if (cachedXattrSize.getSecond().booleanValue()) {
            return -1;
        }
        MRC.listxattrResponse xattrList = this.listXAttrs(userCredentials, path);
        if (xattrList.getXattrsCount() > 0) {
            for (MRC.XAttr xattr : xattrList.getXattrsList()) {
                if (!xattr.getName().equals(name)) continue;
                return xattr.getValue().length();
            }
        }
        return -1;
    }

    @Override
    public void removeXAttr(RPC.UserCredentials userCredentials, String path, String name) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.removexattrRequest request = MRC.removexattrRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setName(name).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.removexattrRequest, MRC.timestampResponse>(){

            @Override
            public RPCResponse<MRC.timestampResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.removexattrRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.removexattr(server, authHeader, userCreds, input);
            }
        });
        this.metadataCache.invalidateXAttr(path, name);
    }

    @Override
    public void addReplica(RPC.UserCredentials userCredentials, String path, GlobalTypes.Replica newReplica) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.xtreemfs_replica_addRequest request = MRC.xtreemfs_replica_addRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setNewReplica(newReplica).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.xtreemfs_replica_addRequest, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_replica_addRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.xtreemfs_replica_add(server, authHeader, userCreds, input);
            }
        });
        AdminFileHandle fileHandle = this.openFile(userCredentials, path, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
        if (fileHandle.getReplicaUpdatePolicy().equals("ronly")) {
            fileHandle.pingReplica(userCredentials, newReplica.getOsdUuids(0));
        }
        fileHandle.close();
    }

    @Override
    public GlobalTypes.Replicas listReplicas(RPC.UserCredentials userCredentials, String path) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.xtreemfs_get_xlocsetRequest request = MRC.xtreemfs_get_xlocsetRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).build();
        GlobalTypes.XLocSet xlocset = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.xtreemfs_get_xlocsetRequest, GlobalTypes.XLocSet>(){

            @Override
            public RPCResponse<GlobalTypes.XLocSet> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_get_xlocsetRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.xtreemfs_get_xlocset(server, authHeader, userCreds, input);
            }
        });
        assert (xlocset != null);
        GlobalTypes.Replicas.Builder replicas = GlobalTypes.Replicas.newBuilder();
        replicas.addAllReplicas(xlocset.getReplicasList());
        return replicas.build();
    }

    @Override
    public void removeReplica(RPC.UserCredentials userCredentials, String path, String osdUuid) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.xtreemfs_replica_removeRequest request = MRC.xtreemfs_replica_removeRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setOsdUuid(osdUuid).build();
        GlobalTypes.FileCredentials response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.xtreemfs_replica_removeRequest, GlobalTypes.FileCredentials>(){

            @Override
            public RPCResponse<GlobalTypes.FileCredentials> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_replica_removeRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.xtreemfs_replica_remove(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        UUIDIterator osdUuidIterator = new UUIDIterator();
        osdUuidIterator.addUUID(osdUuid);
        OSD.unlink_osd_Request request2 = OSD.unlink_osd_Request.newBuilder().setFileId(response.getXcap().getFileId()).setFileCredentials(response).build();
        RPCCaller.syncCall(GlobalTypes.SERVICES.OSD, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, osdUuidIterator, false, request2, new RPCCaller.CallGenerator<OSD.unlink_osd_Request, Common.emptyResponse>(){

            @Override
            public RPCResponse<Common.emptyResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, OSD.unlink_osd_Request input) throws IOException {
                return VolumeImplementation.this.osdServiceClient.unlink(server, authHeader, userCreds, input);
            }
        });
        if (this.openFileTable.containsKey(response.getXcap().getFileId())) {
            AdminFileHandle file = this.openFile(userCredentials, path, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
            file.close();
        }
    }

    @Override
    public void removeACL(RPC.UserCredentials userCreds, String path, String user) throws IOException {
        HashSet<String> elements = new HashSet<String>();
        elements.add(user);
        this.removeACL(userCreds, path, elements);
    }

    @Override
    public void removeACL(RPC.UserCredentials userCreds, String path, Set<String> aclEntries) throws IOException {
        for (String entity : aclEntries) {
            if (entity.equals("u:") || entity.equals("g:") || entity.equals("o:") || entity.equals("m:")) continue;
            this.setXAttr(userCreds, path, "xtreemfs.acl", "x " + entity, MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
        }
    }

    @Override
    public void setACL(RPC.UserCredentials userCreds, String path, String user, String accessrights) throws IOException {
        HashMap<String, Object> elements = new HashMap<String, Object>();
        elements.put(user, accessrights);
        this.setACL(userCreds, path, elements);
    }

    @Override
    public void setACL(RPC.UserCredentials userCreds, String path, Map<String, Object> aclEntries) throws IOException {
        for (Map.Entry<String, Object> entry : aclEntries.entrySet()) {
            this.setXAttr(userCreds, path, "xtreemfs.acl", "m " + entry.getKey() + ":" + entry.getValue(), MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
        }
    }

    @Override
    public Map<String, Object> listACL(RPC.UserCredentials userCreds, String path) throws IOException {
        try {
            String aclAsJSON = this.getXAttr(userCreds, path, "xtreemfs.acl");
            return (Map)JSONParser.parseJSON(new JSONString(aclAsJSON));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<String> getSuitableOSDs(RPC.UserCredentials userCredentials, String path, int numberOfOsds) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        MRC.xtreemfs_get_suitable_osdsRequest request = MRC.xtreemfs_get_suitable_osdsRequest.newBuilder().setVolumeName(this.volumeName).setPath(path).setNumOsds(numberOfOsds).build();
        MRC.xtreemfs_get_suitable_osdsResponse response = RPCCaller.syncCall(GlobalTypes.SERVICES.MRC, userCredentials, this.authBogus, this.volumeOptions, this.uuidResolver, this.mrcUUIDIterator, false, request, new RPCCaller.CallGenerator<MRC.xtreemfs_get_suitable_osdsRequest, MRC.xtreemfs_get_suitable_osdsResponse>(){

            @Override
            public RPCResponse<MRC.xtreemfs_get_suitable_osdsResponse> executeCall(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, MRC.xtreemfs_get_suitable_osdsRequest input) throws IOException {
                return VolumeImplementation.this.mrcServiceClient.xtreemfs_get_suitable_osds(server, authHeader, userCreds, input);
            }
        });
        assert (response != null);
        return response.getOsdUuidsList();
    }

    @Override
    public void setDefaultReplicationPolicy(RPC.UserCredentials userCredentials, String directory, String replicationPolicy, int replicationFactor, int replicationFlags) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        String JSON = "{ \"replication-factor\": " + String.valueOf(replicationFactor) + "," + "\"update-policy\": " + "\"" + replicationPolicy + "\"," + "\"replication-flags\": " + String.valueOf(replicationFlags) + " }";
        this.setXAttr(userCredentials, directory, XTREEMFS_DEFAULT_RP, JSON, MRC.XATTR_FLAGS.XATTR_FLAGS_CREATE);
    }

    @Override
    public ReplicationPolicy getDefaultReplicationPolicy(RPC.UserCredentials userCredentials, String directory) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        String updatePolicy;
        int replicationFactor;
        int replicationFlags;
        Map replicationPolicyMap;
        Object replicationPolicyObject;
        try {
            String rpAsJSON = this.getXAttr(userCredentials, directory, XTREEMFS_DEFAULT_RP);
            replicationPolicyObject = JSONParser.parseJSON(new JSONString(rpAsJSON));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        try {
            replicationPolicyMap = (Map)replicationPolicyObject;
        }
        catch (ClassCastException e) {
            throw new IOException("JSON response does not contain a Map.", e);
        }
        if (!(replicationPolicyMap.containsKey("replication-factor") && replicationPolicyMap.containsKey("update-policy") && replicationPolicyMap.containsKey("replication-flags"))) {
            throw new IOException("Incomplete JSON response from MRC.");
        }
        try {
            replicationFlags = ((Long)replicationPolicyMap.get("replication-flags")).intValue();
            replicationFactor = ((Long)replicationPolicyMap.get("replication-factor")).intValue();
            updatePolicy = (String)replicationPolicyMap.get("update-policy");
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
        return new ReplicationPolicyImplementation(updatePolicy, replicationFactor, replicationFlags);
    }

    protected void closeFile(long fileId, FileInfo fileInfo, FileHandleImplementation fileHandle) {
        if (fileInfo.decreaseReferenceCount() == 0) {
            try {
                fileInfo.releaseAllLocks(fileHandle);
            }
            catch (XtreemFSException e) {
                // empty catch block
            }
            fileInfo.waitForPendingFileSizeUpdates();
            this.openFileTable.remove(fileId);
            GlobalTypes.OSDWriteResponse response = fileInfo.getOSDWriteResponse();
            if (response != null) {
                String path = fileInfo.getPath();
                this.metadataCache.updateStatFromOSDWriteResponse(path, response);
            }
        }
    }

    private FileInfo getOrCreateFileInfo(long fileId, String path, boolean replicateOnClose, GlobalTypes.XLocSet xlocset) {
        FileInfo fileInfo = this.openFileTable.get(fileId);
        if (fileInfo != null) {
            fileInfo.updateXLocSetAndRest(xlocset, replicateOnClose);
            return fileInfo;
        }
        fileInfo = new FileInfo(this, fileId, path, replicateOnClose, xlocset, this.clientUuid);
        this.openFileTable.put(fileId, fileInfo);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "Created a new FileInfo object for the fileId: %s", fileId);
        }
        return fileInfo;
    }

    protected UUIDIterator getMrcUuidIterator() {
        return this.mrcUUIDIterator;
    }

    protected UUIDResolver getUUIDResolver() {
        return this.uuidResolver;
    }

    protected MRCServiceClient getMrcServiceClient() {
        return this.mrcServiceClient;
    }

    protected OSDServiceClient getOsdServiceClient() {
        return this.osdServiceClient;
    }

    protected Options getOptions() {
        return this.volumeOptions;
    }

    protected ConcurrentHashMap<Long, FileInfo> getOpenFileTable() {
        return this.openFileTable;
    }

    protected RPC.Auth getAuthBogus() {
        return this.authBogus;
    }

    protected RPC.UserCredentials getUserCredentialsBogus() {
        return this.userCredentialsBogus;
    }

    protected Map<GlobalTypes.StripingPolicyType, StripeTranslator> getStripeTranslators() {
        return this.stripeTranslators;
    }

    protected MetadataCache getMetaDataCache() {
        return this.metadataCache;
    }

    @Override
    public List<Volume.StripeLocation> getStripeLocations(RPC.UserCredentials userCredentials, String path, long startSize, long length) throws IOException, PosixErrorException, AddressToUUIDNotFoundException {
        FileHandleImplementation fileHandle = (FileHandleImplementation)this.openFile(userCredentials, path, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
        GlobalTypes.XLocSet xLocs = fileHandle.getXlocSet();
        fileHandle.close();
        long stripeSize = xLocs.getReplicas(0).getStripingPolicy().getStripeSize() * 1024;
        long indexOfFirstStripeToConsider = startSize / stripeSize;
        long remainingLengthOfFirstStripe = Math.min(length, stripeSize - startSize % stripeSize);
        int numberOfStrips = (int)(length / stripeSize + 1L);
        ArrayList<Volume.StripeLocation> stripeLocations = new ArrayList<Volume.StripeLocation>(numberOfStrips);
        ArrayList<String> uuids = this.getUuidsForStripeFromReplicas(xLocs.getReplicasList(), indexOfFirstStripeToConsider);
        ArrayList<String> hostnames = this.resolveHostnamesFromUuids(uuids);
        stripeLocations.add(new Volume.StripeLocation(startSize, remainingLengthOfFirstStripe, uuids.toArray(new String[uuids.size()]), hostnames.toArray(new String[hostnames.size()])));
        long index = indexOfFirstStripeToConsider + 1L;
        while (index * stripeSize < startSize + length) {
            uuids = this.getUuidsForStripeFromReplicas(xLocs.getReplicasList(), index);
            hostnames = this.resolveHostnamesFromUuids(uuids);
            stripeLocations.add(new Volume.StripeLocation(index * stripeSize, Math.min(stripeSize, startSize + length - index * stripeSize), uuids.toArray(new String[uuids.size()]), hostnames.toArray(new String[hostnames.size()])));
            ++index;
        }
        return stripeLocations;
    }

    @Override
    public long getNumObjects(RPC.UserCredentials userCredentials, String path) throws IOException {
        GlobalTypes.StripingPolicy stripingPolicy = this.listReplicas(userCredentials, path).getReplicas(0).getStripingPolicy();
        MRC.Stat fileAttr = this.getAttr(userCredentials, path);
        return Helper.getNumObjects(userCredentials, fileAttr, stripingPolicy);
    }

    private ArrayList<String> resolveHostnamesFromUuids(ArrayList<String> uuids) throws AddressToUUIDNotFoundException {
        ArrayList<String> hostnames = new ArrayList<String>();
        for (int i = 0; i < uuids.size(); ++i) {
            String hostname = this.uuidResolver.uuidToAddress(uuids.get(i));
            if (this.isIpAddress(hostname = hostname.substring(0, hostname.lastIndexOf(58)))) {
                try {
                    InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(hostname), 0);
                    hostname = address.getHostName();
                }
                catch (Exception e) {
                    hostname = null;
                }
                if (hostname == null) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "Couldn't resolve hostname for uuid %s", uuids.get(i));
                    }
                    uuids.remove(i);
                    --i;
                    continue;
                }
                hostnames.add(hostname);
                continue;
            }
            hostnames.add(hostname);
        }
        return hostnames;
    }

    private ArrayList<String> getUuidsForStripeFromReplicas(List<GlobalTypes.Replica> replicasList, long stripeIndex) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (GlobalTypes.Replica replica : replicasList) {
            int osdIndex = (int)stripeIndex % replica.getStripingPolicy().getWidth();
            uuids.add(replica.getOsdUuids(osdIndex));
        }
        return uuids;
    }

    private boolean isIpAddress(String hostname) {
        String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        Pattern pattern = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
        return pattern.matcher(hostname).matches();
    }

    @Override
    public String getOSDSelectionPolicy(RPC.UserCredentials userCreds) throws IOException {
        return this.getXAttr(userCreds, "/", OSD_SELECTION_POLICY);
    }

    @Override
    public void setOSDSelectionPolicy(RPC.UserCredentials userCreds, String policies) throws IOException {
        this.setXAttr(userCreds, "/", OSD_SELECTION_POLICY, policies, MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
    }

    @Override
    public String getReplicaSelectionPolicy(RPC.UserCredentials userCreds) throws IOException {
        return this.getXAttr(userCreds, "/", REPLICA_SELECTION_POLICY);
    }

    @Override
    public void setReplicaSelectionPolicy(RPC.UserCredentials userCreds, String policies) throws IOException {
        this.setXAttr(userCreds, "/", REPLICA_SELECTION_POLICY, policies, MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
    }

    @Override
    public void setPolicyAttribute(RPC.UserCredentials userCreds, String attribute, String value) throws IOException {
        this.setXAttr(userCreds, "/", "xtreemfs.policies." + attribute, value, MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }
}

