/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.monitoring;

import com.sun.management.snmp.SnmpStatusException;
import javax.management.MBeanServer;
import org.xtreemfs.common.monitoring.StatusMonitor;
import org.xtreemfs.common.monitoring.XTREEMFS_MIBImpl;
import org.xtreemfs.common.monitoring.generatedcode.General;

public class GeneralImpl
extends General {
    private StatusMonitor statusMonitor;

    public GeneralImpl(XTREEMFS_MIBImpl myMib, StatusMonitor statusMonitor) {
        super(myMib);
        this.statusMonitor = statusMonitor;
    }

    public GeneralImpl(XTREEMFS_MIBImpl myMib, MBeanServer server, StatusMonitor statusMonitor) {
        super(myMib, server);
        this.statusMonitor = statusMonitor;
    }

    @Override
    public Long getJvmMaxMemory() throws SnmpStatusException {
        return Runtime.getRuntime().maxMemory();
    }

    @Override
    public Long getJvmUsedMemory() throws SnmpStatusException {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public Long getJvmFreeMemory() throws SnmpStatusException {
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public String getDatabaseVersion() throws SnmpStatusException {
        return "0.5.6";
    }

    @Override
    public Integer getTcpPort() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return this.statusMonitor.getDirConfig().getPort();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return this.statusMonitor.getMrcConfig().getPort();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return this.statusMonitor.getOsdConfig().getPort();
        }
        return -1;
    }

    @Override
    public Integer getDebugLevel() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return this.statusMonitor.getDirConfig().getDebugLevel();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return this.statusMonitor.getMrcConfig().getDebugLevel();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return this.statusMonitor.getOsdConfig().getDebugLevel();
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public Integer getRpcInterface() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return 10001;
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return 20001;
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return 30001;
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public Integer getNumClientConnections() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return this.statusMonitor.getMasterDIR().getNumConnections();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return this.statusMonitor.getMasterMRC().getNumConnections();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return this.statusMonitor.getMasterOSD().getNumClientConnections();
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public Long getNumPendingRequests() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return this.statusMonitor.getMasterDIR().getNumRequests();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return this.statusMonitor.getMasterMRC().getNumRequests();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return this.statusMonitor.getMasterOSD().getPendingRequests();
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public Long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public String getServiceType() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return "DIR";
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return "MRC";
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return "OSD";
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public String getIsRunning() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return "ONLINE";
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            long difference = System.currentTimeMillis() - this.statusMonitor.getMasterMRC().getLastHeartbeat();
            if (difference > 600000L) {
                return "OFFLINE";
            }
            return "ONLINE";
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            long difference = System.currentTimeMillis() - this.statusMonitor.getMasterOSD().getLastHeartbeat();
            if (difference > 600000L) {
                return "OFFLINE";
            }
            return "ONLINE";
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }

    @Override
    public String getServiceUUID() throws SnmpStatusException {
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.DIR)) {
            return this.statusMonitor.getDirConfig().getUUID().toString();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.MRC)) {
            return this.statusMonitor.getMrcConfig().getUUID().toString();
        }
        if (this.statusMonitor.getInitiatingService().equals((Object)StatusMonitor.ServiceTypes.OSD)) {
            return this.statusMonitor.getOsdConfig().getUUID().toString();
        }
        throw new SnmpStatusException("Internal error. Couldn't fetch values.");
    }
}

