/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.monitoring;

import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.snmp.IPAcl.JdmkAcl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.agent.SnmpMibHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xtreemfs.common.monitoring.DirImpl;
import org.xtreemfs.common.monitoring.MrcImpl;
import org.xtreemfs.common.monitoring.OsdImpl;
import org.xtreemfs.common.monitoring.XTREEMFS_MIBImpl;
import org.xtreemfs.common.monitoring.generatedcode.XTREEMFS_MIB;
import org.xtreemfs.dir.DIRConfig;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.DIRStatusListener;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.MRCConfig;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.MRCStatusListener;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.OSDStatusListener;

public class StatusMonitor
implements DIRStatusListener,
MRCStatusListener,
OSDStatusListener {
    private DIRConfig dirConfig = null;
    private MRCConfig mrcConfig = null;
    private OSDConfig osdConfig = null;
    private DIRRequestDispatcher masterDIR = null;
    private MRCRequestDispatcher masterMRC = null;
    private OSDRequestDispatcher masterOSD = null;
    private SnmpAdaptorServer snmpAdaptor = null;
    private XTREEMFS_MIB xtfsmib = null;
    private DirImpl dirGroup = null;
    private MrcImpl mrcGroup = null;
    private OsdImpl osdGroup = null;
    private ServiceTypes initiatingService = null;

    public StatusMonitor(DIRRequestDispatcher dirReqDisp, int port) {
        this(ServiceTypes.DIR, null, port, null);
        this.masterDIR = dirReqDisp;
    }

    public StatusMonitor(DIRRequestDispatcher dirReqDisp, InetAddress addr, int port) {
        this(ServiceTypes.DIR, addr, port, null);
        this.masterDIR = dirReqDisp;
    }

    public StatusMonitor(DIRRequestDispatcher dirReqDisp, int port, String aclFile) {
        this(ServiceTypes.DIR, null, port, aclFile);
        this.masterDIR = dirReqDisp;
    }

    public StatusMonitor(DIRRequestDispatcher dirReqDisp, InetAddress addr, int port, String aclFile) {
        this(ServiceTypes.DIR, addr, port, aclFile);
        this.masterDIR = dirReqDisp;
    }

    public StatusMonitor(MRCRequestDispatcher mrcReqDisp, int port) {
        this(ServiceTypes.MRC, null, port, null);
        this.masterMRC = mrcReqDisp;
    }

    public StatusMonitor(MRCRequestDispatcher mrcReqDisp, InetAddress addr, int port) {
        this(ServiceTypes.MRC, addr, port, null);
        this.masterMRC = mrcReqDisp;
    }

    public StatusMonitor(MRCRequestDispatcher mrcReqDisp, int port, String aclFile) {
        this(ServiceTypes.MRC, null, port, aclFile);
        this.masterMRC = mrcReqDisp;
    }

    public StatusMonitor(MRCRequestDispatcher mrcReqDisp, InetAddress addr, int port, String aclFile) {
        this(ServiceTypes.MRC, addr, port, aclFile);
        this.masterMRC = mrcReqDisp;
    }

    public StatusMonitor(OSDRequestDispatcher osdReqDisp, int port) {
        this(ServiceTypes.OSD, null, port, null);
        this.masterOSD = osdReqDisp;
    }

    public StatusMonitor(OSDRequestDispatcher osdReqDisp, InetAddress addr, int port) {
        this(ServiceTypes.OSD, addr, port, null);
        this.masterOSD = osdReqDisp;
    }

    public StatusMonitor(OSDRequestDispatcher osdReqDisp, int port, String aclFile) {
        this(ServiceTypes.OSD, null, port, aclFile);
        this.masterOSD = osdReqDisp;
    }

    public StatusMonitor(OSDRequestDispatcher osdReqDisp, InetAddress addr, int port, String aclFile) {
        this(ServiceTypes.OSD, addr, port, aclFile);
        this.masterOSD = osdReqDisp;
    }

    private StatusMonitor(ServiceTypes type, InetAddress addr, int port, String aclFile) {
        this.initiatingService = type;
        JdmkAcl acl = null;
        if (aclFile != null) {
            try {
                acl = new JdmkAcl("Xtreemfs ACL", aclFile);
            }
            catch (IllegalArgumentException iae) {
                Logging.logMessage(3, Logging.Category.misc, this, "ACL file problem. The file %s is not a valid ACL file or did not exist.", aclFile);
            }
            catch (UnknownHostException uhe) {
                Logging.logMessage(6, Logging.Category.misc, this, "", uhe.getMessage());
            }
        }
        if (acl == null) {
            Logging.logMessage(5, Logging.Category.misc, this, "SNMP agen will start without a ACL file. Everyone on your network can access the information exposed by the SNMP agent!", new Object[0]);
        }
        this.snmpAdaptor = addr != null ? new SnmpAdaptorServer((InetAddressAcl)acl, port, addr) : new SnmpAdaptorServer((InetAddressAcl)acl, port);
        this.snmpAdaptor.start();
        try {
            this.snmpAdaptor.setTrapPort(Integer.valueOf(port + 1));
            this.snmpAdaptor.snmpV1Trap(0, 0, null);
            Logging.logMessage(6, Logging.Category.misc, this, "SNMP agent started at port %s", port);
        }
        catch (Exception e) {
            Logging.logMessage(3, Logging.Category.misc, this, "Failed to start SNMP agent at port %s", port);
        }
        this.xtfsmib = new XTREEMFS_MIBImpl(this);
        try {
            this.xtfsmib.init();
        }
        catch (IllegalAccessException e) {
            Logging.logMessage(3, Logging.Category.misc, this, "Failed to start SNMP agent: %s", e.getMessage());
        }
        this.xtfsmib.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
    }

    protected ServiceTypes getInitiatingService() {
        return this.initiatingService;
    }

    protected DIRConfig getDirConfig() {
        return this.dirConfig;
    }

    protected MRCConfig getMrcConfig() {
        return this.mrcConfig;
    }

    protected OSDConfig getOsdConfig() {
        return this.osdConfig;
    }

    public DIRRequestDispatcher getMasterDIR() {
        return this.masterDIR;
    }

    public MRCRequestDispatcher getMasterMRC() {
        return this.masterMRC;
    }

    public OSDRequestDispatcher getMasterOSD() {
        return this.masterOSD;
    }

    @Override
    public void addressMappingAdded() {
        this.dirGroup.addressMappingAdded();
    }

    @Override
    public void addressMappingDeleted() {
        this.dirGroup.addressMappingDeleted();
    }

    @Override
    public void DIRConfigChanged(DIRConfig config) {
        this.dirConfig = config;
    }

    @Override
    public void serviceRegistered() {
        this.dirGroup.serviceRegistered();
    }

    @Override
    public void serviceDeregistered() {
        this.dirGroup.serviceDeregistered();
    }

    protected void setDirGroup(DirImpl dirGroup) {
        this.dirGroup = dirGroup;
    }

    protected void setMrcGroup(MrcImpl mrcGroup) {
        this.mrcGroup = mrcGroup;
    }

    protected void setOsdGroup(OsdImpl osdGroup) {
        this.osdGroup = osdGroup;
    }

    @Override
    public void MRCConfigChanged(MRCConfig config) {
        this.mrcConfig = config;
    }

    @Override
    public void volumeCreated() {
        this.mrcGroup.volumeCreated();
    }

    @Override
    public void volumeDeleted() {
        this.mrcGroup.volumeDeleted();
    }

    @Override
    public void OSDConfigChanged(OSDConfig config) {
        this.osdConfig = config;
    }

    @Override
    public void numBytesTXChanged(long numBytesTX) {
        this.osdGroup.setNumBytesTX(numBytesTX);
    }

    @Override
    public void numBytesRXChanged(long numBytesRX) {
        this.osdGroup.setNumBytesRX(numBytesRX);
    }

    @Override
    public void numReplBytesRXChanged(long numReplBytesRX) {
        this.osdGroup.setNumReplBytesRX(numReplBytesRX);
    }

    @Override
    public void numObjsTXChanged(long numObjsTX) {
        this.osdGroup.setNumObjsTX(numObjsTX);
    }

    @Override
    public void numObjsRXChanged(long numObjsRX) {
        this.osdGroup.setNumObjsRX(numObjsRX);
    }

    @Override
    public void numReplObjsRX(long numReplObjsRX) {
        this.osdGroup.setNumReplObjsRX(numReplObjsRX);
    }

    @Override
    public void shuttingDown() {
        this.snmpAdaptor.stop();
    }

    protected static enum ServiceTypes {
        DIR,
        MRC,
        OSD;

    }
}

