/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.statusserver;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class BabuDBStatusPage
extends StatusServerModule {
    private final BabuDBStatusProvider statusProvider;

    public BabuDBStatusPage(BabuDBStatusProvider statusProvider) {
        this.statusProvider = statusProvider;
    }

    @Override
    public String getDisplayName() {
        return "BabuDB Status Summary";
    }

    @Override
    public String getUriPath() {
        return "/babudb";
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML><BODY><H1>BABUDB STATE</H1>");
        Map<String, Object> dbStatus = this.statusProvider.getStatus();
        if (dbStatus == null) {
            sb.append("BabuDB has not yet been initialized.");
        } else {
            sb.append("<TABLE>");
            TreeMap<String, Object> status = new TreeMap<String, Object>(dbStatus);
            for (Map.Entry entry : status.entrySet()) {
                sb.append("<TR><TD STYLE=\"text-align:right; font-style:italic\">");
                sb.append((String)entry.getKey());
                sb.append(":</TD><TD STYLE=\"font-weight:bold\">");
                sb.append(entry.getValue());
                sb.append("</TD></TR>");
            }
            sb.append("</TABLE>");
        }
        sb.append("</BODY></HTML>");
        this.sendResponse(httpExchange, sb.toString());
        httpExchange.close();
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return true;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
    }

    @Override
    public void shutdown() {
    }

    public static interface BabuDBStatusProvider {
        public Map<String, Object> getStatus();
    }
}

