/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.statusserver;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class StatusServer {
    private static final double MAX_TIME_CHECK_IF_ADDRESS_ALREADY_IN_USE_S = 180.0;
    private static final double INTERVAL_CHECK_IF_ADDRESS_ALREADY_IN_USE_S = 0.1;
    private final int statusHttpPort;
    private final List<StatusServerModule> modules;
    private final DIR.ServiceType serviceType;
    private final Object serviceRequestDispatcher;
    private final Map<String, String> authorizedUsers;
    private HttpServer httpServ;
    private BasicAuthenticator passwordProtection;
    private boolean running;

    public StatusServer(DIR.ServiceType serviceType, Object serviceRequestDispatcher, int statusHttpPort) {
        this.serviceType = serviceType;
        this.serviceRequestDispatcher = serviceRequestDispatcher;
        this.statusHttpPort = statusHttpPort;
        this.authorizedUsers = new HashMap<String, String>();
        this.modules = new ArrayList<StatusServerModule>();
        this.running = false;
    }

    public void addAuthorizedUser(String userName, String password) {
        if (this.running) {
            throw new IllegalStateException("Cannot add users after startup.");
        }
        this.authorizedUsers.put(userName, password);
    }

    public void start() throws IOException {
        this.passwordProtection = !this.authorizedUsers.isEmpty() ? new BasicAuthenticator("XtreemFS " + this.serviceType){

            @Override
            public boolean checkCredentials(String userName, String password) {
                String storedPassword = (String)StatusServer.this.authorizedUsers.get(userName);
                return storedPassword != null && storedPassword.equals(password);
            }
        } : null;
        for (double elapsedSeconds = 0.0; elapsedSeconds < 180.0; elapsedSeconds += 0.1) {
            try {
                this.httpServ = HttpServer.create(new InetSocketAddress(this.statusHttpPort), 0);
                break;
            }
            catch (BindException e) {
                if (e.getMessage().contains("Address already in use")) {
                    if (elapsedSeconds + 0.1 >= 180.0) {
                        throw new BindException(e.getMessage() + ". Port number: " + this.statusHttpPort);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                throw e;
            }
        }
        this.running = true;
        for (StatusServerModule module : this.modules) {
            String modulePath = module.getUriPath();
            if (modulePath.isEmpty()) {
                Logging.logMessage(3, this, "Invalid path or path for module %s", module.getClass().getCanonicalName());
            }
            HttpContext context = this.httpServ.createContext(module.getUriPath(), module);
            if (this.passwordProtection != null) {
                context.setAuthenticator(this.passwordProtection);
            }
            module.initialize(this.serviceType, this.serviceRequestDispatcher);
        }
        this.httpServ.start();
    }

    public void shutdown() {
        if (this.running) {
            this.httpServ.stop(0);
            for (StatusServerModule module : this.modules) {
                module.shutdown();
            }
        }
    }

    public void registerModule(StatusServerModule module) {
        if (this.running) {
            throw new IllegalStateException("Cannot add modules after calling start()");
        }
        if (module.isAvailableForService(this.serviceType)) {
            this.modules.add(module);
        } else {
            Logging.logMessage(6, this, "Module %s not suitable for service %s, skipping module", module.getClass().getCanonicalName(), this.serviceType);
        }
    }
}

