/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.statusserver;

import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;

public class StatusServerHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readTemplate(String name) {
        StringBuffer sb = null;
        BufferedReader br = null;
        try {
            InputStream is = StatusServerHelper.class.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                throw new FileNotFoundException();
            }
            br = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            sb = null;
            Logging.logMessage(4, Logging.Category.misc, (Object)null, "could not load page template '%s': %s", name, OutputUtils.stackTraceToString(ex));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(String name, HttpExchange httpExchange) throws IOException {
        InputStream htmlFile = null;
        try {
            htmlFile = StatusServerHelper.class.getClassLoader().getResourceAsStream(name);
            if (htmlFile == null) {
                throw new FileNotFoundException();
            }
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            httpExchange.sendResponseHeaders(200, 0L);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = htmlFile.read(buffer)) >= 0) {
                httpExchange.getResponseBody().write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            byte[] msg = ("Sorry, could not read the requested file " + name + " (" + e.toString() + ")").getBytes("ascii");
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            httpExchange.sendResponseHeaders(404, msg.length);
            httpExchange.getResponseBody().write(msg);
            Logging.logMessage(4, Logging.Category.misc, (Object)null, "could not read page '%s': %s", name, OutputUtils.stackTraceToString(e));
        }
        finally {
            httpExchange.close();
            if (htmlFile != null) {
                try {
                    htmlFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

