/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class NetUtils {
    public static List<DIR.AddressMapping.Builder> getReachableEndpoints(int port, String protocol) throws IOException {
        ArrayList<DIR.AddressMapping.Builder> endpoints = new ArrayList<DIR.AddressMapping.Builder>();
        ArrayList<DIR.AddressMapping.Builder> localEndpoints = new ArrayList<DIR.AddressMapping.Builder>();
        Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
        while (ifcs.hasMoreElements()) {
            NetworkInterface ifc = ifcs.nextElement();
            if (ifc.isLoopback() || !ifc.isUp()) continue;
            List<InterfaceAddress> addrs = ifc.getInterfaceAddresses();
            for (InterfaceAddress addr : addrs) {
                InetAddress inetAddr = addr.getAddress();
                if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isAnyLocalAddress() || inetAddr.isMulticastAddress()) continue;
                String hostAddr = NetUtils.getHostAddress(inetAddr);
                String uri = NetUtils.getURI(protocol, inetAddr, port);
                String network = NetUtils.getNetworkCIDR(inetAddr, addr.getNetworkPrefixLength());
                DIR.AddressMapping.Builder amap = DIR.AddressMapping.newBuilder().setAddress(hostAddr).setPort(port).setMatchNetwork(network).setProtocol(protocol).setTtlS(3600).setUri(uri).setVersion(0L).setUuid("");
                if (inetAddr.isSiteLocalAddress()) {
                    localEndpoints.add(amap);
                    continue;
                }
                endpoints.add(amap);
            }
        }
        endpoints.addAll(localEndpoints);
        return endpoints;
    }

    public static String getHostAddress(InetAddress host) {
        String hostAddr = host.getHostAddress();
        if (host instanceof Inet6Address && hostAddr.lastIndexOf(37) >= 0) {
            hostAddr = hostAddr.substring(0, hostAddr.lastIndexOf(37));
        }
        return hostAddr;
    }

    public static String getURI(String protocol, InetAddress host, int port) {
        String hostAddr = host.getHostAddress();
        if (host instanceof Inet6Address) {
            if (hostAddr.lastIndexOf(37) >= 0) {
                hostAddr = hostAddr.substring(0, hostAddr.lastIndexOf(37));
            }
            hostAddr = "[" + hostAddr + "]";
        }
        return protocol + "://" + hostAddr + ":" + port;
    }

    public static DIR.AddressMapping.Builder cloneMappingForProtocol(DIR.AddressMapping.Builder src, String protocol) {
        String uri = protocol + src.getUri().substring(src.getUri().indexOf("://"));
        DIR.AddressMapping.Builder result = src.clone().setProtocol(protocol).setUri(uri);
        return result;
    }

    public static String getDomain(String hostName) {
        int i = hostName.indexOf(46);
        return i == -1 ? "" : hostName.substring(i + 1);
    }

    private static String getSubnetMaskString(short prefixLength) {
        long addr = 0xFFFFFFFFL << 32 - prefixLength & 0xFFFFFFFFL;
        StringBuffer sb = new StringBuffer();
        for (int i = 3; i >= 0; --i) {
            sb.append((addr & (long)(255 << i * 8)) >> i * 8);
            if (i <= 0) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static String getNetworkCIDR(InetAddress addr, short prefixLength) {
        byte[] raw = addr.getAddress();
        boolean isV6 = raw.length > 4;
        int networkFields = prefixLength / 8;
        for (int i = networkFields + 1; i < raw.length; ++i) {
            raw[i] = 0;
        }
        int networkRemainder = prefixLength % 8;
        if (networkFields < raw.length) {
            byte mask = (byte)(255 << 8 - networkRemainder);
            raw[networkFields] = (byte)(raw[networkFields] & mask);
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(InetAddress.getByAddress(raw).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        sb.append("/").append(prefixLength);
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("all network interfaces: ");
        Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
        while (ifcs.hasMoreElements()) {
            for (InterfaceAddress addr : ifcs.nextElement().getInterfaceAddresses()) {
                InetAddress inetAddr = addr.getAddress();
                System.out.println(inetAddr + ", loopback: " + inetAddr.isLoopbackAddress() + ", linklocal: " + inetAddr.isLinkLocalAddress() + ", reachable: " + inetAddr.isReachable(1000));
            }
        }
        System.out.println("\nsuitable network interfaces: ");
        for (DIR.AddressMapping.Builder endpoint : NetUtils.getReachableEndpoints(32640, "http")) {
            System.out.println(endpoint.build().toString());
        }
    }
}

