/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.uuids;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.xtreemfs.common.uuids.Mapping;
import org.xtreemfs.common.uuids.UUIDCacheEntry;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.ASCIIString;

public final class ServiceUUID
implements Serializable,
Comparable {
    private final String uuid;
    private long validUntil;
    private UUIDCacheEntry cacheEntry;
    private final UUIDResolver nonSingleton;

    public ServiceUUID(String uuid) {
        this.uuid = uuid;
        this.validUntil = 0L;
        this.nonSingleton = null;
    }

    public ServiceUUID(String uuid, UUIDResolver nonSingleton) {
        this.uuid = uuid;
        this.validUntil = 0L;
        this.nonSingleton = nonSingleton;
    }

    public ServiceUUID(ASCIIString uuid) {
        this(uuid.toString());
    }

    public void resolve() throws UnknownUUIDException {
        this.resolve(null);
    }

    public void resolve(String protocol) throws UnknownUUIDException {
        this.updateMe(protocol);
    }

    public Mapping[] getMappings() throws UnknownUUIDException {
        if (this.validUntil > TimeSync.getLocalSystemTime()) {
            this.cacheEntry.setLastAccess(TimeSync.getLocalSystemTime());
        } else {
            this.updateMe();
        }
        return this.cacheEntry.getMappings();
    }

    public InetSocketAddress getAddress() throws UnknownUUIDException {
        return this.getMappings()[0].resolvedAddr;
    }

    public String getAddressString() throws UnknownUUIDException {
        return this.getMappings()[0].address;
    }

    public String toURL() throws UnknownUUIDException {
        if (this.validUntil > TimeSync.getLocalSystemTime()) {
            this.cacheEntry.setLastAccess(TimeSync.getLocalSystemTime());
        } else {
            this.updateMe();
        }
        return this.cacheEntry.toString();
    }

    public String debugString() {
        String mappingsStr = this.cacheEntry == null ? "" : Arrays.toString(this.cacheEntry.getMappings());
        return this.uuid + " -> " + mappingsStr + " (still valid for " + (this.validUntil - TimeSync.getLocalSystemTime()) / 1000L + "s)";
    }

    public String toString() {
        return this.uuid;
    }

    public boolean equals(Object other) {
        try {
            ServiceUUID o = (ServiceUUID)other;
            return this.uuid.equals(o.uuid);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    private void updateMe() throws UnknownUUIDException {
        this.updateMe(null);
    }

    private void updateMe(String protocol) throws UnknownUUIDException {
        this.cacheEntry = this.nonSingleton == null ? UUIDResolver.resolve(this.uuid, protocol) : UUIDResolver.resolve(this.uuid, protocol, this.nonSingleton);
        this.validUntil = this.cacheEntry.getValidUntil();
    }

    public int compareTo(Object o) {
        return this.uuid.compareTo((String)o);
    }
}

