/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.uuids;

import org.xtreemfs.common.uuids.Mapping;
import org.xtreemfs.foundation.TimeSync;

class UUIDCacheEntry {
    private String uuid;
    private Mapping[] mappings;
    private long validUntil;
    private long lastAccess;
    private boolean sticky;

    public UUIDCacheEntry(String uuid, long validUntil, Mapping ... mappings) {
        this.uuid = uuid;
        this.mappings = mappings;
        this.validUntil = validUntil;
        this.lastAccess = TimeSync.getLocalSystemTime();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public void setMappings(Mapping ... mappings) {
        this.mappings = mappings;
    }

    public void addMapping(Mapping mapping) {
        Mapping[] tmp = this.mappings;
        this.mappings = new Mapping[tmp.length + 1];
        System.arraycopy(tmp, 0, this.mappings, 0, tmp.length);
        this.mappings[this.mappings.length - 1] = mapping;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Mapping mapping : this.mappings) {
            sb.append(mapping.protocol);
            sb.append("://");
            sb.append(mapping.resolvedAddr.toString());
            sb.append(",");
        }
        return sb.toString();
    }
}

