/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.uuids;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xtreemfs.common.GlobalConstants;
import org.xtreemfs.common.util.NetUtils;
import org.xtreemfs.common.uuids.Mapping;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDCacheEntry;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public final class UUIDResolver
extends Thread {
    Map<String, UUIDCacheEntry> cache;
    protected transient boolean quit;
    protected final DIRClient dir;
    protected final List<String> myNetworks;
    public final int cacheCleanInterval;
    public final int maxUnusedEntry;
    protected static UUIDResolver theInstance;
    protected final RPC.UserCredentials uc;

    protected UUIDResolver(DIRClient client, int cacheCleanInterval, int maxUnusedEntry, boolean singleton) throws IOException {
        super("UUID Resolver");
        this.setDaemon(true);
        this.cache = new ConcurrentHashMap<String, UUIDCacheEntry>();
        this.quit = false;
        this.dir = client;
        this.maxUnusedEntry = maxUnusedEntry;
        this.cacheCleanInterval = cacheCleanInterval;
        this.uc = RPC.UserCredentials.newBuilder().setUsername("uuidresolver").addGroups("xtreemfs-services").build();
        this.myNetworks = new ArrayList<String>();
        UUIDResolver.renewNetworks(this);
        if (singleton) {
            assert (theInstance == null);
            theInstance = this;
        }
    }

    public static synchronized void start(DIRClient client, int cacheCleanInterval, int maxUnusedEntry) throws IOException {
        if (theInstance == null) {
            new UUIDResolver(client, cacheCleanInterval, maxUnusedEntry, true);
            theInstance.start();
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, null, "started UUIDResolver", new Object[0]);
            }
        } else if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, null, "UUIDResolver already running!", new Object[0]);
        }
    }

    public static synchronized UUIDResolver startNonSingelton(DIRClient client, int cacheCleanInterval, int maxUnusedEntry) throws IOException {
        UUIDResolver tmp = new UUIDResolver(client, cacheCleanInterval, maxUnusedEntry, false);
        tmp.start();
        return tmp;
    }

    public static boolean isRunning() {
        return theInstance != null;
    }

    static UUIDCacheEntry resolve(String uuid) throws UnknownUUIDException {
        return UUIDResolver.resolve(uuid, (String)null);
    }

    static UUIDCacheEntry resolve(String uuid, String protocol) throws UnknownUUIDException {
        assert (theInstance != null);
        UUIDCacheEntry entry = UUIDResolver.theInstance.cache.get(uuid);
        if (entry != null && entry.getValidUntil() > TimeSync.getLocalSystemTime()) {
            entry.setLastAccess(TimeSync.getLocalSystemTime());
            return entry;
        }
        return theInstance.fetchUUID(uuid, protocol);
    }

    static UUIDCacheEntry resolve(String uuid, UUIDResolver nonSingleton) throws UnknownUUIDException {
        return UUIDResolver.resolve(uuid, null, nonSingleton);
    }

    static UUIDCacheEntry resolve(String uuid, String protocol, UUIDResolver nonSingleton) throws UnknownUUIDException {
        UUIDCacheEntry entry = nonSingleton.cache.get(uuid);
        if (entry != null && entry.getValidUntil() > TimeSync.getLocalSystemTime()) {
            entry.setLastAccess(TimeSync.getLocalSystemTime());
            return entry;
        }
        return nonSingleton.fetchUUID(uuid, protocol);
    }

    UUIDCacheEntry fetchUUID(String uuid) throws UnknownUUIDException {
        return this.fetchUUID(uuid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UUIDCacheEntry fetchUUID(String uuid, String protocol) throws UnknownUUIDException {
        if (this.dir == null) {
            throw new UnknownUUIDException("there is no mapping for " + uuid + ". Attention: local mode enabled, no remote lookup possible.");
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "loading uuid mapping for %s", uuid);
        }
        try {
            DIR.AddressMappingSet ams = this.dir.xtreemfs_address_mappings_get(null, GlobalConstants.AUTH_NONE, this.uc, uuid);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "sent request to DIR", new Object[0]);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "received response for %s", uuid);
            }
            if (ams.getMappingsCount() == 0) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "NO UUID MAPPING FOR: %s", uuid);
                }
                throw new UnknownUUIDException("uuid " + uuid + " is not registered at directory server");
            }
            List<DIR.AddressMapping> mappings = ams.getMappingsList();
            DIR.AddressMapping matchingAddress = null;
            List<String> list = this.myNetworks;
            synchronized (list) {
                for (DIR.AddressMapping addrMapping : mappings) {
                    String network = addrMapping.getMatchNetwork();
                    if (network.equals("*")) {
                        if (matchingAddress != null || protocol != null && !addrMapping.getProtocol().equals(protocol)) continue;
                        matchingAddress = addrMapping;
                        continue;
                    }
                    if (!this.myNetworks.contains(network) || protocol != null && !addrMapping.getProtocol().equals(protocol)) continue;
                    matchingAddress = addrMapping;
                    break;
                }
            }
            if (matchingAddress != null) {
                String address = matchingAddress.getAddress();
                String proto = matchingAddress.getProtocol();
                int port = matchingAddress.getPort();
                long validUntil = TimeSync.getLocalSystemTime() + (long)(matchingAddress.getTtlS() * 1000);
                InetSocketAddress endpoint = new InetSocketAddress(address, port);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "matching uuid record found for uuid " + uuid + " with network " + matchingAddress.getMatchNetwork(), new Object[0]);
                }
                UUIDCacheEntry e = new UUIDCacheEntry(uuid, validUntil, new Mapping(proto, endpoint, address + ":" + port));
                this.cache.put(uuid, e);
                return e;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "NO UUID MAPPING FOR: %s", uuid);
            }
            throw new UnknownUUIDException("there is no matching entry for my network in the uuid address mapping. The service at " + uuid + " is either not reachable from this machine or the mapping entry is misconfigured.");
        }
        catch (InterruptedException ex) {
            throw new UnknownUUIDException("cannot retrieve mapping from server due to IO error: " + ex);
        }
        catch (IOException ex) {
            throw new UnknownUUIDException("cannot retrieve mapping from server due to IO error: " + ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new UnknownUUIDException("cannot retrieve mapping from server due to invalid data sent by the server: " + ex);
        }
    }

    @Override
    public void run() {
        LinkedList<UUIDCacheEntry> updates = new LinkedList<UUIDCacheEntry>();
        do {
            Iterator<UUIDCacheEntry> iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                UUIDCacheEntry entry = iter.next();
                if (entry.isSticky()) continue;
                if (entry.getLastAccess() + (long)this.maxUnusedEntry < TimeSync.getLocalSystemTime()) {
                    iter.remove();
                    if (!Logging.isDebug()) continue;
                    Logging.logMessage(7, Logging.Category.misc, this, "removed entry from UUID cache: %s", entry.getUuid());
                    continue;
                }
                if (entry.getValidUntil() >= TimeSync.getLocalSystemTime() + (long)this.cacheCleanInterval) continue;
                try {
                    updates.add(this.fetchUUID(entry.getUuid()));
                }
                catch (Exception ex) {
                    Logging.logMessage(4, Logging.Category.misc, this, "cannot refresh UIID mapping: %s", ex.toString());
                    iter.remove();
                }
            }
            try {
                UUIDResolver.sleep(this.cacheCleanInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.quit);
    }

    public static void addLocalMapping(String localUUID, int port, String protocol) {
        assert (theInstance != null);
        UUIDCacheEntry e = UUIDResolver.theInstance.cache.get(localUUID);
        if (e == null) {
            e = new UUIDCacheEntry(localUUID, Long.MAX_VALUE, new Mapping(protocol, new InetSocketAddress("localhost", port), "localhost:" + port));
        } else {
            e.addMapping(new Mapping(protocol, new InetSocketAddress("localhost", port), "localhost:" + port));
        }
        e.setSticky(true);
        UUIDResolver.theInstance.cache.put(localUUID, e);
    }

    public static void addLocalMapping(ServiceUUID uuid, int port, String protocol) {
        UUIDResolver.addLocalMapping(uuid.toString(), port, protocol);
    }

    public static void addTestMapping(String uuid, String hostname, int port, boolean useSSL) {
        assert (theInstance != null);
        String protocol = useSSL ? "pbrpcs" : "pbrpc";
        UUIDCacheEntry e = UUIDResolver.theInstance.cache.get(uuid);
        if (e == null) {
            e = new UUIDCacheEntry(uuid, Long.MAX_VALUE, new Mapping(protocol, new InetSocketAddress(hostname, port), hostname + ":" + port));
        } else {
            e.addMapping(new Mapping(protocol, new InetSocketAddress(hostname, port), hostname + ":" + port));
        }
        e.setSticky(true);
        UUIDResolver.theInstance.cache.put(uuid, e);
    }

    public static String getCache() {
        StringBuilder sb = new StringBuilder();
        for (UUIDCacheEntry e : UUIDResolver.theInstance.cache.values()) {
            sb.append(e.getUuid());
            sb.append(" -> ");
            for (Mapping mapping : e.getMappings()) {
                sb.append(mapping.protocol);
                sb.append("://");
                sb.append(mapping.resolvedAddr);
                sb.append(" ");
            }
            if (e.isSticky()) {
                sb.append(" - STICKY");
            } else {
                sb.append(" - valid for ");
                sb.append((e.getValidUntil() - TimeSync.getLocalSystemTime()) / 1000L);
                sb.append("s");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void shutdown() {
        if (theInstance != null) {
            UUIDResolver.theInstance.quit = true;
            theInstance.interrupt();
            theInstance = null;
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, null, "UUIDREsolver shut down", new Object[0]);
            }
        } else if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, null, "UUIDREsolver was already shut down or is not running", new Object[0]);
        }
    }

    public static void renewNetworks() throws IOException {
        if (theInstance != null) {
            UUIDResolver.renewNetworks(theInstance);
        } else if (Logging.isDebug()) {
            Logging.logMessage(7, (Object)null, "Networks can't be renewed, because the UUIDResolver is not running.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renewNetworks(UUIDResolver instance) throws IOException {
        List<DIR.AddressMapping.Builder> ntwrks = NetUtils.getReachableEndpoints(0, "http");
        List<String> list = instance.myNetworks;
        synchronized (list) {
            instance.myNetworks.clear();
            for (DIR.AddressMapping.Builder network : ntwrks) {
                instance.myNetworks.add(network.getMatchNetwork());
            }
        }
    }
}

