/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.xloc;

import java.util.Iterator;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RAID0Impl
extends StripingPolicyImpl {
    protected final int stripe_size_in_bytes;

    RAID0Impl(GlobalTypes.Replica replica, int relOsdPosition) {
        super(replica, relOsdPosition);
        this.stripe_size_in_bytes = this.policy.getStripeSize() * 1024;
        if (this.stripe_size_in_bytes <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
    }

    @Override
    public long getObjectNoForOffset(long fileOffset) {
        return fileOffset / (long)this.stripe_size_in_bytes;
    }

    @Override
    public int getOSDforOffset(long fileOffset) {
        return this.getOSDforObject(this.getObjectNoForOffset(fileOffset));
    }

    @Override
    public int getOSDforObject(long objectNo) {
        return (int)(objectNo % (long)this.getWidth());
    }

    @Override
    public long getRow(long objectNo) {
        return objectNo / (long)this.getWidth();
    }

    @Override
    public long getObjectStartOffset(long objectNo) {
        return objectNo * (long)this.stripe_size_in_bytes;
    }

    @Override
    public long getObjectEndOffset(long objectNo) {
        return this.getObjectStartOffset(objectNo + 1L) - 1L;
    }

    public String toString() {
        return "StripingPolicy RAID0: " + this.policy;
    }

    @Override
    public int getStripeSizeForObject(long objectNo) {
        return this.stripe_size_in_bytes;
    }

    @Override
    public boolean isLocalObject(long objNo, int relativeOsdNo) {
        return objNo % (long)this.getWidth() == (long)relativeOsdNo;
    }

    @Override
    public Iterator<Long> getObjectsOfOSD(final int osdIndex, final long startObjectNo, final long endObjectNo) {
        return new Iterator<Long>(){
            private long object;
            {
                this.object = RAID0Impl.this.getRow(startObjectNo) * (long)RAID0Impl.this.getWidth() + (long)osdIndex - (long)RAID0Impl.this.getWidth();
            }

            @Override
            public boolean hasNext() {
                return this.object + (long)RAID0Impl.this.getWidth() <= endObjectNo;
            }

            @Override
            public Long next() {
                this.object += (long)RAID0Impl.this.getWidth();
                return this.object;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public long getLocalObjectNumber(long objectNo) {
        return this.getRow(objectNo);
    }

    @Override
    public long getGloablObjectNumber(long osdLocalObjNo) {
        return osdLocalObjNo * (long)this.getWidth() + (long)this.relOsdPosition;
    }
}

