/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.xloc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class Replica {
    List<ServiceUUID> osds;
    StripingPolicyImpl stripingPolicy;
    ServiceUUID localOSD;
    GlobalTypes.Replica replica;

    public Replica(GlobalTypes.Replica replica, ServiceUUID localOSD) {
        this.replica = replica;
        this.localOSD = localOSD;
    }

    public StripingPolicyImpl getStripingPolicy() {
        if (this.stripingPolicy == null) {
            int relOsdPosition = this.localOSD == null ? -1 : this.osds.indexOf(this.localOSD);
            this.stripingPolicy = StripingPolicyImpl.getPolicy(this.replica, relOsdPosition);
        }
        return this.stripingPolicy;
    }

    public List<ServiceUUID> getOSDs() {
        if (this.osds == null) {
            this.osds = new ArrayList<ServiceUUID>(this.replica.getOsdUuidsCount());
            for (String osd : this.replica.getOsdUuidsList()) {
                ServiceUUID uuid = new ServiceUUID(osd);
                this.osds.add(uuid);
            }
        }
        return this.osds;
    }

    public boolean isStriped() {
        return this.getStripingPolicy().getWidth() > 1;
    }

    public ServiceUUID getHeadOsd() {
        return new ServiceUUID(this.replica.getOsdUuids(0));
    }

    public String toString() {
        return "Replica " + this.stripingPolicy + ", " + this.replica + ", Flags: " + this.replica.getReplicationFlags() + ", OSD: " + this.osds;
    }

    public ServiceUUID getOSDForObject(long objectNo) {
        return this.getOSDs().get(this.getStripingPolicy().getOSDforObject(objectNo));
    }

    public ServiceUUID getOSDForOffset(long offset) {
        return this.getOSDs().get(this.getStripingPolicy().getOSDforOffset(offset));
    }

    public boolean containsOSD(ServiceUUID osd) {
        ServiceUUID o;
        boolean contained = false;
        Iterator<ServiceUUID> i$ = this.getOSDs().iterator();
        while (i$.hasNext() && !(contained = osd.equals(o = i$.next()))) {
        }
        return contained;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Replica) {
            return this.toString().equals(((Replica)obj).toString());
        }
        return false;
    }

    public int getTransferStrategyFlags() {
        return this.replica.getReplicationFlags();
    }

    public boolean isComplete() {
        return ReplicationFlags.isReplicaComplete(this.replica.getReplicationFlags());
    }

    public void resetCompleteFlagAndRestoreStrageyFlag() {
        int replFlags = this.replica.getReplicationFlags();
        replFlags &= ~GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber();
        replFlags = this.isPartialReplica() ? ReplicationFlags.setSequentialPrefetchingStrategy(replFlags) : ReplicationFlags.setRarestFirstStrategy(replFlags);
        this.replica = this.replica.toBuilder().setReplicationFlags(replFlags).build();
    }

    public boolean isPartialReplica() {
        return ReplicationFlags.isPartialReplica(this.replica.getReplicationFlags());
    }
}

