/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.xloc;

import org.xtreemfs.osd.replication.transferStrategies.RandomStrategy;
import org.xtreemfs.osd.replication.transferStrategies.RarestFirstStrategy;
import org.xtreemfs.osd.replication.transferStrategies.SequentialPrefetchingStrategy;
import org.xtreemfs.osd.replication.transferStrategies.SequentialStrategy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class ReplicationFlags {
    private static final int STRATEGY_BITS = SequentialStrategy.REPLICATION_FLAG.getNumber() | RandomStrategy.REPLICATION_FLAG.getNumber() | SequentialPrefetchingStrategy.REPLICATION_FLAG.getNumber() | RarestFirstStrategy.REPLICATION_FLAG.getNumber();
    private static final int OTHER_BITS = GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber() | GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber();

    public static int setReplicaIsComplete(int flags) {
        return flags | GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber();
    }

    public static int setReplicaIsNotComplete(int flags) {
        return flags & ~GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber();
    }

    public static int setPartialReplica(int flags) {
        return flags & ~GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber();
    }

    public static int setFullReplica(int flags) {
        return flags | GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber();
    }

    public static int setRandomStrategy(int flags) {
        return ReplicationFlags.resetStrategy(flags) | RandomStrategy.REPLICATION_FLAG.getNumber();
    }

    public static int setSequentialStrategy(int flags) {
        return ReplicationFlags.resetStrategy(flags) | SequentialStrategy.REPLICATION_FLAG.getNumber();
    }

    public static int setSequentialPrefetchingStrategy(int flags) {
        return ReplicationFlags.resetStrategy(flags) | SequentialPrefetchingStrategy.REPLICATION_FLAG.getNumber();
    }

    public static int setRarestFirstStrategy(int flags) {
        return ReplicationFlags.resetStrategy(flags) | RarestFirstStrategy.REPLICATION_FLAG.getNumber();
    }

    public static boolean isReplicaComplete(int flags) {
        return (flags & GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber()) == GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber();
    }

    public static boolean isPartialReplica(int flags) {
        return (flags & GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber()) == 0;
    }

    public static boolean isFullReplica(int flags) {
        return (flags & GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber()) == GlobalTypes.REPL_FLAG.REPL_FLAG_FULL_REPLICA.getNumber();
    }

    public static boolean isRandomStrategy(int flags) {
        return ReplicationFlags.resetOther(flags) == RandomStrategy.REPLICATION_FLAG.getNumber();
    }

    public static boolean isSequentialStrategy(int flags) {
        return ReplicationFlags.resetOther(flags) == SequentialStrategy.REPLICATION_FLAG.getNumber();
    }

    public static boolean isSequentialPrefetchingStrategy(int flags) {
        return ReplicationFlags.resetOther(flags) == SequentialPrefetchingStrategy.REPLICATION_FLAG.getNumber();
    }

    public static boolean isRarestFirstStrategy(int flags) {
        return ReplicationFlags.resetOther(flags) == RarestFirstStrategy.REPLICATION_FLAG.getNumber();
    }

    private static int resetStrategy(int flags) {
        return (flags | STRATEGY_BITS) ^ STRATEGY_BITS;
    }

    private static int resetOther(int flags) {
        return (flags | OTHER_BITS) ^ OTHER_BITS;
    }
}

