/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.xloc;

import java.util.Iterator;
import org.xtreemfs.common.xloc.RAID0Impl;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public abstract class StripingPolicyImpl {
    protected final GlobalTypes.StripingPolicy policy;
    protected final int relOsdPosition;

    StripingPolicyImpl(GlobalTypes.Replica replica, int relOsdPosition) {
        this.policy = replica.getStripingPolicy();
        this.relOsdPosition = relOsdPosition;
    }

    public static StripingPolicyImpl getPolicy(GlobalTypes.Replica replica, int relOsdPosition) {
        if (replica.getStripingPolicy().getType() == GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0) {
            return new RAID0Impl(replica, relOsdPosition);
        }
        throw new IllegalArgumentException("unknown striping polciy requested");
    }

    public int getWidth() {
        return this.policy.getWidth();
    }

    public int getPolicyId() {
        return this.policy.getType().getNumber();
    }

    public GlobalTypes.StripingPolicy getPolicy() {
        return this.policy;
    }

    public abstract long getObjectNoForOffset(long var1);

    public abstract int getOSDforOffset(long var1);

    public abstract int getOSDforObject(long var1);

    public abstract long getRow(long var1);

    public abstract long getObjectStartOffset(long var1);

    public abstract long getObjectEndOffset(long var1);

    public abstract int getStripeSizeForObject(long var1);

    public abstract boolean isLocalObject(long var1, int var3);

    public abstract long getLocalObjectNumber(long var1);

    public abstract long getGloablObjectNumber(long var1);

    public abstract Iterator<Long> getObjectsOfOSD(int var1, long var2, long var4);
}

