/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.xloc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class XLocations {
    private final GlobalTypes.XLocSet xloc;
    private Replica localReplica;
    private List<Replica> replicas;

    public XLocations(GlobalTypes.XLocSet xloc, ServiceUUID localOSD) throws InvalidXLocationsException {
        this.xloc = xloc;
        this.replicas = new ArrayList<Replica>(xloc.getReplicasCount());
        for (GlobalTypes.Replica replica : xloc.getReplicasList()) {
            this.replicas.add(new Replica(replica, null));
        }
        if (localOSD != null) {
            for (Replica replica : this.replicas) {
                if (!replica.getOSDs().contains(localOSD)) continue;
                this.localReplica = replica;
                break;
            }
            if (this.localReplica == null) {
                throw new InvalidXLocationsException("local OSD (" + localOSD + ") is not in any replica in XLocations list: " + xloc);
            }
        }
    }

    public GlobalTypes.XLocSet getXLocSet() {
        return this.xloc;
    }

    public int getVersion() {
        return this.xloc.getVersion();
    }

    public int getNumReplicas() {
        return this.xloc.getReplicasCount();
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public String getReplicaUpdatePolicy() {
        return this.xloc.getReplicaUpdatePolicy();
    }

    public Replica getLocalReplica() {
        return this.localReplica;
    }

    public Replica getReplica(int replicaNo) {
        return this.replicas.get(replicaNo);
    }

    public Replica getReplica(ServiceUUID osd) {
        for (Replica replica : this.getReplicas()) {
            for (ServiceUUID osd2 : replica.getOSDs()) {
                if (!osd.equals(osd2)) continue;
                return replica;
            }
        }
        return null;
    }

    public boolean containsOSD(ServiceUUID osd) {
        Replica r;
        boolean contained = false;
        Iterator<Replica> i$ = this.getReplicas().iterator();
        while (i$.hasNext() && !(contained = (r = i$.next()).containsOSD(osd))) {
        }
        return contained;
    }

    public List<ServiceUUID> getOSDsForObject(long objectNo, Replica localReplica) {
        ArrayList<ServiceUUID> osds = new ArrayList<ServiceUUID>();
        if (localReplica == null) {
            for (Replica replica : this.replicas) {
                osds.add(replica.getOSDForObject(objectNo));
            }
        } else {
            for (Replica replica : this.replicas) {
                if (localReplica == replica) continue;
                ServiceUUID osd = replica.getOSDForObject(objectNo);
                osds.add(osd);
            }
        }
        return osds;
    }

    public List<ServiceUUID> getOSDsForObject(long objectNo) {
        return this.getOSDsForObject(objectNo, null);
    }

    public String toString() {
        return "local replica: " + this.localReplica + ", other replicas: " + this.replicas;
    }
}

