/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.xtreemfs.foundation.TimeServerClient;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;

public class DIRClient
implements TimeServerClient {
    protected DIRServiceClient rpcClient;
    protected final InetSocketAddress[] servers;
    protected int currentServer;
    protected final int maxRetries;
    protected final int retryWaitMs;
    protected boolean redirectedBefore;
    protected final RPC.Auth auth;
    protected final RPC.UserCredentials user;

    public DIRClient(DIRServiceClient rpcClient, InetSocketAddress[] servers, int maxRetries, int retryWaitMs) {
        if (servers.length == 0) {
            throw new IllegalArgumentException("Must provide at least one directory service address.");
        }
        this.maxRetries = maxRetries;
        this.servers = servers;
        this.rpcClient = rpcClient;
        this.currentServer = 0;
        this.retryWaitMs = retryWaitMs;
        this.auth = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build();
        this.user = RPC.UserCredentials.newBuilder().setUsername("service").addGroups("xtreemfs").build();
    }

    public DIR.AddressMappingSet xtreemfs_address_mappings_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException, InterruptedException {
        return this.xtreemfs_address_mappings_get(server, authHeader, userCreds, uuid, this.maxRetries);
    }

    public DIR.AddressMappingSet xtreemfs_address_mappings_get(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String uuid, int maxRetries) throws IOException, InterruptedException {
        DIR.AddressMappingSet response = (DIR.AddressMappingSet)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_address_mappings_get(server, authHeader, userCreds, uuid);
            }
        }, maxRetries);
        return response;
    }

    public void xtreemfs_address_mappings_remove(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException, InterruptedException {
        this.xtreemfs_address_mappings_remove(server, authHeader, userCreds, uuid, this.maxRetries);
    }

    public void xtreemfs_address_mappings_remove(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String uuid, int maxRetries) throws IOException, InterruptedException {
        Object response = this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_address_mappings_remove(server, authHeader, userCreds, uuid);
            }
        }, maxRetries);
    }

    public DIR.addressMappingSetResponse xtreemfs_address_mappings_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, List<DIR.AddressMapping> mappings) throws IOException, InterruptedException {
        return this.xtreemfs_address_mappings_set(server, authHeader, userCreds, mappings, this.maxRetries);
    }

    public DIR.addressMappingSetResponse xtreemfs_address_mappings_set(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final List<DIR.AddressMapping> mappings, int maxRetries) throws IOException, InterruptedException {
        DIR.addressMappingSetResponse response = (DIR.addressMappingSetResponse)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_address_mappings_set(server, authHeader, userCreds, mappings);
            }
        }, maxRetries);
        return response;
    }

    public DIR.addressMappingSetResponse xtreemfs_address_mappings_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.AddressMappingSet input) throws IOException, InterruptedException {
        return this.xtreemfs_address_mappings_set(server, authHeader, userCreds, input, this.maxRetries);
    }

    public DIR.addressMappingSetResponse xtreemfs_address_mappings_set(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final DIR.AddressMappingSet input, int maxRetries) throws IOException, InterruptedException {
        DIR.addressMappingSetResponse response = (DIR.addressMappingSetResponse)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_address_mappings_set(server, authHeader, userCreds, input);
            }
        }, maxRetries);
        return response;
    }

    public void xtreemfs_service_deregister(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException, InterruptedException {
        this.xtreemfs_service_deregister(server, authHeader, userCreds, uuid, this.maxRetries);
    }

    public void xtreemfs_service_deregister(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String uuid, int maxRetries) throws IOException, InterruptedException {
        Object response = this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_deregister(server, authHeader, userCreds, uuid);
            }
        }, maxRetries);
    }

    public void xtreemfs_service_offline(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String name) throws IOException, InterruptedException {
        this.xtreemfs_service_offline(server, authHeader, userCreds, name, this.maxRetries);
    }

    public void xtreemfs_service_offline(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String name, int maxRetries) throws IOException, InterruptedException {
        Object response = this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_offline(server, authHeader, userCreds, name);
            }
        }, maxRetries);
    }

    public DIR.ServiceSet xtreemfs_service_get_by_name(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String name) throws IOException, InterruptedException {
        return this.xtreemfs_service_get_by_name(server, authHeader, userCreds, name, this.maxRetries);
    }

    public DIR.ServiceSet xtreemfs_service_get_by_name(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String name, int maxRetries) throws IOException, InterruptedException {
        DIR.ServiceSet response = (DIR.ServiceSet)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_get_by_name(server, authHeader, userCreds, name);
            }
        }, maxRetries);
        return response;
    }

    public DIR.ServiceSet xtreemfs_service_get_by_uuid(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException, InterruptedException {
        return this.xtreemfs_service_get_by_uuid(server, authHeader, userCreds, uuid, this.maxRetries);
    }

    public DIR.ServiceSet xtreemfs_service_get_by_uuid(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String uuid, int maxRetries) throws IOException, InterruptedException {
        DIR.ServiceSet response = (DIR.ServiceSet)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_get_by_uuid(server, authHeader, userCreds, uuid);
            }
        }, maxRetries);
        return response;
    }

    public DIR.ServiceSet xtreemfs_service_get_by_type(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.ServiceType type) throws IOException, InterruptedException {
        return this.xtreemfs_service_get_by_type(server, authHeader, userCreds, type, this.maxRetries);
    }

    public DIR.ServiceSet xtreemfs_service_get_by_type(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final DIR.ServiceType type, int maxRetries) throws IOException, InterruptedException {
        DIR.ServiceSet response = (DIR.ServiceSet)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_get_by_type(server, authHeader, userCreds, type);
            }
        }, maxRetries);
        return response;
    }

    public DIR.serviceRegisterResponse xtreemfs_service_register(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.Service service) throws IOException, InterruptedException {
        return this.xtreemfs_service_register(server, authHeader, userCreds, service, this.maxRetries);
    }

    public DIR.serviceRegisterResponse xtreemfs_service_register(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final DIR.Service service, int maxRetries) throws IOException, InterruptedException {
        DIR.serviceRegisterResponse response = (DIR.serviceRegisterResponse)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_service_register(server, authHeader, userCreds, service);
            }
        }, maxRetries);
        return response;
    }

    public DIR.Configuration xtreemfs_configuration_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException, InterruptedException {
        return this.xtreemfs_configuration_get(server, authHeader, userCreds, uuid, this.maxRetries);
    }

    public DIR.Configuration xtreemfs_configuration_get(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final String uuid, int maxRetries) throws IOException, InterruptedException {
        DIR.Configuration response = (DIR.Configuration)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_configuration_get(server, authHeader, userCreds, uuid);
            }
        }, maxRetries);
        return response;
    }

    public DIR.configurationSetResponse xtreemfs_configuration_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.Configuration config) throws IOException, InterruptedException {
        return this.xtreemfs_configuration_set(server, authHeader, userCreds, config, this.maxRetries);
    }

    public DIR.configurationSetResponse xtreemfs_configuration_set(InetSocketAddress server, final RPC.Auth authHeader, final RPC.UserCredentials userCreds, final DIR.Configuration config, int maxRetries) throws IOException, InterruptedException {
        DIR.configurationSetResponse response = (DIR.configurationSetResponse)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_configuration_set(server, authHeader, userCreds, config);
            }
        }, maxRetries);
        return response;
    }

    @Override
    public long xtreemfs_global_time_get(InetSocketAddress server) {
        try {
            return this.xtreemfs_global_time_get();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public long xtreemfs_global_time_get() throws InterruptedException, PBRPCException, IOException {
        DIR.globalTimeSGetResponse response = (DIR.globalTimeSGetResponse)this.syncCall(new CallGenerator(){

            @Override
            public RPCResponse executeCall(DIRServiceClient client, InetSocketAddress server) throws IOException {
                return client.xtreemfs_global_time_s_get(server, DIRClient.this.auth, DIRClient.this.user);
            }
        }, 1);
        return response.getTimeInSeconds();
    }

    public boolean clientIsAlive() {
        return this.rpcClient.clientIsAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Object syncCall(CallGenerator call, int maxRetries) throws InterruptedException, PBRPCException, IOException {
        if (!DIRClient.$assertionsDisabled && maxRetries == 0) {
            throw new AssertionError((Object)"Current DIRClient implementation supports no infinite retries.");
        }
        server = null;
        this.redirectedBefore = false;
        numTries = 1;
        lastException = null;
        while (numTries <= maxRetries) {
            countRedirectAsRetry = this.redirectedBefore;
            var7_7 = this;
            synchronized (var7_7) {
                server = this.servers[this.currentServer];
            }
            response = null;
            try {
                response = call.executeCall(this.rpcClient, server);
                var9_12 = result = response.get();
                return var9_12;
            }
            catch (PBRPCException ex) {
                switch (14.$SwitchMap$org$xtreemfs$foundation$pbrpc$generatedinterfaces$RPC$ErrorType[ex.getErrorType().ordinal()]) {
                    case 1: {
                        lastException = ex;
                        if (numTries <= maxRetries) {
                            this.redirect(ex);
                            ** break;
lbl28:
                            // 1 sources

                        } else {
                            countRedirectAsRetry = true;
                            ** break;
                        }
lbl31:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        throw ex;
                    }
                    default: {
                        lastException = ex;
                        if (numTries <= maxRetries) {
                            this.failover(ex);
                        }
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logging.logMessage(7, Logging.Category.net, this, "Request failed due to exception: %s", new Object[]{ex});
                lastException = ex;
                if (numTries <= maxRetries) {
                    this.failover(ex);
                }
            }
            finally {
                if (response != null) {
                    response.freeBuffers();
                }
            }
            if (lastException instanceof PBRPCException && (lastException.getErrorType() != RPC.ErrorType.REDIRECT || !countRedirectAsRetry)) continue;
            ++numTries;
        }
        throw new IOException("Request finally failed after " + (numTries - 1) + " tries.", lastException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redirect(PBRPCException exception) throws InterruptedException {
        assert (exception.getErrorType() == RPC.ErrorType.REDIRECT);
        String address = exception.getRedirectToServerUUID();
        try {
            int colon = address.indexOf(58);
            String hostname = address.substring(0, colon);
            String portStr = address.substring(colon + 1);
            int port = Integer.valueOf(portStr);
            InetSocketAddress redirectTo = new InetSocketAddress(hostname, port);
            for (int i = 0; i < this.servers.length; ++i) {
                InetSocketAddress server = this.servers[i];
                if (!server.equals(redirectTo)) continue;
                Logging.logMessage(7, Logging.Category.net, this, "redirected to DIR: %s", server);
                DIRClient dIRClient = this;
                synchronized (dIRClient) {
                    this.currentServer = i;
                }
                if (this.redirectedBefore) {
                    Thread.sleep(this.retryWaitMs);
                } else {
                    this.redirectedBefore = true;
                }
                return;
            }
            throw new IOException("Cannot redirect to unknown server: " + redirectTo);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Logging.logError(3, this, ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failover(IOException exception) throws InterruptedException {
        Thread.sleep(this.retryWaitMs);
        DIRClient dIRClient = this;
        synchronized (dIRClient) {
            ++this.currentServer;
            if (this.currentServer >= this.servers.length) {
                this.currentServer = 0;
            }
        }
        Logging.logMessage(7, Logging.Category.net, this, "Switching to server %s since the last attempt failed with the error: %s", this.servers[this.currentServer], exception.getMessage());
    }

    static class 14 {
        static final /* synthetic */ int[] $SwitchMap$org$xtreemfs$foundation$pbrpc$generatedinterfaces$RPC$ErrorType;

        static {
            $SwitchMap$org$xtreemfs$foundation$pbrpc$generatedinterfaces$RPC$ErrorType = new int[RPC.ErrorType.values().length];
            try {
                14.$SwitchMap$org$xtreemfs$foundation$pbrpc$generatedinterfaces$RPC$ErrorType[RPC.ErrorType.REDIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                14.$SwitchMap$org$xtreemfs$foundation$pbrpc$generatedinterfaces$RPC$ErrorType[RPC.ErrorType.ERRNO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected static interface CallGenerator {
        public RPCResponse executeCall(DIRServiceClient var1, InetSocketAddress var2) throws IOException;
    }
}

