/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xtreemfs.common.config.ServiceConfig;

public class DIRConfig
extends ServiceConfig {
    private final ServiceConfig.Parameter[] dirParameter = new ServiceConfig.Parameter[]{ServiceConfig.Parameter.DEBUG_LEVEL, ServiceConfig.Parameter.DEBUG_CATEGORIES, ServiceConfig.Parameter.PORT, ServiceConfig.Parameter.HTTP_PORT, ServiceConfig.Parameter.LISTEN_ADDRESS, ServiceConfig.Parameter.USE_SSL, ServiceConfig.Parameter.SSL_PROTOCOL_STRING, ServiceConfig.Parameter.SERVICE_CREDS_FILE, ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE, ServiceConfig.Parameter.SERVICE_CREDS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_FILE, ServiceConfig.Parameter.TRUSTED_CERTS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE, ServiceConfig.Parameter.TRUST_MANAGER, ServiceConfig.Parameter.USE_GRID_SSL_MODE, ServiceConfig.Parameter.UUID, ServiceConfig.Parameter.WAIT_FOR_DIR, ServiceConfig.Parameter.ADMIN_PASSWORD, ServiceConfig.Parameter.AUTODISCOVER_ENABLED, ServiceConfig.Parameter.MONITORING_ENABLED, ServiceConfig.Parameter.ADMIN_EMAIL, ServiceConfig.Parameter.SENDER_ADDRESS, ServiceConfig.Parameter.MAX_WARNINGS, ServiceConfig.Parameter.TIMEOUT_SECONDS, ServiceConfig.Parameter.SENDMAIL_BIN, ServiceConfig.Parameter.POLICY_DIR, ServiceConfig.Parameter.USE_SNMP, ServiceConfig.Parameter.SNMP_ADDRESS, ServiceConfig.Parameter.SNMP_PORT, ServiceConfig.Parameter.SNMP_ACL, ServiceConfig.Parameter.VIVALDI_MAX_CLIENTS, ServiceConfig.Parameter.VIVALDI_CLIENT_TIMEOUT};
    private Map<String, Integer> mirrors;

    public DIRConfig(String filename) throws IOException {
        super(filename);
        this.read();
    }

    public DIRConfig(Properties prop) throws IOException {
        super(prop);
        this.read();
    }

    public void read() throws IOException {
        String host;
        for (ServiceConfig.Parameter param : this.dirParameter) {
            this.parameter.put(param, this.readParameter(param));
        }
        this.mirrors = new HashMap<String, Integer>();
        if (this.getAddress() != null) {
            this.mirrors.put(this.getAddress().getHostAddress(), this.getPort());
        }
        int id = 0;
        while ((host = this.readOptionalString("babudb.repl.participant." + id, null)) != null) {
            int port = this.readRequiredInt("babudb.repl.participant." + id + ".dirPort");
            InetSocketAddress addrs = new InetSocketAddress(host, port);
            this.mirrors.put(addrs.getAddress().getHostAddress(), port);
            ++id;
        }
    }

    public boolean isAutodiscoverEnabled() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.AUTODISCOVER_ENABLED);
    }

    public boolean isMonitoringEnabled() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.MONITORING_ENABLED);
    }

    public String getAdminEmail() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.ADMIN_EMAIL);
    }

    public String getSenderAddress() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.SENDER_ADDRESS);
    }

    public int getMaxWarnings() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.MAX_WARNINGS);
    }

    public int getTimeoutSeconds() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.TIMEOUT_SECONDS);
    }

    public String getSendmailBin() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.SENDMAIL_BIN);
    }

    public Map<String, Integer> getMirrors() {
        return this.mirrors;
    }

    public void setDefaults() {
        super.setDefaults(this.dirParameter);
    }

    public void checkConfig() {
        super.checkConfig(this.dirParameter);
    }

    public int getVivaldiMaxClients() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_MAX_CLIENTS);
    }

    public int getVivaldiClientTimeout() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_CLIENT_TIMEOUT);
    }
}

