/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.RequestDetails;

public class DIRRequest {
    private final RPCServerRequest rpcRequest;
    private Message requestMessage;
    private RequestDetails details;

    public DIRRequest(RPCServerRequest rpcRequest) {
        this.rpcRequest = rpcRequest;
        this.details = new RequestDetails();
    }

    public void deserializeMessage(Message message) throws IOException {
        ReusableBuffer payload = this.rpcRequest.getMessage();
        if (message != null) {
            if (payload != null) {
                ReusableBufferInputStream istream = new ReusableBufferInputStream(payload);
                this.requestMessage = message.newBuilderForType().mergeFrom(istream).build();
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "parsed request: %s", message.getClass().getSimpleName());
                }
            } else {
                this.requestMessage = message.getDefaultInstanceForType();
            }
        } else {
            this.requestMessage = null;
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "parsed request: empty message (emptyRequest)", new Object[0]);
            }
        }
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void sendSuccess(Message response) {
        try {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "sending response: %s", response.getClass().getSimpleName());
            }
            this.rpcRequest.sendResponse(response, null);
        }
        catch (IOException ex) {
            Logging.logError(3, this, ex);
        }
    }

    public void sendInternalServerError(Throwable rootCause) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, "sending internal server error: " + rootCause.toString(), new Object[0]);
        }
        this.rpcRequest.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "internal server error: " + rootCause.toString(), OutputUtils.stackTraceToString(rootCause));
    }

    public void sendRedirectException(String addr, int port) {
        this.rpcRequest.sendRedirect(addr + ":" + port);
    }

    public void sendError(RPC.ErrorType type, RPC.POSIXErrno error, String message) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, "sending error return value: " + type + "/" + error + "/" + message, new Object[0]);
        }
        this.rpcRequest.sendError(type, error, message);
    }

    public RequestDetails getDetails() {
        return this.details;
    }

    public void setDetails(RequestDetails details) {
        this.details = details;
    }

    public RPCServerRequest getRPCRequest() {
        return this.rpcRequest;
    }
}

