/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.xtreemfs.babudb.BabuDBFactory;
import org.xtreemfs.babudb.api.BabuDB;
import org.xtreemfs.babudb.api.DatabaseManager;
import org.xtreemfs.babudb.api.SnapshotManager;
import org.xtreemfs.babudb.api.StaticInitialization;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.common.config.PolicyContainer;
import org.xtreemfs.common.monitoring.StatusMonitor;
import org.xtreemfs.common.statusserver.BabuDBStatusPage;
import org.xtreemfs.common.statusserver.PrintStackTrace;
import org.xtreemfs.common.statusserver.StatusServer;
import org.xtreemfs.dir.DIRConfig;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRStatusListener;
import org.xtreemfs.dir.MonitoringThread;
import org.xtreemfs.dir.ReplicaStatusPage;
import org.xtreemfs.dir.StatusPage;
import org.xtreemfs.dir.VivaldiClientMap;
import org.xtreemfs.dir.VivaldiStatusPage;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.data.ServiceRecords;
import org.xtreemfs.dir.discovery.DiscoveryMsgThread;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.dir.operations.DeleteAddressMappingOperation;
import org.xtreemfs.dir.operations.DeregisterServiceOperation;
import org.xtreemfs.dir.operations.GetAddressMappingOperation;
import org.xtreemfs.dir.operations.GetConfigurationOperation;
import org.xtreemfs.dir.operations.GetGlobalTimeOperation;
import org.xtreemfs.dir.operations.GetServiceByNameOperation;
import org.xtreemfs.dir.operations.GetServiceByUuidOperation;
import org.xtreemfs.dir.operations.GetServicesByTypeOperation;
import org.xtreemfs.dir.operations.RegisterServiceOperation;
import org.xtreemfs.dir.operations.ServiceOfflineOperation;
import org.xtreemfs.dir.operations.SetAddressMappingOperation;
import org.xtreemfs.dir.operations.SetConfigurationOperation;
import org.xtreemfs.dir.operations.UpdateVivaldiClientOperation;
import org.xtreemfs.foundation.CrashReporter;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServer;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequestListener;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class DIRRequestDispatcher
extends LifeCycleThread
implements RPCServerRequestListener,
LifeCycleListener {
    public static final int INDEX_ID_ADDRMAPS = 0;
    public static final int INDEX_ID_SERVREG = 1;
    public static final int INDEX_ID_CONFIGURATIONS = 2;
    public static final int DB_VERSION = 2010111010;
    protected final StatusServer statusServer;
    private int numRequests;
    private final Map<Integer, DIROperation> registry;
    private final RPCNIOSocketServer server;
    private final BlockingQueue<RPCServerRequest> queue;
    private volatile boolean quit;
    private final BabuDB database;
    private final DiscoveryMsgThread discoveryThr;
    private final MonitoringThread monThr;
    private final DIRConfig config;
    public static final String DB_NAME = "dirdb";
    private List<DIRStatusListener> statusListener;
    private VivaldiClientMap vivaldiClientMap;

    public DIRRequestDispatcher(DIRConfig config, BabuDBConfig dbsConfig) throws IOException, BabuDBException {
        super("DIR RqDisp");
        this.config = config;
        Logging.logMessage(6, this, "XtreemFS Direcory Service version 1.5.0-master", new Object[0]);
        this.registry = new HashMap<Integer, DIROperation>();
        this.vivaldiClientMap = new VivaldiClientMap(config.getVivaldiMaxClients(), config.getVivaldiClientTimeout());
        this.database = BabuDBFactory.createBabuDB((BabuDBConfig)dbsConfig, (StaticInitialization)new StaticInitialization(){

            public void initialize(DatabaseManager dbMan, SnapshotManager sMan) {
                DIRRequestDispatcher.this.initDB(dbMan, sMan);
            }
        });
        this.registerOperations();
        SSLOptions sslOptions = null;
        if (config.isUsingSSL()) {
            PolicyContainer policyContainer = new PolicyContainer(config);
            SSLOptions.TrustManager tm = null;
            try {
                tm = policyContainer.getTrustManager();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            sslOptions = new SSLOptions(new FileInputStream(config.getServiceCredsFile()), config.getServiceCredsPassphrase(), config.getServiceCredsContainer(), new FileInputStream(config.getTrustedCertsFile()), config.getTrustedCertsPassphrase(), config.getTrustedCertsContainer(), false, config.isGRIDSSLmode(), config.getSSLProtocolString(), tm);
            if (Logging.isInfo() && tm != null) {
                Logging.logMessage(6, Logging.Category.misc, this, "using custom trust manager '%s'", tm.getClass().getName());
            }
        }
        this.queue = new LinkedBlockingQueue<RPCServerRequest>();
        this.quit = false;
        this.server = new RPCNIOSocketServer(config.getPort(), config.getAddress(), this, sslOptions);
        this.server.setLifeCycleListener(this);
        if (config.isAutodiscoverEnabled()) {
            String scheme = "pbrpc";
            if (config.isGRIDSSLmode()) {
                scheme = "pbrpcg";
            } else if (config.isUsingSSL()) {
                scheme = "pbrpcs";
            }
            this.discoveryThr = new DiscoveryMsgThread(InetAddress.getLocalHost().getCanonicalHostName(), config.getPort(), scheme);
            this.discoveryThr.setLifeCycleListener(this);
        } else {
            this.discoveryThr = null;
        }
        if (config.getHttpPort() == -1) {
            this.statusServer = null;
        } else {
            this.statusServer = new StatusServer(DIR.ServiceType.SERVICE_TYPE_DIR, this, config.getHttpPort());
            this.statusServer.registerModule(new PrintStackTrace());
            this.statusServer.registerModule(new StatusPage(config));
            this.statusServer.registerModule(new ReplicaStatusPage());
            this.statusServer.registerModule(new VivaldiStatusPage(config));
            this.statusServer.registerModule(new BabuDBStatusPage(new BabuDBStatusPage.BabuDBStatusProvider(){

                @Override
                public Map<String, Object> getStatus() {
                    return DIRRequestDispatcher.this.database.getRuntimeState();
                }
            }));
            if (config.getAdminPassword().length() > 0) {
                this.statusServer.addAuthorizedUser("admin", config.getAdminPassword());
            }
            this.statusServer.start();
        }
        this.numRequests = 0;
        if (config.isMonitoringEnabled()) {
            this.monThr = new MonitoringThread(config, this);
            this.monThr.setLifeCycleListener(this);
        } else {
            this.monThr = null;
        }
        this.statusListener = new ArrayList<DIRStatusListener>();
        if (config.isUsingSnmp().booleanValue()) {
            this.statusListener.add(new StatusMonitor(this, config.getSnmpAddress(), (int)config.getSnmpPort(), config.getSnmpACLFile()));
            this.notifyConfigurationChange();
        }
        try {
            for (ServiceRecord sRec : this.getServices().getList()) {
                this.notifyServiceRegistred(sRec.getUuid(), sRec.getName(), sRec.getType().toString(), "", "", 0L, 0L, sRec.getLast_updated_s(), 0, 0, 0);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(7, Logging.Category.stage, this, ": %s", ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.notifyStarted();
            while (!this.quit) {
                RPCServerRequest rq = this.queue.take();
                BabuDB babuDB = this.database;
                synchronized (babuDB) {
                    this.processRequest(rq);
                }
            }
        }
        catch (InterruptedException ex) {
            this.quit = true;
        }
        catch (Throwable ex) {
            String report = CrashReporter.createCrashReport("DIR", "1.5.0-master", ex);
            System.out.println(report);
            CrashReporter.reportXtreemFSCrash(report);
            this.notifyCrashed(ex);
            System.exit(2);
        }
        this.notifyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRecords getServices() throws Exception {
        BabuDB babuDB = this.database;
        synchronized (babuDB) {
            Database db = this.getDirDatabase();
            Iterator iter = (Iterator)db.prefixLookup(1, new byte[0], null).get();
            ServiceRecords services = new ServiceRecords();
            while (iter.hasNext()) {
                Map.Entry e = (Map.Entry)iter.next();
                ServiceRecord servEntry = new ServiceRecord(ReusableBuffer.wrap((byte[])e.getValue()));
                services.add(servEntry);
            }
            return services;
        }
    }

    public void startup() throws Exception {
        this.start();
        this.server.start();
        this.server.waitForStartup();
        if (this.discoveryThr != null) {
            this.discoveryThr.start();
            this.discoveryThr.waitForStartup();
        }
        if (this.monThr != null) {
            this.monThr.start();
            this.monThr.waitForStartup();
        }
    }

    @Override
    public void shutdown() throws Exception {
        for (DIRStatusListener listener : this.statusListener) {
            listener.shuttingDown();
        }
        if (this.statusServer != null) {
            this.statusServer.shutdown();
        }
        this.server.shutdown();
        this.server.waitForShutdown();
        this.database.shutdown();
        if (this.discoveryThr != null) {
            this.discoveryThr.shutdown();
            this.discoveryThr.waitForShutdown();
        }
        if (this.monThr != null) {
            this.monThr.shutdown();
            this.monThr.waitForShutdown();
        }
        this.quit = true;
        this.interrupt();
        this.waitForShutdown();
    }

    private void registerOperations() throws BabuDBException {
        DIROperation op = new GetGlobalTimeOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new GetAddressMappingOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new SetAddressMappingOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new DeleteAddressMappingOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new RegisterServiceOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new DeregisterServiceOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new GetServiceByUuidOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new GetServicesByTypeOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new GetServiceByNameOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new ServiceOfflineOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new SetConfigurationOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new GetConfigurationOperation(this);
        this.registry.put(op.getProcedureId(), op);
        op = new UpdateVivaldiClientOperation(this);
        this.registry.put(op.getProcedureId(), op);
    }

    public Database getDirDatabase() throws BabuDBException {
        return this.database.getDatabaseManager().getDatabase(DB_NAME);
    }

    @Override
    public void receiveRecord(RPCServerRequest rq) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "received new request: %s", rq.toString());
        }
        this.queue.add(rq);
    }

    public void processRequest(RPCServerRequest rq) {
        RPC.RPCHeader hdr = rq.getHeader();
        if (hdr.getMessageType() != RPC.MessageType.RPC_REQUEST) {
            rq.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EIO, "expected RPC request message type but got " + hdr.getMessageType());
            return;
        }
        RPC.RPCHeader.RequestHeader rqHdr = hdr.getRequestHeader();
        if (rqHdr.getInterfaceId() != 10001) {
            rq.sendError(RPC.ErrorType.INVALID_INTERFACE_ID, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid interface id. This is a DIR service. You probably wanted to contact another service. Check the used address and port.");
            return;
        }
        DIROperation op = this.registry.get(rqHdr.getProcId());
        if (op == null) {
            rq.sendError(RPC.ErrorType.INVALID_PROC_ID, RPC.POSIXErrno.POSIX_ERROR_EIO, "unknown procedure id requested");
            return;
        }
        DIRRequest dirRq = new DIRRequest(rq);
        try {
            op.parseRPCMessage(dirRq);
            ++this.numRequests;
            op.startRequest(dirRq);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            rq.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "internal server error: " + ex.toString(), OutputUtils.stackTraceToString(ex));
            return;
        }
    }

    @Override
    public void startupPerformed() {
    }

    @Override
    public void shutdownPerformed() {
    }

    @Override
    public void crashPerformed(Throwable cause) {
        String report = CrashReporter.createCrashReport("DIR", "1.5.0-master", cause);
        System.out.println(report);
        CrashReporter.reportXtreemFSCrash(report);
        try {
            this.shutdown();
        }
        catch (Exception e) {
            Logging.logError(3, this, e);
        }
    }

    public long getNumRequests() {
        return this.server.getPendingRequests();
    }

    public int getNumConnections() {
        return this.server.getNumConnections();
    }

    public VivaldiClientMap getVivaldiClientMap() {
        return this.vivaldiClientMap;
    }

    public DIRConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDB(DatabaseManager dbMan, SnapshotManager sMan) {
        block20: {
            byte[] versionKey = "version".getBytes();
            try {
                Database db = dbMan.createDatabase("dirdbver", 2);
                ReusableBuffer rb = null;
                try {
                    byte[] keyData = new byte[4];
                    rb = ReusableBuffer.wrap(keyData);
                    rb.putInt(2010111010);
                    db.singleInsert(0, versionKey, keyData, null).get();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("cannot initialize database");
                    System.exit(1);
                }
                finally {
                    if (rb != null) {
                        BufferPool.free(rb);
                    }
                }
            }
            catch (BabuDBException ex) {
                if (ex.getErrorCode() == BabuDBException.ErrorCode.DB_EXISTS) {
                    ReusableBuffer rb = null;
                    try {
                        Database db = dbMan.getDatabase("dirdbver");
                        byte[] value = (byte[])db.lookup(0, versionKey, null).get();
                        int ver = -1;
                        if (value != null && value.length == 4) {
                            rb = ReusableBuffer.wrap(value);
                            ver = rb.getInt();
                        }
                        if (ver != 2010111010) {
                            Logging.logMessage(3, this, "OUTDATED DATABASE VERSION DETECTED!", new Object[0]);
                            Logging.logMessage(3, this, "the database was created contains data with version no %d, this DIR uses version %d.", ver, 2010111010);
                            Logging.logMessage(3, this, "please start an older version of the DIR or remove the old database", new Object[0]);
                            System.exit(1);
                        }
                        if (rb != null) {
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                        System.err.println("cannot initialize database");
                        System.exit(1);
                        break block20;
                    }
                    BufferPool.free(rb);
                    finally {
                        if (rb != null) {
                            BufferPool.free(rb);
                        }
                    }
                }
                ex.printStackTrace();
                System.err.println("cannot initialize database");
                System.exit(1);
            }
        }
        try {
            dbMan.createDatabase(DB_NAME, 3);
            return;
        }
        catch (BabuDBException ex) {
            // empty catch block
        }
    }

    public void addStatusListener(DIRStatusListener listener) {
        this.statusListener.add(listener);
    }

    public void removeStatusListener(DIRStatusListener listener) {
        this.statusListener.remove(listener);
    }

    public void notifyAddressMappingAdded(String uuid, String uri) {
        for (DIRStatusListener listener : this.statusListener) {
            listener.addressMappingAdded();
        }
    }

    public void notifyAddressMappingDeleted(String uuid, String uri) {
        for (DIRStatusListener listener : this.statusListener) {
            listener.addressMappingDeleted();
        }
    }

    public void notifyConfigurationChange() {
        for (DIRStatusListener listener : this.statusListener) {
            listener.DIRConfigChanged(this.config);
        }
    }

    public void notifyServiceRegistred(String uuid, String name, String type, String pageUrl, String geoCoordinates, long totalRam, long usedRam, long lastUpdated, int status, int load, int protoVersion) {
        for (DIRStatusListener listener : this.statusListener) {
            listener.serviceRegistered();
        }
    }

    public void notifyServiceDeregistred(String uuid) {
        for (DIRStatusListener listener : this.statusListener) {
            listener.serviceDeregistered();
        }
    }
}

